package com.mobgame.utils;

import android.app.Application;
import android.content.Context;
import android.util.Log;

import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerLib;
import com.mobgame.MobGameSDK;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.GameConfigManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;


/**
 * Created by Pc 02 on 2/24/2018.
 */

public class FunAppsFlyerUtil {
    private static FunAppsFlyerUtil instance;
    private String appsflyerDevkey = "cfgYFoj97okaEbzqp8q5w5";
    private String gcmSenderId = "461098885975";
    private String TAG = "FunAppsFlyerUtil";
    private Map<String, Object> conversionDataLoaded;
    private ArrayList<String> listTrackEventQueue = new ArrayList<>();
    private boolean initted;

    /*Tracking Appsflyer key*/
    public static final String STR_EVENT_LAUNCHER = "app_launcher";
    private static final String TRACK_FIRST_LAUNCH = "ft_first_launch";
    private static final String TRACK_DOWNLOAD_RES_STARTED = "ft_res_dl_started";
    private static final String TRACK_DOWNLOAD_RES_FAILED = "ft_res_dl_failed";
    private static final String TRACK_DOWNLOAD_RES_FINISHED = "ft_res_dl_completed";
    private static final String TRACK_CHARACTOR_CREATED = "ft_character_created";
    private static final String TRACK_START_TUTORIAL = "af_tutorial_started";
    private static final String TRACK_FINISH_TUTORIAL = "af_tutorial_completed";
    private static final String TRACK_REACH_A_LEVEL = "af_level_achieved";
    private static final String TRACK_LEVEL_PLATFORM = "ft_level_platform";
    public static final String TRACK_LOGIN_CLICKED = "ft_login_clicked";
    public static final String TRACK_LOGIN_CLOSED = "ft_login_closed";
    public static final String TRACK_LOGIN_SUCCESS = "ft_login_success";
    public static final String TRACK_PAYMENT_OPEN = "ft_payment_opened";
    public static final String TRACK_PAYMENT_CLOSE = "ft_payment_closed";
    public static final String TRACK_EVENT_LOGOUT = "ft_logout";

    private FunAppsFlyerUtil() {

    }

    public synchronized static FunAppsFlyerUtil getInstance() {
        if (instance == null) {
            instance = new FunAppsFlyerUtil();
        }
        return instance;
    }

    public void init(final Application context) {
        try {
            Log.i(TAG, "initAppsFlyer");
            AppsFlyerLib.getInstance().enableUninstallTracking(gcmSenderId);
            MobGameSDK.applicationContext = context;
            AppsFlyerLib.getInstance().setDebugLog(true);
            AppsFlyerConversionListener conversionDataListener =
                    new AppsFlyerConversionListener() {

                        @Override
                        public void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                            try {
                                initted = true;
                                Map<String, Object> map = new HashMap<String, Object>(conversionData);
                                conversionDataLoaded = map;
                                //send tracking app_launcher and first_launch
                                trackEvent(context, STR_EVENT_LAUNCHER, map);
                                for (String attrName : conversionData.keySet()) {
                                    Log.d(TAG, "onInstallConversionDataLoaded attribute: " + attrName + " = " + conversionData.get(attrName));
                                    if (attrName.equals("is_first_launch") && conversionData.get(attrName).equals("true")) {
                                        trackEvent(context, TRACK_FIRST_LAUNCH, map);
                                    }
                                }
                                //send tracking queue:
                                if (listTrackEventQueue != null) {
                                    map.put("Resend", "when inited");
                                    for (String eventName : listTrackEventQueue) {
                                        trackEvent(context, eventName, map);
                                    }
                                    listTrackEventQueue.clear();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onInstallConversionFailure(String errorMessage) {
                            initted = false;
                            Log.d(TAG, " onInstallConversionFailure error getting conversion data: " + errorMessage);
                        }

                        @Override
                        public void onAppOpenAttribution(Map<String, String> conversionData) {
                            for (String attrName : conversionData.keySet()) {
                                Log.d(TAG, "onAppOpenAttribution attribute: " + attrName + " = " + conversionData.get(attrName));
                            }
                        }

                        @Override
                        public void onAttributionFailure(String errorMessage) {
                            Log.d(TAG, " onAttributionFailure error onAttributionFailure : " + errorMessage);
                        }
                    };
            AppsFlyerLib.getInstance().init(appsflyerDevkey, conversionDataListener, context);
            AppsFlyerLib.getInstance().startTracking(context);
            new Thread(new Runnable() {
                @Override
                public void run() {
                    if (MobGameSDK.getInstance().isLoggedIn()) {
                        EventClientManager.getInstance(context).saveEventClient(EventClientManager.SAVE_EVENT_START_SESSION, STR_EVENT_LAUNCHER, null);
                    } else {
                        EventClientManager.getInstance(context).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, STR_EVENT_LAUNCHER, null);
                    }
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        try {
            if (initted) {
                HashMap<String, Object> map = new HashMap<>(conversionDataLoaded);
                if (eventValues != null)
                    map.putAll(eventValues);
                AppsFlyerLib.getInstance().trackEvent(context, eventName, map);
                Log.d(TAG, "trackEvent: " + eventName + " eventValue: " + map);
                if (Preference.getBoolean(context, eventName, true)) {
                    AppsFlyerLib.getInstance().trackEvent(context, eventName + "_first", map);
                    Preference.save(context, eventName, false);
                }
            } else {
                Log.d(TAG, "trackEvent " + eventName + " fail cause of AppsflyerLib is not inited successful");
                listTrackEventQueue.add(eventName);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceStarted(Context context) {
        try {
            //bắt đầu download resource. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
            String gameVersionName = Utils.getGameVersion(context);
            String gameVersionCode = Utils.getGameVersionCode(context);
            String versionsave = Preference.getString(context, "GAME_VERSION");
            if (!versionsave.equals(gameVersionCode)) {
                HashMap<String, Object> map = new HashMap<>();
                map.put("version name", gameVersionName);
                map.put("version code", gameVersionCode);
                trackEvent(context, TRACK_DOWNLOAD_RES_STARTED, map);
            } else Log.d(TAG, "trackDownloadResourceStarted dont call because it is same version");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceFinished(Context context) {
        //kết thúc download resource. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
        String gameVersionName = Utils.getGameVersion(context);
        String gameVersionCode = Utils.getGameVersionCode(context);
        String versionsave = Preference.getString(context, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            trackEvent(context, TRACK_DOWNLOAD_RES_FINISHED, map);
        } else Log.d(TAG, "trackDownloadResourceFinished dont call because it is same version");
        Preference.save(context, "GAME_VERSION", gameVersionCode);
    }

    public void trackDownloadResourceFailed(Context context) {
        //download resource thất bại. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
        String gameVersionName = Utils.getGameVersion(context);
        String gameVersionCode = Utils.getGameVersionCode(context);
        String versionsave = Preference.getString(context, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            trackEvent(context, TRACK_DOWNLOAD_RES_FAILED, map);
        } else Log.d(TAG, "trackDownloadResourceFailed dont call because it is same version");
    }

    public void trackStartTutorial(Context context) {
        trackEvent(context, TRACK_START_TUTORIAL, null);
    }

    public void trackFinishTutorial(Context context) {
        trackEvent(context, TRACK_FINISH_TUTORIAL, null);
    }

    public void trackCreateCharactor(Context context, String roleID, String areaID) {
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            trackEvent(context, TRACK_CHARACTOR_CREATED, map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackReachALevel(Context context, String roleID, String areaID, String level) {
        Log.d(TAG, "trackReachALevel: ");
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("level", level);
            trackEvent(context, TRACK_REACH_A_LEVEL, map);
        } catch (Exception e) {
            e.printStackTrace();
        }

        //tracking platform
        String levelTracking = null;
        try {
            if (GameConfigManager.getInstance() != null
                    && GameConfigManager.getInstance().getGameConfig() != null
                    && GameConfigManager.getInstance().getGameConfig().getLevel() != null)
                levelTracking = GameConfigManager.getInstance().getGameConfig().getLevel();
            Log.d(TAG, "trackLevelPlatform: " + levelTracking);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (levelTracking != null) {
            String[] arrLevel = levelTracking.split(",");
            for (String anLevel : arrLevel) {
                try {
                    if (!Preference.getBoolean(context, TRACK_LEVEL_PLATFORM + anLevel, false)
                            && Integer.parseInt(level) >= Integer.parseInt(anLevel)) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("LEVEL", anLevel + "");
                        trackEvent(context, TRACK_LEVEL_PLATFORM, map);
                        map.clear();
                        Preference.save(context, TRACK_LEVEL_PLATFORM + anLevel, true);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }


    }

    public String getAppsflyerDevkey() {
        return appsflyerDevkey;
    }

    public void setAppsflyerDevkey(String appsflyerDevkey) {
        this.appsflyerDevkey = appsflyerDevkey;
    }

    public String getGcmSenderId() {
        return gcmSenderId;
    }

    public void setGcmSenderId(String gcmSenderId) {
        this.gcmSenderId = gcmSenderId;
    }
}
