package com.mobgame.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;

public class Game {
	
	@SerializedName("app_gaid")
	private String googleAnalyticsId;
	
	@SerializedName("app_gaid_total")
	private String googleAnalyticsIdTotal;
	
	@SerializedName("app_gaid_local")
	private String googleAnalyticsIdLocal;
	
	@SerializedName("fb_appid")
	private String facebookId;
	
	@SerializedName("paypal")
	private PaypalConfig paypal;
	
	@SerializedName("google_iab")
	private GoogleIABConfig googleIAB;
	
	@SerializedName("appsflyer")
	private AppsFlyerConfig appsflyer;

	@SerializedName("adwords")
	private AdwordsConfig adwords;
	
	@SerializedName("ads")
	private AdsConfig adsConfig;
	
	@SerializedName("language_default")
	private String lang;

	@SerializedName("level")
	private String level;
	
	public static Game parse(String json) {
		Gson gson = new GsonBuilder().create();
		Game game = gson.fromJson(json.trim(), Game.class);
		return game;
	}

	/*public Game(String jsonString) {
		Gson gson = new GsonBuilder().create();
	    this = gson.fromJson(jsonString, Game.class);
		
		try {
			if (Utils.isJSONValid(jsonString)) {
				JSONObject obj = new JSONObject(jsonString);
				if (obj.has("app_gaid")) {
					googleAnalyticsId = obj.getString("app_gaid");
				}
				if (obj.has("fb_appid")) {
					facebookId = obj.getString("fb_appid");
				}
				if (obj.has("paypal")) {
					paypal = obj.getString("paypal");
				}
				if (obj.has("google_iab")) {
					googleIAB = obj.getString("google_iab");
				}
				if (obj.has("appsflyer")) {
					appsflyer = obj.getString("appsflyer");
				}
				if (obj.has("adwords")) {
					adwords = obj.getString("adwords");
				}
				if (obj.has("language_default")) {
					lang = obj.getString("language_default");
				}
//				SharedPreferenceUtils.saveStringValue(context, Constants.SHARED_PREF_GA_ID, app_gaid);
//				SharedPreferenceUtils.saveStringValue(context, Constants.SHARED_PREF_FB_ID, fb_appid);
//				SharedPreferenceUtils.saveStringValue(context, Constants.SHARED_PREF_PAYPAL_INFO, paypal);
//				SharedPreferenceUtils.saveStringValue(context, Constants.SHARED_PREF_IAB_INFO, google_iab);
//				SharedPreferenceUtils.saveStringValue(context, Constants.SHARED_PREF_AF_INFO, appsflyer);
//				SharedPreferenceUtils.saveStringValue(context, Constants.SHARED_PREF_ADWORDS_INFO, adwords);
			}
		} catch (JSONException e) {
			e.printStackTrace();
		}
	}*/

	public String getGoogleAnalyticsId() {
		return googleAnalyticsId;
	}

	public void setGoogleAnalyticsId(String googleAnalyticsId) {
		this.googleAnalyticsId = googleAnalyticsId;
	}

	public String getGoogleAnalyticsIdTotal() {
		return googleAnalyticsIdTotal;
	}

	public void setGoogleAnalyticsIdTotal(String googleAnalyticsIdTotal) {
		this.googleAnalyticsIdTotal = googleAnalyticsIdTotal;
	}

	public String getGoogleAnalyticsIdLocal() {
		return googleAnalyticsIdLocal;
	}

	public void setGoogleAnalyticsIdLocal(String googleAnalyticsIdLocal) {
		this.googleAnalyticsIdLocal = googleAnalyticsIdLocal;
	}

	public String getFacebookId() {
		return facebookId;
	}

	public void setFacebookId(String facebookId) {
		this.facebookId = facebookId;
	}

	public PaypalConfig getPaypal() {
		return paypal;
	}

	public void setPaypal(PaypalConfig paypal) {
		this.paypal = paypal;
	}

	public GoogleIABConfig getGoogleIAB() {
		return googleIAB;
	}

	public void setGoogleIAB(GoogleIABConfig googleIAB) {
		this.googleIAB = googleIAB;
	}

	public AppsFlyerConfig getAppsflyer() {
		return appsflyer;
	}

	public void setAppsflyer(AppsFlyerConfig appsflyer) {
		this.appsflyer = appsflyer;
	}

	public AdwordsConfig getAdwords() {
		return adwords;
	}

	public void setAdwords(AdwordsConfig adwords) {
		this.adwords = adwords;
	}

	public String getLang() {
		return lang;
	}

	public void setLang(String lang) {
		this.lang = lang;
	}
	
	public AdsConfig getAdsConfig() {
		return adsConfig;
	}

	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	public void setAdsConfig(AdsConfig adsApiKey) {
		this.adsConfig = adsApiKey;
	}

	public class GoogleIABConfig {
		
		@SerializedName("hashkey")
		private String hashkey;

		public String getHashkey() {
			return hashkey;
		}

		public void setHashkey(String hashkey) {
			this.hashkey = hashkey;
		}
		
	}
	
	public class AppsFlyerConfig {

		@SerializedName("appsflyer_dev_key")
		private String devKey;
		
		@SerializedName("is_use_http")
		private boolean isUseHttp;
		
		@SerializedName("currency")
		private String currency;

		public String getDevKey() {
			return devKey;
		}

		public void setDevKey(String devKey) {
			this.devKey = devKey;
		}

		public boolean isUseHttp() {
			return isUseHttp;
		}

		public void setUseHttp(boolean isUseHttp) {
			this.isUseHttp = isUseHttp;
		}

		public String getCurrency() {
			return currency;
		}

		public void setCurrency(String currency) {
			this.currency = currency;
		}

	}
	
	public class AdwordsConfig {
		
		@SerializedName("conversion_id")
		private String conversionId;

		public String getConversionId() {
			return conversionId;
		}

		public void setConversionId(String conversionId) {
			this.conversionId = conversionId;
		}
		
	}
	
	public class AdsConfig {
		
		@SerializedName("api_key")
		private String apiKey;

		public String getApiKey() {
			return apiKey;
		}

		public void setApiKey(String apiKey) {
			this.apiKey = apiKey;
		}
		
	}
	
	public class PaypalConfig {
		
		@SerializedName("client_id_production")
		private String clientId;

		@SerializedName("privacy_url")
		private String privacyUrl;
		
		@SerializedName("user_agreement_url")
		private String userAgreementUrl;
		
		@SerializedName("accept_credit_cards")
		private boolean acceptCreditCard;
		
		@SerializedName("client_id_sandbox")
		private String clientIdSnadbox;
		
		@SerializedName("merchant_name")
		private String merchantName;

		public String getClientId() {
			return clientId;
		}

		public void setClientId(String clientId) {
			this.clientId = clientId;
		}

		public String getPrivacyUrl() {
			return privacyUrl;
		}

		public void setPrivacyUrl(String privacyUrl) {
			this.privacyUrl = privacyUrl;
		}

		public String getUserAgreementUrl() {
			return userAgreementUrl;
		}

		public void setUserAgreementUrl(String userAgreementUrl) {
			this.userAgreementUrl = userAgreementUrl;
		}

		public boolean isAcceptCreditCard() {
			return acceptCreditCard;
		}

		public void setAcceptCreditCard(boolean acceptCreditCard) {
			this.acceptCreditCard = acceptCreditCard;
		}

		public String getClientIdSnadbox() {
			return clientIdSnadbox;
		}

		public void setClientIdSnadbox(String clientIdSnadbox) {
			this.clientIdSnadbox = clientIdSnadbox;
		}

		public String getMerchantName() {
			return merchantName;
		}

		public void setMerchantName(String merchantName) {
			this.merchantName = merchantName;
		}
		
	}
	
}
