package com.mobgame.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class UserInfo {
	
	@SerializedName("user")
	private User user;
	
	@SerializedName("userDaily")
	private UserDaily userDaily;

	private boolean enableTimer;

	private TimerData timerData;
	
	public UserInfo() {}
	
	public static UserInfo parse(String json) {
		Gson gson = new GsonBuilder().create();
		UserInfo game = gson.fromJson(json.trim(), UserInfo.class);
		return game;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public UserDaily getUserDaily() {
		return userDaily;
	}

	public void setUserDaily(UserDaily userDaily) {
		this.userDaily = userDaily;
	}

	public class UserDaily {
		
		@SerializedName("title")
		private String title;
		
		@SerializedName("bonus_info")
		private int bonusInfo;
		
		@SerializedName("bonus_facebook")
		private int bonusFacebook;
		
		@SerializedName("bonus_email")
		private int bonusEmail;
		
		@SerializedName("coin")
		private int coin;
		
		@SerializedName("type_user")
		private String typeUser;
		
		@SerializedName("type_hello")
		private int typeHello;
		
		@SerializedName("title_notice")
		private String tooltip;
		
		@SerializedName("update_info")
		private Details updateInfoDetails;
		
		@SerializedName("upgrade_email")
		private Details upgradeEmailDetails;

		public String getTitle() {
			return title;
		}

		public void setTitle(String title) {
			this.title = title;
		}

		public int getBonusInfo() {
			return bonusInfo;
		}

		public void setBonusInfo(int bonusInfo) {
			this.bonusInfo = bonusInfo;
		}

		public int getBonusFacebook() {
			return bonusFacebook;
		}

		public void setBonusFacebook(int bonusFacebook) {
			this.bonusFacebook = bonusFacebook;
		}

		public int getBonusEmail() {
			return bonusEmail;
		}

		public void setBonusEmail(int bonusEmail) {
			this.bonusEmail = bonusEmail;
		}

		public int getCoin() {
			return coin;
		}

		public void setCoin(int coin) {
			this.coin = coin;
		}

		public String getTypeUser() {
			return typeUser;
		}

		public void setTypeUser(String typeUser) {
			this.typeUser = typeUser;
		}

		public int getTypeHello() {
			return typeHello;
		}

		public void setTypeHello(int typeHello) {
			this.typeHello = typeHello;
		}

		public String getTooltip() {
			return tooltip;
		}

		public void setTooltip(String tooltip) {
			this.tooltip = tooltip;
		}

		public Details getUpdateInfoDetails() {
			return updateInfoDetails;
		}

		public void setUpdateInfoDetails(Details updateInfoDetails) {
			this.updateInfoDetails = updateInfoDetails;
		}

		public Details getUpgradeEmailDetails() {
			return upgradeEmailDetails;
		}

		public void setUpgradeEmailDetails(Details upgradeEmailDetails) {
			this.upgradeEmailDetails = upgradeEmailDetails;
		}

		public class Details {

			@SerializedName("url")
			private String url;

			@SerializedName("type_open")
			private int type;

			public String getUrl() {
				return url;
			}

			public void setUrl(String url) {
				this.url = url;
			}

			public int getType() {
				return type;
			}

			public void setType(int type) {
				this.type = type;
			}

		}

	}

	public class User {

		@SerializedName("avatar_url")
		private String avatarUrl;

		@SerializedName("user_id")
		private String userId;

		@SerializedName("account_id")
		private String accountId;

		@SerializedName("user_name")
		private String userName;

		@SerializedName("role")
		private String role;
		
		@SerializedName("email")
		private String email;
		
		@SerializedName("full_name")
		private String fullName;
		@SerializedName("vip")
		private String vip;

		@SerializedName("vip_image")
		private String vipImage;

		public String getVip() {
			return vip;
		}

		public void setVip(String vip) {
			this.vip = vip;
		}

		public String getVipImage() {
			return vipImage;
		}

		public void setVipImage(String vipImage) {
			this.vipImage = vipImage;
		}

		public String getAvatarUrl() {
			return avatarUrl;
		}

		public void setAvatarUrl(String avatarUrl) {
			this.avatarUrl = avatarUrl;
		}

		public String getUserId() {
			return userId;
		}

		public void setUserId(String userId) {
			this.userId = userId;
		}

		public String getAccountId() {
			return accountId;
		}

		public void setAccountId(String accountId) {
			this.accountId = accountId;
		}

		public String getUserName() {
			return userName;
		}

		public void setUserName(String userName) {
			this.userName = userName;
		}

		public String getRole() {
			return role;
		}

		public void setRole(String role) {
			this.role = role;
		}

		public String getEmail() {
			return email;
		}

		public void setEmail(String email) {
			this.email = email;
		}

		public String getFullName() {
			return fullName;
		}

		public void setFullName(String fullName) {
			this.fullName = fullName;
		}
		
	}

	public void setEnableTimer(boolean enableTimer) {
		this.enableTimer = enableTimer;
	}

	public boolean isEnableTimer(){
		return this.enableTimer;
	}

	public void setTimerData(TimerData timerData) {
		if(timerData != null){
			ArrayList<TimerObject> listTimer = new ArrayList<>();
			listTimer = timerData.getListTimerObject();
			Comparator<TimerObject> cmp = new Comparator<TimerObject>() {

				@Override
				public int compare(TimerObject a, TimerObject b) {
					// TODO Auto-generated method stub
					if(a.getEndTime() != b.getEndTime()){
						return (int)(a.getEndTime() - b.getEndTime());
					}
					return a.getEndTime().compareTo(b.getEndTime());
				}
			};
			Collections.sort(listTimer , cmp);
			timerData.setListTimerObject(listTimer);
		}
		this.timerData = timerData;
	}

	public TimerData getTimerData(){
		return this.timerData;
	}

}
