package com.mobgame;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.content.res.Configuration;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import android.view.OrientationEventListener;

import com.mobgame.gui.float18button.NotiOverlayView;
import com.mobgame.gui.floatbutton.MobGameOverlayView;
import com.mobgame.utils.Constants;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;

class MobGameHelper {

	private static Activity activity = MobGameSDK.activity;
	private static NotiOverlayView notiFloatButton;
	private static MobGameOverlayView floatButton;
	private static boolean didShowPermissionDialog = false;
	
	static void initFloatButton() {
		if (checkDrawOverApps()) {
			try {
				if (floatButton != null) {
					floatButton.dismiss();
				}
			}catch (Exception e){
				e.printStackTrace();
			}
			floatButton = new MobGameOverlayView(activity);
		}
	}
	
	static void initFloatButtonIfNeeded() {
		Log.e("TAG" , "Vao Day -1 : " + MobGameSDK.getInstance().isGrantedPermission(activity));
//		if (checkDrawOverApps()) {
		if (MobGameSDK.getInstance().isGrantedPermission(activity)) {
			if (floatButton == null) {
				Log.e("TAG" , "Vao Day 3");
				floatButton = new MobGameOverlayView(activity);
			}
		}
	}

	static void showNotiFloatButton() {
		if (notiFloatButton == null)
			notiFloatButton = new NotiOverlayView(activity);
		notiFloatButton.show();
		Log.e("NotiButton","Showing");
	}

	static void hideNotiFloatButton() {
		if (notiFloatButton != null && activity!=null && notiFloatButton.isShowing()) {
			activity.runOnUiThread(new Runnable() {

				@Override
				public void run() {
					if (notiFloatButton != null) {
						notiFloatButton.hide();
//						Preference.save(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true);
					}
				}
			});
		}
		Log.e("NotiButton","Hiding");
	}

	static boolean isShowingNotiFloatButton() {
		if (notiFloatButton != null) return notiFloatButton.isShowing();
		return false;
	}

	static void showFloatButton(boolean isMoveToCenterVertical, boolean isShowingHello) {
        final boolean finalIsMoveToCenterVertical = isMoveToCenterVertical;
        final boolean finalIsShowingHello = isShowingHello;
		try{
//			if (checkDrawOverApps()) {
			Log.e("TAG" , "Vao Day 0 : " + MobGameSDK.getInstance().isGrantedPermission(activity));
			if (MobGameSDK.getInstance().isGrantedPermission(activity) && MobGameSDK.isShowNotiMode) {
				activity.runOnUiThread(new Runnable() {

					@Override
					public void run() {
						if(finalIsShowingHello){
                            new Handler().postDelayed(new Runnable() {
                                @Override
                                public void run() {

                                    showFloatButton(finalIsMoveToCenterVertical,false);
									Log.e("TAG" , "Vao Day 1");
                                }
                            }, 500);
                        }else{
//							Log.e("TAG" , "Vao Day 2 : " + !floatButton.isShowing()
//									+ " , " + 	!floatButton.isShowingConfirmDialog());
                            initFloatButtonIfNeeded();
                            if (!floatButton.isShowing()
                                    &&	!floatButton.isShowingConfirmDialog()) {
                                if(FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
                                    startFloatButtonTimer();
                                }
                                floatButton.show(FloatButtonTimerHelper.isRuningTimer(),finalIsMoveToCenterVertical);
                            }
                            if(floatButton.isShowing()
                                    && !floatButton.isShowingConfirmDialog()){
                                if(FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
                                    startFloatButtonTimer();
                                    floatButton.show(FloatButtonTimerHelper.isRuningTimer(),finalIsMoveToCenterVertical);
									Log.e("show Floatbutton","2");
                                }
                            }
                        }
					}
				});
			} else if (!MobGameSDK.isShowNotiMode) {
				if (checkDrawOverApps()) {
					activity.runOnUiThread(new Runnable() {

						@Override
						public void run() {
							if(finalIsShowingHello){
								new Handler().postDelayed(new Runnable() {
									@Override
									public void run() {

										showFloatButton(finalIsMoveToCenterVertical,false);
										Log.e("TAG" , "Vao Day 1");
									}
								}, 500);
							}else{
//							Log.e("TAG" , "Vao Day 2 : " + !floatButton.isShowing()
//									+ " , " + 	!floatButton.isShowingConfirmDialog());
								initFloatButtonIfNeeded();
								if (!floatButton.isShowing()
										&&	!floatButton.isShowingConfirmDialog()) {
									if(FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
										startFloatButtonTimer();
									}
									floatButton.show(FloatButtonTimerHelper.isRuningTimer(),finalIsMoveToCenterVertical);
								}
								if(floatButton.isShowing()
										&& !floatButton.isShowingConfirmDialog()){
									if(FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
										startFloatButtonTimer();
										floatButton.show(FloatButtonTimerHelper.isRuningTimer(),finalIsMoveToCenterVertical);
										Log.e("show Floatbutton","2");
									}
								}
							}
						}
					});
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	static void hideFloatButton() {
		if (floatButton != null && activity!=null) {
			activity.runOnUiThread(new Runnable() {
				
				@Override
				public void run() {
					if (floatButton != null) {
						floatButton.hide();
//						Preference.save(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true);
					}
				}
			});
		}
	}
	
	static void notifyFloatButton() {
		
		if (floatButton != null) {
			floatButton.viberate();
		}
	}

	static void showTimer(){
		if(floatButton == null){
			return;
		}
		if(FloatButtonTimerHelper.canRunTimer()){
			floatButton.startTimer();
		}
	}

	static void updateFloatButtonMenu() {
		if (floatButton != null) {
			floatButton.updateMenu();
		}
	}

	static void dismissFloatButton() {
		activity.runOnUiThread(new Runnable() {
			
			@Override
			public void run() {
				if (floatButton != null) {
					floatButton.dismiss();
					floatButton = null;
				}
			}
		});
	}

	private static boolean checkDrawOverApps() {
		try {
			Log.e("TAG" , "canDrawOverApp : " + Utils.canDrawOverApp(activity));
				if (!Utils.canDrawOverApp(activity)) {
					if (!didShowPermissionDialog) {
						new AlertDialog.Builder(Utils.getContextThemeWrapper(activity))
								.setTitle("Warning")
								.setCancelable(false)
								.setMessage("We need permission to bring you our best features")
								.setPositiveButton(android.R.string.ok, new OnClickListener() {
									public void onClick(DialogInterface dialog, int which) {
										Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse("package:"
												+ activity.getPackageName()));
										activity.startActivityForResult(intent, 1234);
										dialog.dismiss();
									}
								})
								.show();
						didShowPermissionDialog = true;
					}
					return false;
				}
		}catch (Exception e){
			e.printStackTrace();
		}
		return true;
	}
	static void startFloatButtonTimer(){
		if(floatButton == null){
			return;
		}
		Log.d("TAG", "fuck");
		floatButton.startTimer();
	}

	static boolean isShowingFloatButton(){
		try {
			if(floatButton!=null){
				return floatButton.isShowing();
			}else{
				return false;
			}
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

	static boolean isStartShowMiniMenu(){
		try{
			Log.d("MobGameHelper", "isStartShowMiniMenu: "+MobGameOverlayView.isStartShowMenu());
			return MobGameOverlayView.isStartShowMenu();
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

}
