/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.ViewPager;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.AppCompatActivity;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.appsflyer.AppsFlyerLib;
import com.bumptech.glide.Glide;
import com.facebook.FacebookSdk;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.ads.OfferWallFragment;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAnalyticsManager;
import com.mobgame.gui.MobGamePagerFragment;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.MobGameWebView;
import com.mobgame.js.JsHandler;
import com.mobgame.model.MobMenu;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobGameActivity
extends AppCompatActivity {
    private static String TAG = MobGameActivity.class.getSimpleName();
    public static String KEY_DATA = "data";
    public static String KEY_ENABLE_AUTOHIDE_HEADER_BAR = "autohide_header_bar";
    public static String KEY_ENABLE_SIDE_MENU = "enable_side_menu";
    public static String KEY_ENABLE_TITLE = "enable_title";
    public static String KEY_IS_PAYMENT_FORM = "is_payment_form";
    public static String KEY_IS_LOGIN_FORM = "is_login_form";
    public static String KEY_IS_DASHBOARD_FORM = "is_dashboard_form";
    public static boolean shouldReload = false;
    private DrawerLayout layoutRoot;
    private View layoutMain;
    private View layoutHeader;
    private View layoutContent;
    private View layoutDrawer;
    private TextView txtTitle;
    private TextView txtVersion;
    private ImageButton btnMenu;
    private ImageButton btnBack;
    private ImageButton btnShare;
    private ImageButton btnClose;
    private ProgressBar prgBar;
    private ListView lvDrawer;
    private SideMenuAdapter lvAdapter;
    private MobGamePagerFragment fragContent;
    private MobPagerAdapter adapter;
    private float density;
    private int currentPage;
    private boolean isEnableAutohideHeaderBar = false;
    private boolean isEnableSideMenu = true;
    private boolean isEnableTitle = true;
    private boolean isScrollAnimating;
    private boolean isLockingHeaderBar;
    private boolean isLoginForm = false;
    private boolean isDashboardForm = false;
    private boolean isPaymentForm = false;
    OfferWallFragment offerWallFragment;
    private String TAG_FRAGMENT = "fragment_web";
    private AdapterView.OnItemClickListener mOnMenuItemSelectedListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            try {
                SideMenuModel menuItem = MobGameActivity.this.lvAdapter.getItem(position);
                GoogleAnalyticsManager.getInstance().trackEvent("Left menu", "button_press", menuItem.getLabel(), 1L);
                Log.d((String)TAG, (String)("menuItem label:" + menuItem.getLabel()));
                MobGameActivity.this.performOnItemClick(position);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private ViewPager.SimpleOnPageChangeListener mOnPageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

        public void onPageSelected(int position) {
            try {
                int itemId;
                if (position != MobGameActivity.this.currentPage) {
                    MobGameActivity.this.currentPage = position;
                    MobGameActivity.this.prgBar.setVisibility(8);
                    MobGameActivity.this.updateHeaderBar(position);
                    MobGameWebFragment fragWeb = MobGameActivity.this.adapter.getItem(MobGameActivity.this.currentPage);
                    MobGameActivity.this.mWebEventListener.onScrollChanged(fragWeb.getWebView(), fragWeb.getScrollX(), fragWeb.getScrollY(), fragWeb.getScrollX(), fragWeb.getScrollY());
                }
                if (NotificationUtils.hasNtf((Context)MobGameActivity.this, itemId = (int)MobGameActivity.this.adapter.getItemId(position))) {
                    NotificationUtils.removeNtf((Context)MobGameActivity.this, itemId);
                    MobGameActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MobGameActivity.this.fragContent.notifyTabsChanged();
                            MobGameActivity.this.lvAdapter.notifyDataSetChanged();
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private MobGameWebFragment.EventListener mWebEventListener = new MobGameWebFragment.EventListener(){

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            try {
                MobGameActivity.this.lockHeader();
                MobGameActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGameWebFragment fragWeb = MobGameActivity.this.adapter.getItem(MobGameActivity.this.currentPage);
                        if (MobGameActivity.this.fragContent.countTabs() > 1 && !fragWeb.canGoBack()) {
                            MobGameActivity.this.fragContent.showTabs(true);
                            MobGameActivity.this.isEnableAutohideHeaderBar = true;
                            new Handler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    MobGameActivity.this.unlockHeader();
                                }
                            }, 1000L);
                        } else {
                            MobGameActivity.this.fragContent.hideTabs(true);
                            MobGameActivity.this.isEnableAutohideHeaderBar = false;
                        }
                        MobGameActivity.this.btnShare.setVisibility(8);
                    }
                });
                view.addJavascriptInterface((Object)MobGameActivity.this, "android");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onProgressChanged(WebView view, int progress) {
            try {
                int pos = Integer.parseInt((String)view.getTag());
                if (pos == MobGameActivity.this.currentPage) {
                    MobGameActivity.this.updateHeaderBar(pos);
                    progress = Math.max(1, progress);
                    MobGameActivity.this.prgBar.setProgress(progress);
                    if (progress == 100) {
                        MobGameActivity.this.hideProgressBar();
                    } else {
                        MobGameActivity.this.showProgressBar();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            try {
                int pos = Integer.parseInt((String)view.getTag());
                if (pos == MobGameActivity.this.currentPage) {
                    MobGameActivity.this.updateHeaderBar(pos);
                    MobGameActivity.this.hideProgressBar();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onScrollChanged(WebView view, int l, int t, int oldl, int oldt) {
            try {
                if (!MobGameActivity.this.isEnableAutohideHeaderBar) {
                    return;
                }
                if (MobGameActivity.this.isLockingHeaderBar) {
                    return;
                }
                MobGameWebView webView = (MobGameWebView)view;
                int maxt = webView.computeVerticalScrollRange();
                if (t == 0) {
                    MobGameActivity.this.cancelAnimationHeader();
                    MobGameActivity.this.showHeader();
                    return;
                }
                if (t == maxt) {
                    MobGameActivity.this.cancelAnimationHeader();
                    MobGameActivity.this.hideHeader();
                    return;
                }
                if (MobGameActivity.this.isScrollAnimating) {
                    return;
                }
                if ((float)(oldt - t) > 5.0f * MobGameActivity.this.density) {
                    MobGameActivity.this.cancelAnimationHeader();
                    MobGameActivity.this.showHeader();
                } else if ((float)(t - oldt) > 5.0f * MobGameActivity.this.density) {
                    MobGameActivity.this.cancelAnimationHeader();
                    MobGameActivity.this.hideHeader();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
        }
    };
    private Animator.AnimatorListener mHeaderAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animator) {
            try {
                MobGameActivity.this.isScrollAnimating = true;
                MobGameActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((ViewGroup)MobGameActivity.this.layoutMain).updateViewLayout(MobGameActivity.this.layoutContent, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, MobGameActivity.this.layoutMain.getHeight()));
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onAnimationRepeat(Animator animator) {
        }

        public void onAnimationEnd(Animator animator) {
            try {
                MobGameActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((ViewGroup)MobGameActivity.this.layoutMain).updateViewLayout(MobGameActivity.this.layoutContent, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, MobGameActivity.this.layoutMain.getHeight() - MobGameActivity.this.layoutHeader.getHeight() - (int)MobGameActivity.this.layoutHeader.getY()));
                        MobGameActivity.this.fragContent.updateTabs();
                        MobGameActivity.this.isScrollAnimating = false;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onAnimationCancel(Animator animator) {
        }
    };
    private boolean isShowingOfferWall;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            block21: {
                try {
                    String category = intent.getStringExtra("category");
                    Log.d((String)TAG, (String)("mBroadcastReceiver category: " + category));
                    if ("mobOpenOfferWall".equalsIgnoreCase(category)) {
                        MobGameActivity.this.isShowingOfferWall = true;
                    } else if (!"float_button".equalsIgnoreCase(category)) {
                        MobGameActivity.this.isShowingOfferWall = false;
                    }
                    if ("gcm".equalsIgnoreCase(category)) {
                        String strId = intent.getStringExtra("id");
                        if (strId != null) {
                            MobGameActivity.this.lvAdapter.notifyDataSetChanged();
                            MobGameActivity.this.fragContent.notifyTabsChanged();
                        }
                        break block21;
                    }
                    if ("dashboard".equalsIgnoreCase(category)) {
                        try {
                            MobGameActivity.this.fragContent.hideTabs(false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            String strUrls = intent.getStringExtra("urls");
                            JSONArray urls = new JSONArray(strUrls);
                            MobGameActivity.this.loadUrls(urls);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block21;
                    }
                    if ("finish_facebook_upgrade".equalsIgnoreCase(category)) {
                        MobGameActivity.this.performOnItemClick(0);
                    } else if ("dashboard_close".equalsIgnoreCase(category)) {
                        MobGameActivity.this.finish();
                    } else if ("mobOpenOfferWall".equalsIgnoreCase(category)) {
                        if (!Utils.isOnline(MobGameActivity.this.getApplicationContext())) {
                            Toast.makeText((Context)MobGameActivity.this.getApplicationContext(), (CharSequence)MobGameActivity.this.getResources().getString(R.string.error_network), (int)1).show();
                        } else {
                            MobGameActivity.this.showOfferWall();
                        }
                    } else if ("reload".equalsIgnoreCase(category)) {
                        MobGameActivity.this.reload();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };
    private boolean isOfferWallOpened = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_mob);
        FacebookSdk.sdkInitialize((Context)this.getApplicationContext());
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            this.isEnableAutohideHeaderBar = bundle.getBoolean(KEY_ENABLE_AUTOHIDE_HEADER_BAR, true);
            this.isEnableSideMenu = bundle.getBoolean(KEY_ENABLE_SIDE_MENU, true);
            this.isEnableTitle = bundle.getBoolean(KEY_ENABLE_SIDE_MENU, true);
            this.isLoginForm = bundle.getBoolean(KEY_IS_LOGIN_FORM);
            this.isDashboardForm = bundle.getBoolean(KEY_IS_DASHBOARD_FORM);
            this.isPaymentForm = bundle.getBoolean(KEY_IS_PAYMENT_FORM);
        }
        this.layoutRoot = (DrawerLayout)this.findViewById(R.id.layout_root);
        this.layoutDrawer = this.findViewById(R.id.left_drawer);
        this.layoutMain = this.findViewById(R.id.layout_main);
        this.layoutHeader = this.findViewById(R.id.layout_header);
        this.layoutContent = this.findViewById(R.id.layout_content);
        this.lvDrawer = (ListView)this.findViewById(R.id.left_drawer_lv);
        this.prgBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.txtTitle = (TextView)this.findViewById(R.id.txt_title);
        this.txtVersion = (TextView)this.findViewById(R.id.txt_version);
        this.btnMenu = (ImageButton)this.findViewById(R.id.btn_menu);
        this.btnBack = (ImageButton)this.findViewById(R.id.btn_back);
        this.btnShare = (ImageButton)this.findViewById(R.id.btn_share);
        this.btnClose = (ImageButton)this.findViewById(R.id.btn_close);
        try {
            this.density = DeviceUtils.getDensity((Context)this);
            this.txtVersion.setText((CharSequence)("Game version: " + Utils.getGameVersion((Context)this) + "\nSDK version: " + Utils.getSDKVersion((Context)this)));
            this.initHeaderBar();
            this.initSideMenu();
            Intent intentDeepLink = this.getIntent();
            MobGameSDK.getInstance().onHandleIntent(intentDeepLink);
            this.fragContent = new MobGamePagerFragment((Activity)this);
            this.fragContent.addOnPageChangeListener(this.mOnPageChangeListener);
            this.fragContent.setWebEventListener(this.mWebEventListener);
            FragmentManager fm = this.getSupportFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.add(this.layoutContent.getId(), (Fragment)this.fragContent, this.TAG_FRAGMENT);
            ft.commit();
            String data = "";
            try {
                data = this.getIntent().getExtras().getString(KEY_DATA);
                JSONArray items = new JSONArray(data);
                this.loadUrls(items);
            }
            catch (Exception e) {
                try {
                    if (data.equals("offerwall")) {
                        this.performOnItemClick(this.getOfferWallPostion());
                    } else {
                        this.performOnItemClick(0);
                    }
                }
                catch (IndexOutOfBoundsException | NullPointerException e2) {
                    this.performOnItemClick(0);
                    e.printStackTrace();
                }
            }
            this.offerWallFragment = new OfferWallFragment((Activity)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getOfferWallPostion() {
        try {
            MobMenu mobMenu = GameConfigManager.getInstance().getMobMenu();
            if (mobMenu == null) {
                return -1;
            }
            ArrayList<MobMenuItem> menuItems = mobMenu.getMenuItems();
            for (int i = 0; i < menuItems.size(); ++i) {
                if (!menuItems.get(i).getCommand().equals("mobOpenOfferWall")) continue;
                Log.d((String)TAG, (String)("mobOpenOfferWall position is: " + i));
                return i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    protected void onResume() {
        super.onResume();
        try {
            LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mBroadcastReceiver, new IntentFilter("com.mobgame.broadcast"));
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "float_button");
            intent.putExtra("message", "hide");
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
            if (shouldReload) {
                this.reload();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onPause() {
        try {
            LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mBroadcastReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onPause();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            MobGameSDK.getInstance().onActivityResult(requestCode, resultCode, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @TargetApi(value=19)
    public void onWindowFocusChanged(boolean hasFocus) {
        try {
            if (Build.VERSION.SDK_INT >= 19 && hasFocus) {
                this.getWindow().getDecorView().setSystemUiVisibility(5126);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
        try {
            Log.i((String)TAG, (String)("onBackPressed:" + this.currentPage));
            MobGameWebFragment fragWeb = this.adapter.getItem(this.currentPage);
            if (fragWeb.canGoBack()) {
                fragWeb.goBack();
            } else {
                MobGameSDK.getInstance().close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showOfferWall() {
        try {
            this.isOfferWallOpened = true;
            this.isShowingOfferWall = true;
            if (this.offerWallFragment == null) {
                this.offerWallFragment = new OfferWallFragment((Activity)this);
            }
            FragmentManager fm = this.getSupportFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.replace(this.layoutContent.getId(), (Fragment)this.offerWallFragment, this.TAG_FRAGMENT);
            ft.addToBackStack(null);
            this.txtTitle.setText(R.string.title_games);
            ft.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeOfferWall() {
        try {
            this.isOfferWallOpened = false;
            if (this.offerWallFragment != null) {
                this.getSupportFragmentManager().beginTransaction().remove((Fragment)this.offerWallFragment).commit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadUrls(JSONArray items) {
        try {
            JSONObject item;
            int i;
            if (this.adapter == null) {
                this.adapter = new MobPagerAdapter(this.getSupportFragmentManager());
            }
            this.currentPage = 0;
            JSONArray revItems = new JSONArray();
            for (i = items.length() - 1; i >= 0; --i) {
                try {
                    item = items.getJSONObject(i);
                    revItems.put((Object)item);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (i = revItems.length() - 1; i >= 0; --i) {
                try {
                    item = revItems.getJSONObject(i);
                    if (!NotificationUtils.hasNtf((Context)this, item.getInt("id"))) continue;
                    this.currentPage = i;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.adapter.setItems(revItems);
                this.fragContent.setAdapter(this.adapter, this.currentPage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reload() {
        try {
            shouldReload = false;
            for (int i = 0; i < this.adapter.getCount(); ++i) {
                MobGameWebFragment frag = this.adapter.getItem(i);
                frag.reload();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initHeaderBar() {
        try {
            int imgRes = Res.drawableResource((Context)this, R.drawable.bar_header);
            this.layoutHeader.setBackgroundResource(imgRes);
            if (this.isEnableSideMenu) {
                this.txtTitle.setGravity(19);
                this.btnMenu.setVisibility(0);
                this.btnMenu.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        MobGameActivity.this.layoutRoot.openDrawer(MobGameActivity.this.layoutDrawer);
                    }
                });
            } else {
                this.txtTitle.setGravity(17);
                this.btnMenu.setVisibility(8);
            }
            if (this.isEnableTitle) {
                this.txtTitle.setVisibility(0);
            } else {
                this.txtTitle.setVisibility(4);
            }
            this.btnBack.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MobGameActivity.this.onBackPressed();
                }
            });
            this.btnClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        if (MobGameActivity.this.isLoginForm) {
                            AppsFlyerLib.getInstance().trackEvent(MobGameActivity.this.getApplicationContext(), "close_login", null);
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    EventClientManager.getInstance((Context)MobGameActivity.this).saveEventClient("normal", "close_login", null);
                                }
                            }).start();
                            MobGameActivity.this.isLoginForm = false;
                        } else if (MobGameActivity.this.isDashboardForm) {
                            AppsFlyerLib.getInstance().trackEvent(MobGameActivity.this.getApplicationContext(), "close_dashboard", null);
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    EventClientManager.getInstance((Context)MobGameActivity.this).saveEventClient("normal", "close_dashboard", null);
                                }
                            }).start();
                            MobGameActivity.this.isDashboardForm = false;
                        } else if (MobGameActivity.this.isPaymentForm) {
                            AppsFlyerLib.getInstance().trackEvent(MobGameActivity.this.getApplicationContext(), "close_form_payment", null);
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    EventClientManager.getInstance((Context)MobGameActivity.this).saveEventClient("normal", "close_form_payment", null);
                                }
                            }).start();
                            MobGameActivity.this.isPaymentForm = false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MobGameActivity.this.isDashboardForm = false;
                        MobGameActivity.this.isLoginForm = false;
                        MobGameActivity.this.isPaymentForm = false;
                    }
                    MobGameSDK.getInstance().close();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initSideMenu() {
        try {
            MobMenu mobMenu;
            if (!this.isEnableSideMenu) {
                this.layoutRoot.setDrawerLockMode(1);
            }
            if ((mobMenu = GameConfigManager.getInstance().getMobMenu()) == null) {
                return;
            }
            ArrayList<MobMenuItem> menuItems = mobMenu.getMenuItems();
            ArrayList<SideMenuModel> models = new ArrayList<SideMenuModel>(menuItems.size());
            for (MobMenuItem menuItem : menuItems) {
                if (!menuItem.shouldShow()) continue;
                SideMenuModel menuItemModel = new SideMenuModel(menuItem.getId(), menuItem.getIconUrl(), menuItem.getLabel());
                if (menuItem.isExternal()) {
                    menuItemModel.setType(1);
                }
                if (menuItem.getSubMenuIds() != null) {
                    menuItemModel.setIds(menuItem.getSubMenuIds());
                }
                Log.d((String)TAG, (String)("item command :" + menuItem.getCommand() + " , params: " + menuItem.getParams()));
                menuItemModel.setAction(menuItem.getCommand(), menuItem.getParams());
                models.add(menuItemModel);
            }
            this.lvAdapter = new SideMenuAdapter((Activity)this, models);
            this.lvDrawer.setAdapter((ListAdapter)this.lvAdapter);
            this.lvDrawer.setOnItemClickListener(this.mOnMenuItemSelectedListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateHeaderBar(int pos) {
        try {
            final MobGameWebFragment fragWeb = this.adapter.getItem(pos);
            if (fragWeb != null && fragWeb.isAdded()) {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        String title = fragWeb.getTitle();
                        if (title.contains(Constants.DOMAIN_NAME) || title.equalsIgnoreCase("about:blank") || title.equalsIgnoreCase("website not available") || title.contains("data:text/html") || title.startsWith("http://") || title.startsWith("https://")) {
                            title = "";
                        }
                        if (!Utils.isOnline(MobGameActivity.this.getApplicationContext())) {
                            title = "Website not available";
                        }
                        MobGameActivity.this.txtTitle.setText((CharSequence)title);
                        if (fragWeb.canGoBack()) {
                            MobGameActivity.this.btnBack.setVisibility(0);
                            MobGameActivity.this.btnMenu.setVisibility(8);
                        } else {
                            MobGameActivity.this.btnBack.setVisibility(8);
                            if (MobGameActivity.this.isEnableSideMenu) {
                                MobGameActivity.this.btnMenu.setVisibility(0);
                            }
                        }
                    }
                });
                String inject = "if (typeof getShareUrl === 'function') {\t\t\t\t\t\t\t\ttry {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twindow.android.onGetShareUrl(getShareUrl());\t\t\t\t\t} catch (err) {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twindow.android.onGetShareUrl('');\t\t\t\t\t\t\t\t\tconsole.log(err);\t\t\t\t\t\t\t\t\t\t\t\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t} else {\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twindow.android.onGetShareUrl('');\t\t\t\t\t\t\t\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
                fragWeb.invokeJavascript(inject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showProgressBar() {
        try {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        MobGameActivity.this.prgBar.setVisibility(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideProgressBar() {
        try {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    MobGameActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MobGameActivity.this.prgBar.setVisibility(8);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }, 500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showHeader() {
        try {
            if (this.isLockingHeaderBar) {
                return;
            }
            this.layoutHeader.animate().setDuration(100L).y(0.0f);
            this.layoutContent.animate().y((float)this.layoutHeader.getHeight()).setDuration(100L).setListener(this.mHeaderAnimatorListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideHeader() {
        try {
            if (this.isLockingHeaderBar) {
                return;
            }
            this.layoutHeader.animate().setDuration(100L).y((float)(-this.layoutHeader.getHeight()));
            this.layoutContent.animate().setDuration(100L).y(0.0f).setListener(this.mHeaderAnimatorListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lockHeader() {
        this.showHeader();
        this.isLockingHeaderBar = true;
    }

    private void unlockHeader() {
        this.isLockingHeaderBar = false;
    }

    private void cancelAnimationHeader() {
        try {
            this.layoutHeader.animate().cancel();
            this.layoutContent.animate().cancel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void performOnItemClick(int position) {
        try {
            block15: {
                if (this.lvAdapter == null) {
                    return;
                }
                if (position == -1) {
                    return;
                }
                SideMenuModel menuItem = this.lvAdapter.getItem(position);
                Log.d((String)TAG, (String)("performOnItemClick: " + position));
                NotificationUtils.removeNtf((Context)this, menuItem.getId());
                if ("mobOpenOfferWall".equals(menuItem.getCommand())) {
                    this.showOfferWall();
                } else if ("dashboard".equalsIgnoreCase(menuItem.getCommand())) {
                    if (this.offerWallFragment != null) {
                        FragmentManager fm = this.getSupportFragmentManager();
                        FragmentTransaction ft = fm.beginTransaction();
                        ft.replace(this.layoutContent.getId(), (Fragment)this.fragContent, this.TAG_FRAGMENT);
                        ft.commit();
                    }
                    try {
                        this.loadUrls(new JSONArray(menuItem.getParams()));
                        if (menuItem.isTabbed()) {
                            this.fragContent.showTabs(false);
                            break block15;
                        }
                        this.fragContent.hideTabs(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (menuItem.getCommand() != null) {
                    Log.d((String)TAG, (String)("isOfferWallOpened : " + this.isOfferWallOpened));
                    if (this.isOfferWallOpened) {
                        JsHandler jsHandler = new JsHandler((Activity)this, new MobGameWebFragment());
                        jsHandler.mobAppSDKexecute(menuItem.getCommand(), menuItem.getParams());
                    } else {
                        Log.e((String)TAG, (String)"GOOO HERE");
                        MobGameWebFragment fragWeb = this.adapter.getItem(this.currentPage);
                        fragWeb.handleCommand(menuItem.getCommand(), menuItem.getParams());
                        JsHandler jsHandler = new JsHandler((Activity)this);
                        jsHandler.mobAppSDKexecute(menuItem.getCommand(), menuItem.getParams());
                    }
                }
            }
            this.lvAdapter.notifyDataSetChanged();
            this.layoutRoot.closeDrawers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JavascriptInterface
    public void onGetShareUrl(String value) {
        try {
            JSONObject obj = new JSONObject(value);
            final String shareUrl = obj.getString("url");
            final String shareTitle = obj.getString("title");
            this.btnShare.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.intent.action.SEND");
                    intent.setType("text/plain");
                    intent.putExtra("android.intent.extra.TEXT", shareUrl);
                    intent.putExtra("android.intent.extra.SUBJECT", shareTitle);
                    MobGameActivity.this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Share"));
                }
            });
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (TextUtils.isEmpty((CharSequence)shareUrl)) {
                        MobGameActivity.this.btnShare.setVisibility(8);
                    } else {
                        MobGameActivity.this.btnShare.setVisibility(0);
                    }
                }
            });
        }
        catch (JSONException e) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MobGameActivity.this.btnShare.setVisibility(8);
                }
            });
        }
    }

    private class MobPagerAdapter
    extends FragmentPagerAdapter {
        private ArrayList<MobGameWebFragment> fragments;
        private FragmentManager fm;
        private JSONArray items;

        public MobPagerAdapter(FragmentManager fm) {
            super(fm);
            this.fragments = new ArrayList();
            this.fm = fm;
        }

        public void setItems(JSONArray items) {
            this.releaseFragments();
            this.items = items;
            this.fragments = new ArrayList();
            for (int i = 0; i < items.length(); ++i) {
                try {
                    JSONObject item = items.getJSONObject(i);
                    String url = item.getString("action");
                    MobGameWebFragment frag = new MobGameWebFragment(url);
                    frag.setEventListener(MobGameActivity.this.mWebEventListener);
                    frag.setWebViewTag(i + "");
                    this.fragments.add(frag);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Log.d((String)TAG, (String)"crash on function setItems");
                }
            }
        }

        public MobGameWebFragment getItem(int position) {
            try {
                return this.fragments.get(position);
            }
            catch (Exception e) {
                return null;
            }
        }

        public long getItemId(int position) {
            try {
                return this.items.getJSONObject(position).getInt("id");
            }
            catch (Exception e) {
                return -1L;
            }
        }

        public int getCount() {
            try {
                return this.fragments.size();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getItemPosition(Object item) {
            return -2;
        }

        public CharSequence getPageTitle(int position) {
            try {
                JSONObject item = this.items.getJSONObject(position);
                int id2 = item.getInt("id");
                if (item.has("title")) {
                    String title = item.getString("title").toUpperCase(Locale.ENGLISH);
                    if (NotificationUtils.hasNtf((Context)MobGameActivity.this, id2)) {
                        Drawable image = Res.drawable((Context)MobGameActivity.this, R.drawable.ic_notification_tab_strip);
                        image.setBounds(0, 0, image.getIntrinsicWidth(), image.getIntrinsicHeight());
                        SpannableString sb = new SpannableString((CharSequence)(title + "  "));
                        ImageSpan imageSpan = new ImageSpan(image, 1);
                        sb.setSpan((Object)imageSpan, title.length() + 1, title.length() + 2, 18);
                        return sb;
                    }
                    return title;
                }
                return "Tab " + position;
            }
            catch (Exception e) {
                return "Tab " + position;
            }
        }

        private void releaseFragments() {
            try {
                if (this.fragments != null) {
                    for (MobGameWebFragment frag : this.fragments) {
                        frag.stopLoading();
                        this.fm.beginTransaction().remove((Fragment)frag).commit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class SideMenuAdapter
    extends ArrayAdapter<SideMenuModel> {
        private Activity context;
        private List<SideMenuModel> items;

        public SideMenuAdapter(Activity activity, List<SideMenuModel> items) {
            super((Context)activity, R.layout.sidemenu_item);
            this.context = activity;
            this.items = items;
        }

        public SideMenuModel getItem(int position) {
            return this.items.get(position);
        }

        public int getCount() {
            return this.items.size();
        }

        @SuppressLint(value={"InflateParams"})
        public View getView(int position, View convertView, ViewGroup parent) {
            LayoutInflater inflator = this.context.getLayoutInflater();
            View v = inflator.inflate(R.layout.sidemenu_item, null);
            ImageView imageView = (ImageView)v.findViewById(R.id.image);
            imageView.setScaleType(ImageView.ScaleType.FIT_XY);
            TextView textView = (TextView)v.findViewById(R.id.label);
            ImageView imageView2 = (ImageView)v.findViewById(R.id.image2);
            textView.setText((CharSequence)this.items.get(position).label);
            Glide.with((Context)MobGameActivity.this.getApplicationContext()).load(this.items.get(position).iconUrl).into(imageView);
            switch (this.items.get((int)position).type) {
                case 1: {
                    imageView2.setImageResource(R.drawable.ic_external_sm);
                    imageView2.setVisibility(0);
                    break;
                }
                default: {
                    imageView2.setVisibility(8);
                }
            }
            try {
                for (int i = 0; i < this.items.get(position).getIds().length; ++i) {
                    if (!NotificationUtils.hasNtf((Context)this.context, this.items.get(position).getIds()[i])) continue;
                    imageView2.setImageResource(R.drawable.ic_notification);
                    imageView2.setVisibility(0);
                }
                if (NotificationUtils.hasNtf((Context)this.context, this.items.get(position).getId())) {
                    imageView2.setImageResource(R.drawable.ic_notification);
                    imageView2.setVisibility(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return v;
        }
    }

    private class SideMenuModel {
        private int id;
        private int[] ids;
        private String iconUrl;
        private String label;
        private String command;
        private String params;
        private JSONArray items;
        int type = 0;
        static final int DEFAULT = 0;
        static final int EXTERNAL = 1;

        public int[] getIds() {
            return this.ids;
        }

        public void setIds(int[] ids) {
            this.ids = ids;
        }

        public SideMenuModel(int id2, String imageUrl, String label) {
            this(id2, imageUrl, label, 0);
        }

        public SideMenuModel(int id2, String imageUrl, String label, int type) {
            this.id = id2;
            this.iconUrl = imageUrl;
            this.label = label;
            this.type = type;
        }

        public int getId() {
            return this.id;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setItems(JSONArray items) {
            this.items = items;
        }

        public void setAction(String command, String params) {
            this.command = command;
            this.params = params;
        }

        public String getCommand() {
            return this.command;
        }

        public String getParams() {
            return this.params;
        }

        public boolean isTabbed() {
            return this.items != null && this.items.length() > 1;
        }

        public boolean hasNtf() {
            if (NotificationUtils.hasNtf((Context)MobGameActivity.this, this.id)) {
                return true;
            }
            if (this.isTabbed()) {
                for (int i = 0; i < this.items.length(); ++i) {
                    try {
                        JSONObject item = this.items.getJSONObject(i);
                        int id2 = item.getInt("id");
                        if (NotificationUtils.hasNtf((Context)MobGameActivity.this, id2)) {
                            return true;
                        }
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            return false;
        }

        public JSONArray getItems() {
            return this.items;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

