/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.mobgame.MobGameSDK;
import com.mobgame.api.RestfulApi;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.Game;
import com.mobgame.utils.EncryptionUtils;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GetInfoBeforeAuthenTask
extends AsyncTask<Void, Void, Void> {
    private Listener callback;
    private NotiListener getEx;
    private JSONObject obj;

    public GetInfoBeforeAuthenTask(NotiListener getEx) {
        this.getEx = getEx;
    }

    public GetInfoBeforeAuthenTask(Listener callback) {
        Log.d((String)"TAG", (String)"GO HERE");
        this.callback = callback;
    }

    protected Void doInBackground(Void ... params) {
        Context c = MobGameSDK.getApplicationContext();
        String sign = EncryptionUtils.getSignedString(c);
        RestfulApi api = RestfulApi.getInstance();
        Call<EncodedResponse> call = api.getInfoBeforeAuthen(sign);
        call.enqueue((Callback)new Callback<EncodedResponse>(){

            public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {
                block7: {
                    try {
                        Log.d((String)"TAG", (String)("response:" + response.body()));
                        if (response.isSuccessful()) {
                            String responseBody = ((EncodedResponse)response.body()).getDecodedData();
                            Game game = Game.parse(responseBody);
                            GetInfoBeforeAuthenTask.this.obj = new JSONObject(responseBody);
                            if (GetInfoBeforeAuthenTask.this.getEx != null) {
                                GetInfoBeforeAuthenTask.this.getEx.onSuccess(GetInfoBeforeAuthenTask.this.getUrl(), GetInfoBeforeAuthenTask.this.getText(), GetInfoBeforeAuthenTask.this.getIsShow());
                            }
                            if (GetInfoBeforeAuthenTask.this.callback != null) {
                                GetInfoBeforeAuthenTask.this.callback.onSuccess(game);
                            }
                        } else if (GetInfoBeforeAuthenTask.this.callback != null) {
                            GetInfoBeforeAuthenTask.this.callback.onFailure(new Exception());
                        }
                    }
                    catch (Exception e) {
                        if (GetInfoBeforeAuthenTask.this.callback == null) break block7;
                        GetInfoBeforeAuthenTask.this.callback.onFailure(e);
                    }
                }
            }

            public void onFailure(Call<EncodedResponse> call, Throwable t) {
                if (GetInfoBeforeAuthenTask.this.callback != null) {
                    GetInfoBeforeAuthenTask.this.callback.onFailure(t);
                }
            }
        });
        return null;
    }

    private boolean getIsShow() {
        boolean isShow = false;
        try {
            JSONObject data = this.obj.getJSONObject("ex");
            isShow = data.getBoolean("show_logo");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return isShow;
    }

    private String getText() {
        String text = "";
        try {
            JSONObject data = this.obj.getJSONObject("ex");
            text = data.getString("text");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return text;
    }

    private String getUrl() {
        String text = "";
        try {
            JSONObject data = this.obj.getJSONObject("ex");
            text = data.getString("logo_url");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return text;
    }

    public static interface NotiListener {
        public void onSuccess(String var1, String var2, boolean var3);

        public void onFailure(Throwable var1);
    }

    public static interface Listener {
        public void onSuccess(Game var1);

        public void onFailure(Throwable var1);
    }
}

