package com.mobgame.api;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.mobgame.MobGameSDK;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.Game;
import com.mobgame.utils.EncryptionUtils;

import org.json.JSONException;
import org.json.JSONObject;

public class GetInfoBeforeAuthenTask extends AsyncTask<Void, Void, Void> {

	private Listener callback;
	private NotiListener getEx;
	private JSONObject obj;

	public GetInfoBeforeAuthenTask(NotiListener getEx) {
		this.getEx = getEx;
	}

	public GetInfoBeforeAuthenTask(Listener callback) {
		Log.d("TAG" , "GO HERE");
		this.callback = callback;
	}

	@Override
	protected Void doInBackground(Void... params) {
		Context c = MobGameSDK.getApplicationContext();
		String sign = EncryptionUtils.getSignedString(c);

		RestfulApi api = RestfulApi.getInstance();
		Call<EncodedResponse> call = api.getInfoBeforeAuthen(sign);
		call.enqueue(new Callback<EncodedResponse>() {

			@Override
			public void onResponse(Call<EncodedResponse> call, Response<EncodedResponse> response) {
				try {
					Log.d("TAG" , "response:" + response.body());
					if (response.isSuccessful()) {
						String responseBody = response.body().getDecodedData();
						Game game = Game.parse(responseBody);
						//Log.e("reponse -------",responseBody);
						obj = new JSONObject(responseBody);
						if (getEx != null) {
							getEx.onSuccess(getUrl(), getText(), getIsShow());
						}


						if (callback != null) {
							callback.onSuccess(game);
						}
					} else {
						if (callback != null) {
							callback.onFailure(new Exception());
						}
					}
				} catch (Exception e) {
					if (callback != null) {
						callback.onFailure(e);
					}
				}
			}

			@Override
			public void onFailure(Call<EncodedResponse> call, Throwable t) {
				if (callback != null) {
					callback.onFailure(t);
				}
			}
		});
		return null;
	}

	public interface Listener {
		public void onSuccess(Game game);
		public void onFailure(Throwable t);
	}


	public interface NotiListener {
		public void onSuccess(String url, String notiText, boolean isShow);
		public void onFailure(Throwable t);
	}

	private boolean getIsShow (){
		boolean isShow = false;
		try {
			JSONObject data = obj.getJSONObject("ex");
			isShow = data.getBoolean("show_logo");
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return isShow;
	}

	private String getText () {
		String text = "";
		try {
			JSONObject data = obj.getJSONObject("ex");
			text = data.getString("text");
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return text;
	}

	private String getUrl () {
		String text = "";
		try {
			JSONObject data = obj.getJSONObject("ex");
			text = data.getString("logo_url");
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return text;
	}
}