/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.content.Context;
import android.util.Base64;
import com.mobgame.MobGameSDK;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.EncodedResponse;
import com.mobgame.model.LoginResponse;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.EncryptionUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Utils;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.HashSet;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

class RestfulApi {
    private static final String API_BASE_URL = "http://a.smobgame.com";
    private static RestfulApi INSTANCE;
    private PlfRestService restService;
    private static Retrofit retrofit;

    public static RestfulApi getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestfulApi();
        }
        return INSTANCE;
    }

    private RestfulApi() {
        OkHttpClient httpClient = RestfulApi.getCommonClient();
        retrofit = new Retrofit.Builder().baseUrl(API_BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(httpClient).build();
        this.restService = (PlfRestService)retrofit.create(PlfRestService.class);
    }

    static OkHttpClient getCommonClient() {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Context context = MobGameSDK.getApplicationContext();
                GameConfigManager config = GameConfigManager.getInstance();
                Request.Builder builder = chain.request().newBuilder().addHeader("mobgame-device", DeviceUtils.getDevice()).addHeader("mobgame-os", DeviceUtils.getOSInfo()).addHeader("mobgame-resolution", DeviceUtils.getResolution(context)).addHeader("mobgame-sdk-version", Utils.getSDKVersion(context)).addHeader("mobgame-appkey", GameConfigManager.getInstance().getAppKey()).addHeader("mobgame-app-version", Utils.getGameVersion(context)).addHeader("mobgame-app-version-code", Utils.getGameVersionCode(context)).addHeader("mobgame-network", Utils.getNetwork(context)).addHeader("mobgame-orientation", DeviceUtils.getScreenOrientation(context) + "").addHeader("mobgame-distributor", Utils.getReferrer(context)).addHeader("mobgame-advertising-id", DeviceUtils.getAdvertisingID(context));
                if (config.getAccessToken() != null) {
                    builder.addHeader("mobgame-token", config.getAccessToken());
                }
                if (config.getCharacterInfo().getRoleId() != null) {
                    builder.addHeader("mobgame-role-id", config.getCharacterInfo().getRoleId());
                }
                if (config.getCharacterInfo().getAreaId() != null) {
                    builder.addHeader("mobgame-area-id", config.getCharacterInfo().getAreaId());
                }
                if (config.getCharacterInfo().getRoleName() != null) {
                    builder.addHeader("mobgame-role-name", config.getCharacterInfo().getRoleName());
                }
                if (config.getCharacterInfo().getAreaName() != null) {
                    builder.addHeader("mobgame-area-name", config.getCharacterInfo().getAreaName());
                }
                Request request = builder.build();
                return chain.proceed(request);
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Context c = MobGameSDK.getApplicationContext();
                Request.Builder builder = chain.request().newBuilder();
                HashSet preferences = (HashSet)Preference.getStringSet(c, "shared_pref_cookies", new HashSet<String>());
                for (String cookie : preferences) {
                    builder.addHeader("Cookie", cookie);
                }
                return chain.proceed(builder.build());
            }
        }).addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response originalResponse = chain.proceed(chain.request());
                if (!originalResponse.headers("Set-Cookie").isEmpty()) {
                    Context c = MobGameSDK.getApplicationContext();
                    HashSet<String> cookies = new HashSet<String>();
                    for (String header : originalResponse.headers("Set-Cookie")) {
                        cookies.add(header);
                    }
                    Preference.save(c, "shared_pref_cookies", cookies);
                }
                return originalResponse;
            }
        }).build();
        return httpClient;
    }

    static String decode(String responseBody) {
        try {
            JSONObject objEncode = new JSONObject(responseBody);
            if (objEncode.has("data")) {
                String data = objEncode.getString("data");
                byte[] decodeFromBase64 = Base64.decode((String)data, (int)0);
                return EncryptionUtils.decryptionDataBlowfish(decodeFromBase64);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Call<EncodedResponse> getInfoBeforeAuthen(String sign) {
        return this.restService.getInfoBeforeAuthen(sign);
    }

    public Call<EncodedResponse> getInfoAfterAuthen(String sign) {
        return this.restService.getInfoAfterAuthen(sign);
    }

    public Call<ResponseBody> saveGCM(String regId) {
        return this.restService.saveGCM(regId);
    }

    public Call<ResponseBody> saveCharacter(String roleId, String areaId, String roleName, String areaName) {
        return this.restService.saveCharacter(roleId, areaId, roleName, areaName);
    }

    public Call<ResponseBody> processGooglePayment(String receipt) {
        return this.restService.googleRetrieveReceipt(receipt);
    }

    public Call<ResponseBody> processPaypalPayment(String receipt, String areaId, String roleId) {
        return this.restService.paypalRetrieveReceipt(receipt, areaId, roleId);
    }

    public Call<LoginResponse> upgradeToFacebook(String token) {
        return this.restService.upgradeToFacebook(token, "true");
    }

    private static interface PlfRestService {
        @GET(value="/plf/Oauthv2/getInfoBeforeAuthenv3.json")
        public Call<EncodedResponse> getInfoBeforeAuthen(@Query(value="sign") String var1);

        @POST(value="/plf/Oauthv2/getInfoAfterAuthenv3.json")
        public Call<EncodedResponse> getInfoAfterAuthen(@Query(value="sign") String var1);

        @FormUrlEncoded
        @POST(value="/plf/Oauthv2/saveGCM.json")
        public Call<ResponseBody> saveGCM(@Field(value="regid") String var1);

        @FormUrlEncoded
        @POST(value="/plf/Oauthv2/saveCharacter.json")
        public Call<ResponseBody> saveCharacter(@Field(value="roleid") String var1, @Field(value="areaid") String var2, @Field(value="rolename") String var3, @Field(value="areaname") String var4);

        @FormUrlEncoded
        @POST(value="/plf/payments/googleRetrieveReceipt.json")
        public Call<ResponseBody> googleRetrieveReceipt(@Field(value="transaction_receipt") String var1);

        @FormUrlEncoded
        @POST(value="/plf/payments/paypalRetrieveReceipt.json")
        public Call<ResponseBody> paypalRetrieveReceipt(@Field(value="transaction_receipt") String var1, @Field(value="game_area_id") String var2, @Field(value="game_role_id") String var3);

        @FormUrlEncoded
        @POST(value="/plf/users/updateFromFacebookV2")
        public Call<LoginResponse> upgradeToFacebook(@Field(value="token") String var1, @Field(value="native") String var2);
    }
}

