package com.mobgame.gui.floatbutton;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.DialogInterface;
import android.graphics.drawable.AnimationDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.ImageView;
import android.widget.TextView;

import com.mobgame.R;
import com.mobgame.utils.Res;

@SuppressLint("ValidFragment")
public class MobGameFloatConfirmDialog extends DialogFragment {

	private static String TAG = MobGameOverlayView.class.getSimpleName();

	Activity activity;
	EventListener eventListener;

	@SuppressLint("ValidFragment")
	public MobGameFloatConfirmDialog(Activity activity, EventListener eventListener) {
		this.activity = activity;
		this.eventListener = eventListener;
		setStyle(DialogFragment.STYLE_NO_TITLE, 0);
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		View view = inflater.inflate(R.layout.float_dialog, container, false);

		TextView txtTitle = (TextView) view.findViewById(R.id.txt_guide);
		ImageView imgGuide = (ImageView) view.findViewById(R.id.img_guide);
//		Button btnCancel = (Button) view.findViewById(R.id.btn_cancel);
		Button btnConfirm = (Button) view.findViewById(R.id.btn_confirm);
		CheckBox cbxShowAgain = (CheckBox) view.findViewById(R.id.cbx_show_tips_again);

		imgGuide.setImageResource(Res.drawableResource(activity, R.drawable.float_hide_tips_animation));
		AnimationDrawable frameAnimation = (AnimationDrawable) imgGuide.getDrawable();
		frameAnimation.start();
		
		txtTitle.setText(Res.string(activity, R.string.dialog_tips_title));
		cbxShowAgain.setText(Res.string(activity, R.string.dont_ask_again));

		btnConfirm.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				if (eventListener != null) {
					eventListener.onConfirmClick(v);
				}
			}
		});
		
		cbxShowAgain.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				if (eventListener != null) {
					eventListener.onCheckedChanged(buttonView, isChecked);
				}
			}
		});

		return view;
	}

	@Override
	public void onCancel(DialogInterface dialog) {
		if (eventListener != null) {
			eventListener.onCancelClick(null);
		}
	}

	public void show() {
		show(activity.getFragmentManager(), TAG);
	}
	
	@Override
	public void onSaveInstanceState(Bundle outState) {
	    //No call for super(). Bug on API Level > 11.
	}

	public interface EventListener {
		public void onCancelClick(View v);
		public void onConfirmClick(View v);
		public void onCheckedChanged(CompoundButton buttonView, boolean isChecked);
	}

}