/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.Chronometer;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;

public class CountdownChronometer
extends Chronometer {
    private static final String TAG = "CountdownChronometer";
    private static final String FAST_FORMAT_DHHMMSS = "%1$02d:%2$02d:%3$02d:%4$02d";
    private static final String FAST_FORMAT_HMMSS = "%1$02d:%2$02d:%3$02d";
    private static final String FAST_FORMAT_MMSS = "%1$02d:%2$02d";
    private static final String TIME_PADDING = "";
    private static final char TIME_SEPARATOR = ':';
    private long mBase;
    private boolean mVisible;
    private boolean mStarted;
    private boolean mRunning;
    private boolean mLogged;
    private String mFormat;
    private Formatter mFormatter;
    private Locale mFormatterLocale;
    private Object[] mFormatterArgs = new Object[1];
    private StringBuilder mFormatBuilder;
    private Chronometer.OnChronometerTickListener mOnChronometerTickListener;
    private Chronometer.OnChronometerTickListener mOnCountdownCompleteListener;
    private StringBuilder mRecycle = new StringBuilder(8);
    private String mChronoFormat;
    private CountdownListener countdownListener;
    private long runningTime;
    private static final int TICK_WHAT = 3;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message m) {
            if (CountdownChronometer.this.mRunning) {
                if (CountdownChronometer.this.updateText(System.currentTimeMillis())) {
                    CountdownChronometer.this.dispatchChronometerTick();
                    this.sendMessageDelayed(Message.obtain((Handler)this, (int)3), 1000L);
                } else {
                    CountdownChronometer.this.dispatchCountdownCompleteEvent();
                    CountdownChronometer.this.stop();
                }
            }
        }
    };

    public CountdownChronometer(Context context) {
        this(context, null, 0, 0L);
    }

    public CountdownChronometer(Context context, long base) {
        this(context, null, 0, base);
    }

    public CountdownChronometer(Context context, AttributeSet attrs) {
        this(context, attrs, 0, 0L);
    }

    public CountdownChronometer(Context context, AttributeSet attrs, int defStyle, long base) {
        super(context, attrs, defStyle);
        this.init(base);
    }

    private void init(long base) {
        this.mBase = base;
        this.updateText(System.currentTimeMillis());
    }

    public void setBase(long base) {
        this.mBase = base;
        this.dispatchChronometerTick();
        this.updateText(System.currentTimeMillis());
    }

    public long getBase() {
        return this.mBase;
    }

    public void setFormat(String format) {
        this.mFormat = format;
        if (format != null && this.mFormatBuilder == null) {
            this.mFormatBuilder = new StringBuilder(format.length() * 2);
        }
    }

    public String getFormat() {
        return this.mFormat;
    }

    public void setCustomChronoFormat(String chronoFormat) {
        this.mChronoFormat = chronoFormat;
    }

    public String getCustomChronoFormat() {
        return this.mChronoFormat;
    }

    public void setOnChronometerTickListener(Chronometer.OnChronometerTickListener listener) {
        this.mOnChronometerTickListener = listener;
    }

    public Chronometer.OnChronometerTickListener getOnChronometerTickListener() {
        return this.mOnChronometerTickListener;
    }

    public void setOnCompleteListener(Chronometer.OnChronometerTickListener listener) {
        this.mOnCountdownCompleteListener = listener;
    }

    public Chronometer.OnChronometerTickListener getOnCompleteListener() {
        return this.mOnCountdownCompleteListener;
    }

    public void start() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void setCountdownListener(CountdownListener countdownListener) {
        this.countdownListener = countdownListener;
    }

    public void stop() {
        this.mStarted = false;
        this.updateRunning();
    }

    public void setStarted(boolean started) {
        this.mStarted = started;
        this.updateRunning();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.updateRunning();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.updateRunning();
    }

    private synchronized boolean updateText(long now) {
        String text;
        boolean stillRunning;
        block6: {
            this.runningTime = this.mBase - now;
            long seconds = this.runningTime / 1000L;
            stillRunning = true;
            if (seconds <= 0L) {
                stillRunning = false;
                seconds = 0L;
                if (this.countdownListener != null) {
                    this.countdownListener.done();
                }
            }
            text = this.formatRemainingTime(this.mRecycle, seconds);
            if (this.mFormat != null) {
                Locale loc = Locale.getDefault();
                if (this.mFormatter == null || !loc.equals(this.mFormatterLocale)) {
                    this.mFormatterLocale = loc;
                    this.mFormatter = new Formatter(this.mFormatBuilder, loc);
                }
                this.mFormatBuilder.setLength(0);
                this.mFormatterArgs[0] = text;
                try {
                    this.mFormatter.format(this.mFormat, this.mFormatterArgs);
                    text = this.mFormatBuilder.toString();
                }
                catch (IllegalFormatException ex) {
                    if (this.mLogged) break block6;
                    Log.w((String)TAG, (String)("Illegal format string: " + this.mFormat));
                    this.mLogged = true;
                }
            }
        }
        this.setText(text);
        return stillRunning;
    }

    private void updateRunning() {
        boolean running;
        boolean bl = running = this.mVisible && this.mStarted;
        if (running != this.mRunning) {
            if (running) {
                if (this.updateText(System.currentTimeMillis())) {
                    this.dispatchChronometerTick();
                    this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)3), 1000L);
                } else {
                    this.mHandler.removeMessages(3);
                    running = false;
                    if (this.countdownListener != null) {
                        this.countdownListener.done();
                    }
                }
            } else {
                this.mHandler.removeMessages(3);
            }
            this.mRunning = running;
        }
    }

    void dispatchChronometerTick() {
        if (this.mOnChronometerTickListener != null) {
            this.mOnChronometerTickListener.onChronometerTick((Chronometer)this);
        }
    }

    void dispatchCountdownCompleteEvent() {
        if (this.mOnCountdownCompleteListener != null) {
            this.mOnCountdownCompleteListener.onChronometerTick((Chronometer)this);
        }
    }

    private String formatRemainingTime(StringBuilder recycle, long elapsedSeconds) {
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        if (elapsedSeconds >= 86400L) {
            days = elapsedSeconds / 86400L;
            elapsedSeconds -= days * 86400L;
        }
        if (elapsedSeconds >= 3600L) {
            hours = elapsedSeconds / 3600L;
            elapsedSeconds -= hours * 3600L;
        }
        if (elapsedSeconds >= 60L) {
            minutes = elapsedSeconds / 60L;
            elapsedSeconds -= minutes * 60L;
        }
        seconds = elapsedSeconds;
        if (this.mChronoFormat != null) {
            return CountdownChronometer.formatRemainingTime(recycle, this.mChronoFormat, days, hours, minutes, seconds);
        }
        if (days > 0L) {
            return CountdownChronometer.formatRemainingTime(recycle, FAST_FORMAT_DHHMMSS, days, hours, minutes, seconds);
        }
        if (hours > 0L) {
            return CountdownChronometer.formatRemainingTime(recycle, FAST_FORMAT_HMMSS, hours, minutes, seconds);
        }
        return CountdownChronometer.formatRemainingTime(recycle, FAST_FORMAT_MMSS, minutes, seconds);
    }

    private static String formatRemainingTime(StringBuilder recycle, String format, long days, long hours, long minutes, long seconds) {
        if (FAST_FORMAT_DHHMMSS.equals(format)) {
            StringBuilder sb = recycle;
            if (sb == null) {
                sb = new StringBuilder(8);
            } else {
                sb.setLength(0);
            }
            if (days < 10L) {
                sb.append(TIME_PADDING);
            }
            sb.append(days + "d");
            sb.append(':');
            if (hours < 10L) {
                sb.append(TIME_PADDING);
            } else {
                sb.append(CountdownChronometer.toDigitChar(hours / 10L));
            }
            sb.append(CountdownChronometer.toDigitChar(hours % 10L) + "h");
            return sb.toString();
        }
        return String.format(format, days, hours, minutes, seconds);
    }

    private static String formatRemainingTime(StringBuilder recycle, String format, long hours, long minutes, long seconds) {
        if (FAST_FORMAT_HMMSS.equals(format)) {
            StringBuilder sb = recycle;
            if (sb == null) {
                sb = new StringBuilder(8);
            } else {
                sb.setLength(0);
            }
            if (hours < 10L) {
                sb.append(TIME_PADDING);
                sb.append(hours);
            } else {
                sb.append(hours);
            }
            sb.append(':');
            if (minutes < 10L) {
                sb.append(TIME_PADDING);
            } else {
                sb.append(CountdownChronometer.toDigitChar(minutes / 10L));
            }
            sb.append(CountdownChronometer.toDigitChar(minutes % 10L));
            sb.append(':');
            if (seconds < 10L) {
                sb.append(TIME_PADDING);
                sb.append(CountdownChronometer.toDigitChar(seconds % 10L));
            } else {
                sb.append(seconds);
            }
            return sb.toString();
        }
        return String.format(format, hours, minutes, seconds);
    }

    private static String formatRemainingTime(StringBuilder recycle, String format, long minutes, long seconds) {
        if (FAST_FORMAT_MMSS.equals(format)) {
            StringBuilder sb = recycle;
            if (sb == null) {
                sb = new StringBuilder(8);
            } else {
                sb.setLength(0);
            }
            sb.append(TIME_PADDING).append(TIME_PADDING);
            if (minutes < 10L) {
                sb.append(TIME_PADDING);
            } else {
                sb.append(CountdownChronometer.toDigitChar(minutes / 10L));
            }
            sb.append(CountdownChronometer.toDigitChar(minutes % 10L));
            sb.append(':');
            if (seconds < 10L) {
                sb.append(TIME_PADDING);
            } else {
                sb.append(CountdownChronometer.toDigitChar(seconds / 10L));
            }
            sb.append(CountdownChronometer.toDigitChar(seconds % 10L));
            return sb.toString();
        }
        return String.format(format, minutes, seconds);
    }

    private static char toDigitChar(long digit) {
        return (char)(digit + 48L);
    }

    public long getRunningTime() {
        return this.runningTime;
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public static interface CountdownListener {
        public void done();
    }
}

