package com.mobgame.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings.Secure;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.ViewConfiguration;
import android.view.WindowManager;

import com.mobgame.utils.AdvertisingIdClient.AdInfo;

import java.lang.reflect.InvocationTargetException;

public final class DeviceUtils {

	private static final String TAG = DeviceUtils.class.getSimpleName();
	
	public static float getDensity(Context context) {
		return context.getResources().getDisplayMetrics().density;
	}

	public static int getScreenWidthInPixels(Context context) {
		return context.getResources().getDisplayMetrics().widthPixels;
	}

	public static int getScreenHeightInPixels(Context context) {
		return context.getResources().getDisplayMetrics().heightPixels;
	}
	
	@SuppressLint("NewApi")
	public static int getRealScreenWidthInPixels(Context context) {
		WindowManager windowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
	    Display display = windowManager.getDefaultDisplay();
	    Point size = new Point();

	    if (Build.VERSION.SDK_INT >= 17) {
	        display.getRealSize(size);
	    } else if (Build.VERSION.SDK_INT >= 14) {
	        try {
	            size.x = (Integer) Display.class.getMethod("getRawWidth").invoke(display);
	            size.y = (Integer) Display.class.getMethod("getRawHeight").invoke(display);
	        } catch (IllegalAccessException e) {} catch (InvocationTargetException e) {} catch (NoSuchMethodException e) {}
	    }

	    return size.x;
	}

	@SuppressLint("NewApi")
	public static int getRealScreenHeightInPixels(Context context) {
		WindowManager windowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
	    Display display = windowManager.getDefaultDisplay();
	    Point size = new Point();

	    if (Build.VERSION.SDK_INT >= 17) {
	        display.getRealSize(size);
	    } else if (Build.VERSION.SDK_INT >= 14) {
	        try {
	            size.x = (Integer) Display.class.getMethod("getRawWidth").invoke(display);
	            size.y = (Integer) Display.class.getMethod("getRawHeight").invoke(display);
	        } catch (IllegalAccessException e) {} catch (InvocationTargetException e) {} catch (NoSuchMethodException e) {}
	    }

	    return size.y;
	}

	public static int getStatusBarHeightInPixels(Context context) {
		Resources resources = context.getResources();
		int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
		if (resourceId > 0) {
			return resources.getDimensionPixelSize(resourceId);
		}
		return 0;
	}

	public static int getNavigationBarHeightInPixels(Context context) {
		return getRealScreenHeightInPixels(context)
			- getScreenHeightInPixels(context);
//		if (!isNavigationBarAvailable(context)) return 0;
//		Resources resources = context.getResources();
//		int orientation = context.getResources().getConfiguration().orientation;
//		int id = resources.getIdentifier(
//				orientation == Configuration.ORIENTATION_PORTRAIT
//					? "navigation_bar_height"
//					: "navigation_bar_height_landscape", 
//				"dimen", "android");
//		if (id > 0) {
//			return resources.getDimensionPixelSize(id);
//		}
//		return 0;
	}

	public static int getScreenOrientation(Context context) {
		// Query what the orientation currently really is.
		if (context.getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
			return 1; // Portrait Mode

		} else if (context.getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
			return 2; // Landscape mode
		}
		return 0;
	}
	
	@SuppressLint("NewApi") 
	public static boolean isNavigationBarOnBottom(Context context) {
		Resources res = context.getResources();
		Configuration cfg = res.getConfiguration();
		DisplayMetrics dm = res.getDisplayMetrics();
		boolean canMove = (dm.widthPixels != dm.heightPixels && cfg.smallestScreenWidthDp < 600);

		return (!canMove || dm.widthPixels < dm.heightPixels);
	}

	@SuppressLint("NewApi") 
	public static boolean isNavigationBarAvailable(Context context) {
		try {
			return ViewConfiguration.get(context).hasPermanentMenuKey();
		} catch (Exception e) {
			boolean hasBackKey = KeyCharacterMap.deviceHasKey(KeyEvent.KEYCODE_BACK);
			boolean hasHomeKey = KeyCharacterMap.deviceHasKey(KeyEvent.KEYCODE_HOME);
			return (!(hasBackKey && hasHomeKey));
		}
	}

	public static String getResolution(Context c) {
		try {
			DisplayMetrics displayMetrics = new DisplayMetrics();
			((WindowManager) c.getSystemService(Context.WINDOW_SERVICE)).getDefaultDisplay().getMetrics(displayMetrics);
			String wh = displayMetrics.widthPixels + "x" + displayMetrics.heightPixels;
			
			/*
			 * IOS wh = "1136x300"; wh = "960x250"; wh = "1536x650"; wh =
			 * "2048x500"; wh = "768x325"; wh = "1024x250"; wh = "1334x350";
			 * wh = "750x530"; wh = "1920x520"; wh = "1080x750";
			 */

			/* Android */
			// Phone
			// wh = "320x480";
			// wh = "480x800";
			// wh = "480x854";
			// wh = "540x960";
			// wh = "1280x720";
			// wh = "1920x1080";
			// tablet
			// wh = "1280x800";
			// wh = "1024x600";
			
			return wh;
		} catch (Exception e) {
			return null;
		}
	}

	public static String getOSInfo() {
		return Build.MANUFACTURER + " " + Build.PRODUCT + " " + Build.VERSION.RELEASE + " " + Build.VERSION.SDK_INT;
	}

	public static String getDevice() {
		return Build.MODEL;
	}

	public static String getDeviceID(Context c) {
		try {
			TelephonyManager telephonyManager = (TelephonyManager) c.getSystemService(Context.TELEPHONY_SERVICE);
			String deviceId = null;
			int phoneType = telephonyManager.getPhoneType();
			Log.i("getDeviceID", "--phoneType:" + phoneType);
			switch (phoneType) {
				case TelephonyManager.PHONE_TYPE_NONE:
				case TelephonyManager.PHONE_TYPE_SIP:
				case TelephonyManager.PHONE_TYPE_CDMA:
					deviceId = telephonyManager.getDeviceId();
					break;
				case TelephonyManager.PHONE_TYPE_GSM:
					deviceId = telephonyManager.getSubscriberId();
					break;
				default:
					deviceId = null;
			}
			return deviceId;
		} catch (Exception e) {
			return null;
		}
	}

	public static String getAndroidID(Context c) {
		return Secure.getString(c.getContentResolver(), Secure.ANDROID_ID);
	}

	public static String getUniqueDeviceID(Context c) {
		String id = getAndroidID(c);
		if (TextUtils.isEmpty(id)) {
			id = getDeviceID(c);
		}
		Log.i(TAG, "getUniqueDeviceID: " + id);
		return Utils.getSHACheckSum(id);
	}
	
	private static String tmpAdvertisingID;
	public static String getAdvertisingID(final Context context) {

		if (TextUtils.isEmpty(tmpAdvertisingID)) {
			try {
				AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
				String adId = adInfo.getId();
				Log.i("Google Advertising id:", "Advertising ID :" + adId);
				tmpAdvertisingID = adId;
				Preference.save(context, "advertisingId", adId);
			} catch (Exception e) {
				e.printStackTrace();
			}
			return tmpAdvertisingID;
		} else {
			return tmpAdvertisingID;
		}
	}

}
