package com.mobgame.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;

import com.mobgame.model.MUrl;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Pattern;

public class Utils {

	private static String TAG = Utils.class.getSimpleName();

	public static String getReferrer(Context c) {
		return Preference.getString(c, Constants.SHARED_PREF_REFERRER);
	}
	
	public static void setReferrer(Context c, String value) {
		Preference.save(c, Constants.SHARED_PREF_REFERRER, value);
	}
	
	public static String getGameVersion(Context c) {
		String versionName = null;
		final PackageManager packageManager = c.getPackageManager();
		if (packageManager != null) {
			try {
				PackageInfo packageInfo = packageManager.getPackageInfo(c.getPackageName(), 0);
				versionName = packageInfo.versionName;
			} catch (PackageManager.NameNotFoundException e) {
				versionName = null;
			}
		}
		return versionName;
	}

	public static String stringNormalize(String s){
		try{
	//		s = "á à ă ắ ằ ẵ ẳ â ấ ầ ẫ ẩ ǎ å ǻ ä ǟ ã ȧ ǡ ą ā ả ȁ ȃ ạ ặ ậ ḁ ǽ ǣḃ ḅ ḇ ć ĉ č ċ ç ḉ ď ḋ ḑ ḍ ḓ ḏ é è ĕ ê ế ề ễ ể ě ë ẽ ė ȩ ḝ ę ēḗ ḕ ẻ ȅ ȇ ẹ ệ ḙ ḛ ḟ ǵ ğ ĝ ǧ ġ ģ ḡ ĥ ȟ ḧ ḣ ḩ ḥ ḫ ẖ í ì ĭ î ǐ ï ḯ ĩį ī ỉ ȉ ȋ ị ḭ ĵ ǰ ḱ ǩ ķ ḳ ḵ ĺ ľ ļ ḷ ḹ ḽ ḻ ḿ ṁ ṃ ń ǹ ň ñ ṅ ņ ṇ ṋ ṉ óò ŏ ô ố ồ ỗ ổ ǒ ö ȫ ő õ ṍ ṏ ȭ ȯ ȱ ǫ ǭ ō ṓ ṑ ỏ ȍ ȏ ơ ớ ờ ỡở ợ ọ ộ ǿ ṕ ṗ ŕ ř ṙ ŗ ȑ ȓ ṛ ṝ ṟ ś ṥ ŝ š ṧ ṡ ş ṣ ṩ ș ť ẗ ṫ ţ ṭ ț ṱ ṯ úù ŭ û ǔ ů ü ǘ ǜ ǚ ǖ ű ũ ṹ ų ū ṻ ủ ȕ ȗ ư ứ ừ ữ ử ự ụ ṳ ṷ ṵ ṽṿ ẃ ẁ ŵ ẘ ẅ ẇ ẉ ẍ ẋ ý ỳ ŷ ẙ ÿ ỹ ẏ ȳ ỷ ỵ ź ẑ ž ż ẓ ẕ ǯ ";
			s = Normalizer.normalize(s, Normalizer.Form.NFD);
			String resultString = s.replaceAll("[^\\x00-\\x7F]", "");
			return ""+resultString;
		}catch (Exception e){
			e.printStackTrace();
			return "";
		}
	}

	public static String removeAccent(String s) {
		String temp = Normalizer.normalize(s, Normalizer.Form.NFD);
		Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
		return pattern.matcher(temp).replaceAll("");
	}
	
	public static String getGameVersionCode(Context c) {
		String versionCode = null;
		final PackageManager packageManager = c.getPackageManager();
		if (packageManager != null) {
			try {
				PackageInfo packageInfo = packageManager.getPackageInfo(c.getPackageName(), 0);
				versionCode = packageInfo.versionCode + "";
			} catch (PackageManager.NameNotFoundException e) {
				versionCode = null;
			}
		}
		return versionCode;
	}

	public static String getSDKVersion(Context c) {
		return Constants.SDK_VERSION;
	}
	
	public static String getNetwork(Context context) {
		try {
			ConnectivityManager manager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
			NetworkInfo info = manager.getActiveNetworkInfo();
			if (info != null)
				return info.getTypeName();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "";
	}


	public static boolean isDashboardEnabled(Context c) {
		return Preference.getBoolean(c, 
				Constants.SHARED_PREF_DB_ENABLED, 
				false);
	}

	public static boolean isPlfUrl(MUrl url) {
		return isPlfUrl(url.getPath());
	}
	public static boolean hasDomain(String url){
		try {
			String u = url.toLowerCase();
			if (u.contains(Constants.BASE_URL_DOMAIN)) {
				return true;
			}else{
				return false;
			}
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}
	public static boolean isPlfUrl(String url) {
		try {
			String u = url.toLowerCase(Locale.ENGLISH);
			return u.startsWith("http://" + Constants.DOMAIN_NAME)
					|| u.startsWith("https://" + Constants.DOMAIN_NAME);
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}
	
	private static ProgressDialog progressDialog;
	
	public static void showLoading(Activity a, String message) {
		showLoading(a, null, message);
	}
//
	public static void showLoading(Activity a, String title, final String message){
		showLoading(a, null, message, true);
//		showLoading(a, null, message, false);
	}
	
	public static void showLoading(Activity a, String title, final String message, boolean cancelable) {
		try {
			hideLoading();
//		progressDialog = ProgressDialog.show(a, title, message + "    ");
			progressDialog = new ProgressDialog(getContextThemeWrapper(a));
			progressDialog.setMessage(message);
			progressDialog.setIndeterminateDrawable(null);
//		progressDialog.setCancelable(false);
			progressDialog.show();
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	public static void hideLoading() {
		if (progressDialog != null) {
			progressDialog.dismiss();
		}
	}
	
	public static ContextThemeWrapper getContextThemeWrapper(Context c) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
			return new ContextThemeWrapper(c, android.R.style.Theme_Holo_Light_Dialog_NoActionBar);
		} else {
			return new ContextThemeWrapper(c, android.R.style.Theme_Light_NoTitleBar);
		}
	}

	public static String getSHACheckSum(String checksum) {
		try {
			MessageDigest md = MessageDigest.getInstance("SHA1");
			md.update(checksum.getBytes());
			byte byteData[] = md.digest();

			// convert the byte to hex format method 1
			StringBuffer sb = new StringBuffer();
			for (int i = 0; i < byteData.length; i++) {
				sb.append(Integer.toString((byteData[i] & 0xff) + 0x100, 16).substring(1));
			}
			return sb.toString();
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
			return null;
		}
	}

	public static boolean isJSONValid(String jsonString) {
		if (TextUtils.isEmpty(jsonString)) {
			return false;
		} else {
			try {
				new JSONObject(jsonString);
			} catch (JSONException ex) {
				return false;
			}
		}
		return true;
	}

	public static boolean canDrawOverApp(Context c) {
		if (Build.VERSION.SDK_INT >= 23) {
			try {
				Method m = Settings.class.getDeclaredMethod("canDrawOverlays", Context.class);
				m.setAccessible(true); //if security settings allow this
				Boolean o = (Boolean) m.invoke(null, c);
				return o;
			} catch (NoSuchMethodException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
		return true;
	}

	public static Bitmap drawableToBitmap(Drawable drawable) {
		Bitmap bitmap = null;
	    try {
			if (drawable instanceof BitmapDrawable) {
				return ((BitmapDrawable)drawable).getBitmap();
			}

			int width = drawable.getIntrinsicWidth();
			width = width > 0 ? width : 1;
			int height = drawable.getIntrinsicHeight();
			height = height > 0 ? height : 1;

			bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
			Canvas canvas = new Canvas(bitmap);
			drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
			drawable.draw(canvas);
		}catch (Exception e){
			e.printStackTrace();
			bitmap = Bitmap.createBitmap(100, 100, Bitmap.Config.ARGB_8888);
			bitmap.eraseColor(Color.WHITE);
		}

	    return bitmap;
	}
	public static boolean isOnline(Context context) {
	    ConnectivityManager cm = (ConnectivityManager) context
	            .getSystemService(Context.CONNECTIVITY_SERVICE);
	    NetworkInfo netInfo = cm.getActiveNetworkInfo();
	    return netInfo != null && netInfo.isConnectedOrConnecting();
	}

	private boolean isShowUpgrade;
	public boolean getShowUpgrade(){
		return isShowUpgrade;
	}
	public void setShowUpgrade(boolean isShowUpgrade){
		this.isShowUpgrade = isShowUpgrade;
	}
}
