package com.mobgame.utils;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.util.Log;

import com.appsflyer.AFInAppEventType;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerLib;
import com.mobgame.MobGameSDK;
import com.mobgame.component.EventClientManager;
import com.mobgame.component.FirebaseAnalyticsManager;
import com.mobgame.component.GameConfigManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;


/**
 * Created by Pc 02 on 2/24/2018.
 */

public class FunTrackingUtil {
    private static FunTrackingUtil instance;
    private String appsflyerDevkey = "cfgYFoj97okaEbzqp8q5w5";
    private String gcmSenderId = "461098885975";
    private String TAG = "FunTrackingUtil";
    private Map<String, Object> conversionDataLoaded;
    private ArrayList<String> listTrackEventQueue = new ArrayList<>();
    private boolean initted;
    /*Tracking Appsflyer key*/
    public static final String STR_EVENT_LAUNCHER = "ft_app_launch";

    private static final String TRACK_FIRST_LAUNCH = "ft_first_launch";
    private static final String TRACK_FIRST_LAUNCH_XX = "ft_app_launch_";
    private static final String TRACK_DOWNLOAD_RES_STARTED = "ft_resource_started";
    private static final String TRACK_DOWNLOAD_RES_FAILED = "ft_resource_failed";
    private static final String TRACK_DOWNLOAD_RES_FINISHED = "ft_resource_finished";
    private static final String TRACK_CHARACTOR_CREATED = "ft_character_created";
    private static final String TRACK_START_TUTORIAL = "af_tutorial_started";
    private static final String TRACK_FINISH_TUTORIAL = "af_tutorial_completed";
    private static final String TRACK_REACH_A_LEVEL = "af_level_achieved";
    private static final String TRACK_LEVEL_PLATFORM = "ft_level_platform";
    private static final String TRACK_LEVEL_ACHIEVED_A = "ft_level_achieved_A";
    private static final String TRACK_LEVEL_ACHIEVED_B = "ft_level_achieved_B";
    private static final String TRACK_LEVEL_ACHIEVED_C = "ft_level_achieved_C";
    private static final String TRACK_REGISTER_SUCCESS = "ft_register_success";
    public static final String TRACK_LOGIN_SUCCESS = "ft_login_success";
    public static final String TRACK_LOGIN_SUCCESS_AFTER_AUTH = "ft_login_success_after_auth";

    public static final String TRACK_PAYMENT_OPEN = "ft_payment_opened";
    public static final String TRACK_PAYMENT_CLOSE = "ft_payment_closed";
    public static final String TRACK_FT_PAYMENT_SUCCESS = "ft_purchase";


    public static final String TRACK_FORM_LOGIN_OPENED = "ft_form_login_opened";
    public static final String TRACK_LOGIN_CLICKED = "ft_login_clicked";
    public static final String TRACK_LOGIN_CLOSED = "ft_login_closed";
    public static final String TRACK_EVENT_LOGOUT = "ft_logout";

    public static final String TRACK_FT_SESSION = "ft_session";
    public static final String TRACK_FT_LOADTIME = "ft_loadtime";
    public static final String SESSION_VALUE = "session_value";

    private FunTrackingUtil() {
    }

    public synchronized static FunTrackingUtil getInstance() {
        if (instance == null) {
            instance = new FunTrackingUtil();
        }
        return instance;
    }

    public void init(final Application context) {
        try {
            Log.i(TAG, "initAppsFlyer");
            AppsFlyerLib.getInstance().enableUninstallTracking(gcmSenderId);
            MobGameSDK.applicationContext = context;
            AppsFlyerLib.getInstance().setCollectIMEI(false);
            AppsFlyerLib.getInstance().setCollectAndroidID(false);
            AppsFlyerLib.getInstance().setDebugLog(true);
            AppsFlyerConversionListener conversionDataListener =
                    new AppsFlyerConversionListener() {

                        @Override
                        public void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                            try {
                                Map<String, Object> map = new HashMap<String, Object>(conversionData);
                                conversionDataLoaded = map;
                                if (!initted) {
                                    trackEvent(context, STR_EVENT_LAUNCHER, map);
                                    FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, STR_EVENT_LAUNCHER, null);
                                    int countLauncher = Preference.getInt(context, Constants.COUNT_LAUNCHER, 0);
                                    if (countLauncher < 30) {
                                        countLauncher++;
                                        Preference.save(context, Constants.COUNT_LAUNCHER, countLauncher);
                                        trackLoyalUser(context, TRACK_FIRST_LAUNCH_XX + "" + countLauncher);
                                    }
                                    initted = true;
                                }
                                //send tracking app_launcher and first_launch
                                for (String attrName : conversionData.keySet()) {
                                    Log.d(TAG, "onInstallConversionDataLoaded attribute: " + attrName + " = " + conversionData.get(attrName));
                                    if (attrName.equals("is_first_launch") && conversionData.get(attrName).equals("true")) {
                                        trackEvent(context, TRACK_FIRST_LAUNCH, map);

                                        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context, TRACK_FIRST_LAUNCH , null);
                                    }
                                }
                                //send tracking queue:
                                if (listTrackEventQueue != null) {
                                    map.put("Resend", "when inited");
                                    for (String eventName : listTrackEventQueue) {
                                        trackEvent(context, eventName, map);
                                    }
                                    listTrackEventQueue.clear();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onInstallConversionFailure(String errorMessage) {
                            initted = false;
                            Log.d(TAG, " onInstallConversionFailure error getting conversion data: " + errorMessage);
                        }

                        @Override
                        public void onAppOpenAttribution(Map<String, String> conversionData) {
                            for (String attrName : conversionData.keySet()) {
                                Log.d(TAG, "onAppOpenAttribution attribute: " + attrName + " = " + conversionData.get(attrName));
                            }
                        }

                        @Override
                        public void onAttributionFailure(String errorMessage) {
                            Log.d(TAG, " onAttributionFailure error onAttributionFailure : " + errorMessage);
                        }
                    };
            AppsFlyerLib.getInstance().init(appsflyerDevkey, conversionDataListener, context);
            AppsFlyerLib.getInstance().startTracking(context);
            new Thread(new Runnable() {
                @Override
                public void run() {
                    if (MobGameSDK.getInstance().isLoggedIn()) {
                        EventClientManager.getInstance(context).saveEventClient(EventClientManager.SAVE_EVENT_START_SESSION, STR_EVENT_LAUNCHER, null);
                    } else {
                        EventClientManager.getInstance(context).saveEventClient(EventClientManager.SAVE_EVENT_NORMAL, STR_EVENT_LAUNCHER, null);
                    }
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trackLoyalUser(Context context, String eventName) {
        try {
            Log.d(TAG , "event name : " + eventName);
            AppsFlyerLib.getInstance().trackEvent(context , eventName , null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , eventName , null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        try {
            if (initted) {
                HashMap<String, Object> map = new HashMap<>(conversionDataLoaded);
                if (eventValues != null)
                    map.putAll(eventValues);
                AppsFlyerLib.getInstance().trackEvent(context, eventName, map);
                Log.d(TAG, "trackEvent: " + eventName + " eventValue: " + map);
                if (Preference.getBoolean(context, eventName, true)) {
                    AppsFlyerLib.getInstance().trackEvent(context, eventName + "_first", map);
                    Preference.save(context, eventName, false);
                }
            } else {
                Log.d(TAG, "trackEvent " + eventName + " fail cause of AppsflyerLib is not inited successful");
                listTrackEventQueue.add(eventName);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackOpenFormLogin(Activity activity){
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_FORM_LOGIN_OPENED , null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackOpenDashboard(Context context){
        try {
            AppsFlyerLib.getInstance().trackEvent(context ,
                    Constants.STR_EVENT_OPEN_DASHBOARD, null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }
    public void trackOpenFormPayment(Activity activity){
        try {
            AppsFlyerLib.getInstance().trackEvent(activity , FunTrackingUtil.TRACK_PAYMENT_OPEN , null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_PAYMENT_OPEN , null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackLoginSuccess(Activity activity){
        try {
            AppsFlyerLib.getInstance().trackEvent(
                    activity,
                    AFInAppEventType.LOGIN, null);

            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS_AFTER_AUTH , null);

        }catch (Exception e){
            e.printStackTrace();
        }
    }


    public void trackRegisterSuccess(Activity activity , String typeRegister){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            hashMap.put("VALUE" , typeRegister);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_REGISTER_SUCCESS , hashMap);
            AppsFlyerLib.getInstance().trackEvent(activity , FunTrackingUtil.TRACK_REGISTER_SUCCESS , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackLoginSuccessFromWeb(Activity activity , String typeLogin){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            hashMap.put("VALUE" , typeLogin);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS , hashMap);
            AppsFlyerLib.getInstance().trackEvent(activity , FunTrackingUtil.TRACK_LOGIN_SUCCESS , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackLoginClick(Activity activity ,String label , HashMap<String , Object> typeLoginClick){
        try {
            AppsFlyerLib.getInstance().trackEvent(activity , label , null);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , label , typeLoginClick);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackPayment_RegisterClick(Activity activity , String label , String value){
        try {
            HashMap<String , Object> map = new HashMap<>();
            map.put("VALUE" , value);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , label , map);
            AppsFlyerLib.getInstance().trackEvent(activity , label , map);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackPaymentSuccess(Activity activity , HashMap<String , Object> eventValue){
        try {
            AppsFlyerLib.getInstance().trackEvent(
                    activity,
                    AFInAppEventType.PURCHASE, eventValue);

            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_FT_PAYMENT_SUCCESS , eventValue);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackSession(Activity activity , long deltaSession){
        try {
            HashMap<String , Object> hashMap = new HashMap<>();
            hashMap.put(SESSION_VALUE , String.valueOf(deltaSession));

            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_FT_SESSION , hashMap);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackingLogout(Activity activity){
        try{
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , FunTrackingUtil.TRACK_EVENT_LOGOUT , null);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceStarted(Activity activity) {
        try {
            //bắt đầu download resource. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
            String gameVersionName = Utils.getGameVersion(activity);
            String gameVersionCode = Utils.getGameVersionCode(activity);
            String versionsave = Preference.getString(activity, "GAME_VERSION");
            if (!versionsave.equals(gameVersionCode)) {
                HashMap<String, Object> map = new HashMap<>();
                map.put("version name", gameVersionName);
                map.put("version code", gameVersionCode);
                trackEvent(activity, TRACK_DOWNLOAD_RES_STARTED, map);

                FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_DOWNLOAD_RES_STARTED , map);
            } else Log.d(TAG, "trackDownloadResourceStarted dont call because it is same version");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackDownloadResourceFinished(Activity activity) {
        //kết thúc download resource. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
        String gameVersionName = Utils.getGameVersion(activity);
        String gameVersionCode = Utils.getGameVersionCode(activity);
        String versionsave = Preference.getString(activity, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            trackEvent(activity, TRACK_DOWNLOAD_RES_FINISHED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_DOWNLOAD_RES_FINISHED , map);

        } else Log.d(TAG, "trackDownloadResourceFinished dont call because it is same version");
        Preference.save(activity, "GAME_VERSION", gameVersionCode);
    }

    public void trackDownloadResourceFailed(Context context) {
        //download resource thất bại. Chỉ gọi 1 lần cho 1 app version ( = gọi mỗi lần update game)
        String gameVersionName = Utils.getGameVersion(context);
        String gameVersionCode = Utils.getGameVersionCode(context);
        String versionsave = Preference.getString(context, "GAME_VERSION");
        if (!versionsave.equals(gameVersionCode)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("version name", gameVersionName);
            map.put("version code", gameVersionCode);
            trackEvent(context, TRACK_DOWNLOAD_RES_FAILED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context , TRACK_DOWNLOAD_RES_FAILED , map);
        } else Log.d(TAG, "trackDownloadResourceFailed dont call because it is same version");
    }

    public void trackStartTutorial(Activity activity) {
        trackEvent(activity, TRACK_START_TUTORIAL, null);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_START_TUTORIAL , null);
    }

    public void trackFinishTutorial(Activity activity) {
        trackEvent(activity, TRACK_FINISH_TUTORIAL, null);
        FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_FINISH_TUTORIAL , null);
    }

    public void trackCreateCharactor(Activity activity, String roleID, String areaID) {
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            trackEvent(activity, TRACK_CHARACTOR_CREATED, map);
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_CHARACTOR_CREATED , map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackReachALevel(Activity activity, String roleID, String areaID, String level) {
        Log.d(TAG, "trackReachALevel: ");
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("roleID", roleID);
            map.put("serverID", areaID);
            map.put("level", level);
            trackEvent(activity, TRACK_REACH_A_LEVEL, map);

            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_REACH_A_LEVEL , map);
        } catch (Exception e) {
            e.printStackTrace();
        }

        //tracking platform
        String levelTracking = null;
        try {
            if (GameConfigManager.getInstance() != null
                    && GameConfigManager.getInstance().getGameConfig() != null
                    && GameConfigManager.getInstance().getGameConfig().getLevel() != null)
                levelTracking = GameConfigManager.getInstance().getGameConfig().getLevel();
            Log.d(TAG, "trackLevelPlatform: " + levelTracking);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (levelTracking != null) {
            String[] arrLevel = levelTracking.split(",");
            for (int i = 0 ; i < arrLevel.length ; i ++) {
                try {
                    String anLevel = arrLevel[i];
                    if (!Preference.getBoolean(activity, TRACK_LEVEL_PLATFORM + anLevel, false)
                            && Integer.parseInt(level) >= Integer.parseInt(anLevel)) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("LEVEL", anLevel + "");
                        trackEvent(activity, TRACK_LEVEL_PLATFORM, map);

                       if(Integer.parseInt(level) >= Integer.parseInt(arrLevel[2])){
                           FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_LEVEL_ACHIEVED_C , map);
                       }else if(Integer.parseInt(level) >= Integer.parseInt(arrLevel[1])){
                           FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_LEVEL_ACHIEVED_B , map);
                       }else if(Integer.parseInt(level) >= Integer.parseInt(arrLevel[0])){
                           FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_LEVEL_ACHIEVED_A , map);
                       }else{
                           Log.d(TAG , "Do something");
                       }
                        map.clear();
                        Preference.save(activity, TRACK_LEVEL_PLATFORM + anLevel, true);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }


    }

    public String getAppsflyerDevkey() {
        return appsflyerDevkey;
    }

    public void setAppsflyerDevkey(String appsflyerDevkey) {
        this.appsflyerDevkey = appsflyerDevkey;
    }

    public String getGcmSenderId() {
        return gcmSenderId;
    }

    public void setGcmSenderId(String gcmSenderId) {
        this.gcmSenderId = gcmSenderId;
    }

    public String getAppsflyerId(Context context){
        return AppsFlyerLib.getInstance().getAppsFlyerUID(context);
    }

    public void startSession(Application application) {
        long startSession = System.currentTimeMillis();
        Preference.save(application, Constants.START_SESSION , startSession);
    }

    public void trackLoadTime(Activity activity, long deltaTime) {
        try {
            HashMap<String , Object> map = new HashMap<>();
            map.put("TIME_VALUE" , String.valueOf(deltaTime));

            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(activity , TRACK_FT_LOADTIME , map);
            Preference.remove(activity , Constants.START_SESSION);
        }catch (Exception e ){
            e.printStackTrace();
        }
    }

    public void trackPaymentClose(Context context, String label) {
        try {
            FirebaseAnalyticsManager.getInstance().firebaseEventTrack(context ,label , null );
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}
