package com.mobgame.gui.floatbutton;

import android.animation.Animator;
import android.animation.Animator.AnimatorListener;
import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.os.Build;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver.OnGlobalLayoutListener;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.OvershootInterpolator;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;
import android.widget.TextView;

import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAnalyticsManager;
import com.mobgame.gui.CountdownChronometer;
import com.mobgame.gui.CountdownChronometer.CountdownListener;
import com.mobgame.gui.floatbutton.MobGameFloatMenuView.OnClickOutsideListener;
import com.mobgame.model.MobMenuItem;
import com.mobgame.model.TimerData;
import com.mobgame.model.TimerObject;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.FloatButtonTimerHelper;
import com.mobgame.utils.NotificationUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;

import java.util.ArrayList;
import java.util.Calendar;

@SuppressLint({ "InflateParams", "ClickableViewAccessibility" })
public class MobGameOverlayView {
	//	private static String TAG = MobFloatOverlayView.class.getSimpleName();
	private static final int ANIMAION_TIME_ROTATE = 800;
	private static final int ANIMAION_TIME_FADE_OUT = 400;
	private static final int ANIMAION_TIME_FADE_IN = 400;
	private static final int IDLE_TIME = 6000;
	private static final int IDLE_TIME2 = 2000;
	private static final String TAG = MobGameOverlayView.class.getSimpleName();

	private static Activity activity;
	private View rootView, layoutBottom, layoutFloat;/*, layoutMenu*/
	private TextView txtDismiss;
	//	FloatMenu smartMenu;
	private Handler idleHandler = new Handler();
	private MobGameFloatGestureView floatArea;
	private ImageView floatButton;
	private static ImageView floatButtonNtf;
	private MobGameFloatMenuView floatMenu;
	private CountdownChronometer countdownTimer;
	private View animationLayout;
	private View timerLayout;
//	View floatMenu, floatMenuBackground;
//	ArrayList<MobFloatMenuModel> floatMenuitems = new ArrayList<MobFloatMenuModel>();

	private boolean isInit;
	private static boolean isShowingMenu;
	private static boolean startShowMenu;
	private boolean isOutsideBottomArea;
	// Screen
	private int boundWidth, boundHeight;
	private int relativePositionOnScreen;
	private int statusBarHeight;
	//	private int screenWidth, screenHeight;
	private float density;

	private boolean isShowDialogAgain;
	private boolean fadeOuted;

	public MobGameOverlayView(Activity a) {
		activity = a;
		enableTimer();
		floatMenu = new MobGameFloatMenuView(activity);
		floatMenu.setClickOutsideListenter(new OnClickOutsideListener() {

			@Override
			public void onClickOutSide() {
				Log.d(TAG, "Float menu click outside");
				showCountdownTimer(View.VISIBLE);
			}
		});

		floatArea = new MobGameFloatGestureView(activity);

		density = DeviceUtils.getDensity(a);
//		screenWidth = DeviceUtils.getScreenWidthInPixels(a);
//		screenHeight = DeviceUtils.getScreenHeightInPixels(a);
		statusBarHeight = DeviceUtils.getStatusBarHeightInPixels(activity);

		attachView();
		initView();
		hide();
	}

	public void enableTimer(){
		TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(activity);
		if(timerData != null){
			long now = Calendar.getInstance().getTimeInMillis();
			ArrayList<TimerObject> listTimerObj = new ArrayList<>();
			listTimerObj = timerData.getListTimerObject();

			for (int i = 0; i < listTimerObj.size(); i++) {
				TimerObject timerObject = new TimerObject();
				timerObject = listTimerObj.get(i);
				if(timerObject.getStartTime() <= now && timerObject.getEndTime() > now){
					FloatButtonTimerHelper.setisRuningTimer(true);
					break;
				}else{
					FloatButtonTimerHelper.setisRuningTimer(false);
				}

			}
		}else{
			FloatButtonTimerHelper.setisRuningTimer(false);
		}

	}
	public void attachView() {
		try {
			rootView = LayoutInflater.from(activity).inflate(R.layout.float_overlay_view, null);
			WindowManager windowManager = (WindowManager) activity.getApplicationContext()
					.getSystemService(Activity.WINDOW_SERVICE);
			if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
				WindowManager.LayoutParams params = new WindowManager.LayoutParams(
						WindowManager.LayoutParams.MATCH_PARENT,
						WindowManager.LayoutParams.MATCH_PARENT,
						WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY,
						WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
						PixelFormat.TRANSPARENT);
				params.gravity = Gravity.LEFT | Gravity.TOP;
				params.flags = WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
						| WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL
						| WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE;
				windowManager.addView(rootView, params);
			} else {
				WindowManager.LayoutParams params = new WindowManager.LayoutParams(
						WindowManager.LayoutParams.MATCH_PARENT,
						WindowManager.LayoutParams.MATCH_PARENT,
						WindowManager.LayoutParams.TYPE_PHONE,
						WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
						PixelFormat.TRANSPARENT);
				params.gravity = Gravity.LEFT | Gravity.TOP;
				params.flags = WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
						| WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL
						| WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE;
				windowManager.addView(rootView, params);
			}

			rootView.getViewTreeObserver().addOnGlobalLayoutListener(new OnGlobalLayoutListener() {

				@SuppressLint("NewApi")
				public void onGlobalLayout() {

					if (rootView != null) {
						boundWidth = rootView.getWidth();
						boundHeight = rootView.getHeight();
						floatArea.setMovableWidth(boundWidth);
						floatArea.setMovableHeight(boundHeight);

						int[] locations = new int[2];
						rootView.getLocationOnScreen(locations);
						relativePositionOnScreen = locations[1];

						if (!isInit) {
							isInit = true;
							floatArea.moveTo(0, boundHeight / 2);
						}
						if (Build.VERSION.SDK_INT < 16) {
							rootView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
						} else {
							rootView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
						}
					}
				}
			});
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void initView() {
		try {
			layoutBottom = rootView.findViewById(R.id.layout_bottom);
			layoutFloat = rootView.findViewById(R.id.layout_float);
//		layoutMenu = rootView.findViewById(R.id.layout_menu);
			txtDismiss = (TextView) rootView.findViewById(R.id.txt_dismiss);
			floatButton = (ImageView) rootView.findViewById(R.id.img_float);
			floatButtonNtf = (ImageView) rootView.findViewById(R.id.img_float_ntf);
			animationLayout = rootView.findViewById(R.id.animation_layout);
			timerLayout = rootView.findViewById(R.id.timer_layouts);

//		floatMenu = rootView.findViewById(R.id.float_menu);
//		floatMenuBackground = rootView.findViewById(R.id.img_menu_background);

			int imgRes = Res.drawableResource(activity, R.drawable.float_button);
			floatButton.setImageResource(imgRes);

			floatMenu.setEventListener(mMenuEventListener);
			floatArea.setEventListener(mButtonEventListener);
			floatArea.moveTo(0, boundHeight / 2);

			txtDismiss.setText(Res.string(activity, R.string.dismiss));

			layoutBottom.setY(boundHeight + statusBarHeight - relativePositionOnScreen - 125 * density);
			countdownTimer = (CountdownChronometer) rootView.findViewById(R.id.countdown_timer);
			if(FloatButtonTimerHelper.isRuningTimer() == false){
				timerLayout.setVisibility(View.GONE);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void fadeOut(boolean isAnimated) {
//		isAnimated = false;
		try {
			final int newX = updateFloatButtonNotf();
			Log.d(TAG, "boundWidth: " + boundWidth + " - new X: " + newX);
			if (isAnimated) {
				Log.d(TAG, "GO HERE 1 ");
				animationLayout.clearAnimation();
				animationLayout.animate()
						.setDuration(ANIMAION_TIME_FADE_OUT)
						.setInterpolator(new OvershootInterpolator(1f))
//				.alpha(0.5f)
						.x(newX).setListener(new AnimatorListener() {

					@Override
					public void onAnimationStart(Animator arg0) {

					}

					@Override
					public void onAnimationRepeat(Animator arg0) {

					}

					@Override
					public void onAnimationEnd(Animator arg0) {
						Log.d(TAG, "AnimationLayout X: " + animationLayout.getX());
						Log.d(TAG, String.format("float layout: %sx%s - animate: %sx%s", layoutFloat.getX(), layoutFloat.getY()
								, animationLayout.getX(), animationLayout.getY()));
						layoutFloat.clearAnimation();
						animationLayout.clearAnimation();
						layoutFloat.refreshDrawableState();

					}

					@Override
					public void onAnimationCancel(Animator arg0) {

					}
				});
			} else {
				Log.d(TAG, "GO HERE 2 ");
//			layoutFloat.setAlpha(0.5f);
				animationLayout.setX(newX);
			}
			fadeOuted = true;
			idleHandler.postDelayed(mIdleRunnable2, IDLE_TIME2);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private int updateFloatButtonNotf(){
		int newX = 0;
		try {
			int buttonSize = floatArea.getSizeInPixels();
			newX = boundWidth - buttonSize / 2;

			float currentX = layoutFloat.getX();

			if (currentX <= boundWidth / 2) {
				RelativeLayout.LayoutParams lp = (LayoutParams) floatButtonNtf.getLayoutParams();
				lp.addRule(RelativeLayout.ALIGN_PARENT_LEFT, 0);
				lp.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
				floatButtonNtf.setLayoutParams(lp);
				newX = -buttonSize / 2;
			} else {
				RelativeLayout.LayoutParams lp = (LayoutParams) floatButtonNtf.getLayoutParams();
				lp.addRule(RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);
				lp.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, 0);
				floatButtonNtf.setLayoutParams(lp);
				newX = 0 + buttonSize/2;
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return newX;
	}

	public void fadeOut2(boolean isAnimated) {
		try {
			if (isAnimated) {
				animationLayout.animate()
						.setDuration(ANIMAION_TIME_FADE_OUT)
						.setInterpolator(new OvershootInterpolator(1f))
						.alpha(0.5f);
			} else {
				animationLayout.setAlpha(0.5f);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void fadeIn(boolean isAnimated) {
		try {
			idleHandler.removeCallbacksAndMessages(null);

			if (isAnimated) {
				animationLayout.animate()
						.setDuration(ANIMAION_TIME_FADE_IN)
						.setInterpolator(new OvershootInterpolator(1f))
						.alpha(1f);
			} else {
				animationLayout.setAlpha(1f);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private Runnable mIdleRunnable = new Runnable() {

		@Override
		public void run() {
			try {
				if (!isShowingMenu) {
					fadeOut(true);
				} else {
					hideMenu();
					idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);
				}
				showCountdownTimer(View.VISIBLE);
			}catch (Exception e){
				e.printStackTrace();
			}
		}
	};

	private Runnable mIdleRunnable2 = new Runnable() {

		@Override
		public void run() {
			fadeOut2(true);
		}
	};

	private MobGameFloatGestureView.EventListener mButtonEventListener = new MobGameFloatGestureView.EventListener() {

		@Override
		public void onTouchDown(MotionEvent event) {
			isOutsideBottomArea = true;
			updateFloatButtonNotf();
			fadeIn(false);
		}

		@Override
		public void onTouchMove(MotionEvent event) {
			try {
				if (isInBottomArea(event.getRawX(), event.getRawY())) {
					if (isOutsideBottomArea) {
						showLayoutBottom();
					}
					isOutsideBottomArea = false;
				} else {
					if (!isOutsideBottomArea) {
						hideLayoutBottom();
					}
					isOutsideBottomArea = true;
				}
				if (isInDismissArea(event.getRawX(), event.getRawY())) {
					txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_active, 0, 0);
					txtDismiss.setTextColor(Color.rgb(194, 39, 45));
				} else {

					txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_normal, 0, 0);
					txtDismiss.setTextColor(Color.rgb(255, 255, 255));
				}
				hideMenu();
			}catch (Exception e){
				e.printStackTrace();
			}
		}

		@Override
		public void onTouchUp(MotionEvent event) {
			try {
//				updateFloatButtonNotf();
//				showCountdownTimer(View.VISIBLE);
				updateFloatButtonNotf();
				idleHandler.removeCallbacksAndMessages(null);
				idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);

				hideLayoutBottom();
				floatArea.moveToEdge(true);

				if (event != null) {
					if (isInDismissArea(event.getRawX(), event.getRawY())) {
						isShowDialogAgain = Preference.getBoolean(activity,
								Constants.SHARED_PREF_FLOAT_BUTTON_SHOW_DIALOG, true);
						if (isShowDialogAgain) {
							showConfirmDialog();
						}

						layoutFloat.setVisibility(View.GONE);
						floatArea.hide();
						Preference.save(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true);
						hideMenu();

//						Calendar c = Calendar.getInstance();
//						int dismissTime = c.get(Calendar.DAY_OF_YEAR);
						long dismissTime = Calendar.getInstance().getTimeInMillis();
						Preference.save(activity,
								Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME, dismissTime);
					}
				}
				startTimer();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		@Override
		public void onClick(MotionEvent event) {
			try {
				animationLayout.setX(0);
				if (isShowingMenu) {
					hideMenu();
				} else {
					showMenu();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

		}

		@Override
		public void onMove(int x, int y) {
			//y = y - floatArea.getSizeInPixels() / 2;
			try {
				x = Math.max(0, Math.min(boundWidth - floatArea.getSizeInPixels(), x));
				y = Math.max(0, Math.min(boundHeight - relativePositionOnScreen - floatArea.getSizeInPixels(), y));
				if(countdownTimer != null){
					if(countdownTimer.getVisibility()==View.VISIBLE){
						y = Math.max(0, Math.min(boundHeight - relativePositionOnScreen - floatArea.getSizeInPixels() - timerLayout.getMeasuredHeight(), y));
					}
				}


				layoutFloat.setX(x);
				layoutFloat.setY(y);

				if(animationLayout != null && fadeOuted){
					animationLayout.setX(0);
					fadeOuted = false;
				}
			}catch (Exception e){
				e.printStackTrace();
			}
//			Log.d(TAG, String.format("move: %sx%s - animate: %sx%s", x, y, animationLayout.getX(), animationLayout.getY()));
		}
	};

	@SuppressLint("NewApi")
	private void showCountdownTimer(int visibility){
		try{
			if(countdownTimer == null){
				return;
			}
			if(!countdownTimer.isRunning()){
				if(countdownTimer.getVisibility() == View.VISIBLE){
					countdownTimer.setVisibility(View.GONE);
					timerLayout.setVisibility(View.GONE);
				}
				return;
			}
			TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(activity);
			if(timerData!=null){
				if(timerData.getListTimerObject().isEmpty()){
					return;
				}
			}
			countdownTimer.setVisibility(visibility);
			timerLayout.setVisibility(visibility);
			if(rootView!=null){
				rootView.postInvalidateOnAnimation();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private MobGameFloatMenuView.EventListener mMenuEventListener = new MobGameFloatMenuView.EventListener() {

		@Override
		public void onShow() {
			try {
				idleHandler.removeCallbacksAndMessages(null);
				idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);

				floatButton.animate()
						.setDuration(ANIMAION_TIME_ROTATE)
						.setInterpolator(new OvershootInterpolator(1f))
						.rotation(90f)
						.setListener(new AnimatorListener() {

							@Override
							public void onAnimationStart(Animator anim) {}

							@Override
							public void onAnimationRepeat(Animator anim) {}

							@Override
							public void onAnimationEnd(Animator anim) {
								isShowingMenu = true;
							}

							@Override
							public void onAnimationCancel(Animator anim) {}
						});
			}catch (Exception e){
				e.printStackTrace();
			}
		}

		@Override
		public void onHide() {
			try {
				idleHandler.removeCallbacksAndMessages(null);
				idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);

				hideLayoutBottom();
				floatArea.moveToEdge(true);

				floatButton.animate()
						.setDuration(ANIMAION_TIME_ROTATE)
						.setInterpolator(new OvershootInterpolator(1f))
						.rotation(0f)
						.setListener(new AnimatorListener() {

							@Override
							public void onAnimationStart(Animator arg0) {}

							@Override
							public void onAnimationRepeat(Animator arg0) {}

							@Override
							public void onAnimationEnd(Animator arg0) {
								isShowingMenu = false;
							}

							@Override
							public void onAnimationCancel(Animator arg0) {}
						});
			}catch (Exception e){
				e.printStackTrace();
			}
		}

		@Override
		public void onClick(View v, MobMenuItem menuItem) {
			try {
				hideMenu();

				GoogleAnalyticsManager.getInstance().trackEvent(
						"Float icon",
						"button_press",
						menuItem.getLabel(),
						1);

				Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", menuItem.getCommand());
				intent.putExtra("data", menuItem.getParams());
				LocalBroadcastManager.getInstance(activity.getApplicationContext())
						.sendBroadcast(intent);
			}catch (Exception e){
				e.printStackTrace();
			}
		}

	};

	public void showMenu() {
		try {
			startShowMenu = true;
			int countdownTimerHeight = 0;
			if(countdownTimer!=null){
				if(countdownTimer.getVisibility()==View.VISIBLE){
					countdownTimerHeight = countdownTimer.getMeasuredHeight();
				}
			}
			showCountdownTimer(View.INVISIBLE);
			if(!FloatButtonTimerHelper.isRuningTimer()){
				floatButtonNtf.setVisibility(View.GONE);
			}
			fadeIn(true);
			int floatY = floatArea.getY() - relativePositionOnScreen;
			if(floatY < 0){
				floatY = 0;
			}
			if(floatY > 0){
				floatY += countdownTimerHeight;
			}
			int x = floatArea.getSizeInPixels();
			int y = Math.min(boundHeight - relativePositionOnScreen - floatArea.getSizeInPixels(), floatY);
			if (floatMenu == null) {
				floatMenu = new MobGameFloatMenuView(activity);
			}
			if (floatArea.getX() > boundWidth / 2) {
				floatMenu.showInReverse(x, y, true);
			} else {
				floatMenu.show(x, y, true);
			}

			if(!FloatButtonTimerHelper.isEnableFloatButtonTimer(activity)){
				return;
			}

			if(countdownTimer != null){
//			startTimer();
				floatMenu.updateCountdownTimer(countdownTimer.getRunningTime());
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void hideMenu() {
		try {
			startShowMenu = false;
			if (floatMenu != null) {
				floatMenu.hide();
			}
			showCountdownTimer(View.VISIBLE);
			if(!FloatButtonTimerHelper.isRuningTimer() && NotificationUtils.hasNtf(activity)){
				floatButtonNtf.setVisibility(View.VISIBLE);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	public static void setNtf(boolean isHide){
		try {
			if(!FloatButtonTimerHelper.isRuningTimer() && NotificationUtils.hasNtf(activity) && !isShowingMenu){
				floatButtonNtf.setVisibility(View.VISIBLE);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	public void updateMenu() {
		try {
			if (floatMenu != null) {
				floatMenu.updateMenu();
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private boolean isInBottomArea(float left, float top) {
		try {
			int dY = (int) (boundHeight - 150 * density);
			return top >= dY || isInDismissArea(left, top);
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

	private boolean isInDismissArea(float left, float top) {
		try {
			int dX = boundWidth / 2;
			int dY = (int) (boundHeight - 100 * density);
			double distance = Math.sqrt(Math.pow(left - dX, 2) + Math.pow(top - dY, 2));
			double maxDistance = Math.min(120 * density, boundWidth / 5);

			return distance <= maxDistance
					|| (top >= dY && left >= dX - maxDistance && left <= dX + maxDistance);
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

	private void showLayoutBottom() {
		try {
			layoutBottom.setVisibility(View.VISIBLE);
			layoutBottom.animate()
					.setDuration(200)
					.y(boundHeight + statusBarHeight - relativePositionOnScreen - 125 * density);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void hideLayoutBottom() {
		try {
			layoutBottom.animate()
					.setDuration(200)
					.y(boundHeight + statusBarHeight - relativePositionOnScreen);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	DialogFragment dialog = null;
	public void showConfirmDialog() {
		try {
			dialog = new MobGameFloatConfirmDialog(activity, new MobGameFloatConfirmDialog.EventListener() {

				@Override
				public void onConfirmClick(View v) {
					try {
						Preference.save(activity,
								Constants.SHARED_PREF_FLOAT_BUTTON_SHOW_DIALOG, isShowDialogAgain);
						Preference.save(activity,
								Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true);
						layoutFloat.setVisibility(View.GONE);
						floatArea.hide();
						hideMenu();
						hideConfirmDialog();
					}catch (Exception e){
						e.printStackTrace();
					}
				}

				@Override
				public void onCancelClick(View v) {
					try{
						Preference.save(activity,
								Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true);
						layoutFloat.setVisibility(View.GONE);
						floatArea.hide();
						hideMenu();
						hideConfirmDialog();
					}catch (Exception e){
						e.printStackTrace();
					}
				}

				@Override
				public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
					isShowDialogAgain = !isChecked;
				}
			});
			dialog.show(activity.getFragmentManager(), "tag_fragment_confirm");
		} catch (Exception e) {
			hideConfirmDialog();
		}
	}

	public void hideConfirmDialog() {
		try {
			if (dialog != null && dialog.isAdded()) {
				dialog.dismiss();
				dialog = null;
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void show(boolean isShowTimer, boolean isMoveToCenterVertical) {
		try {
			layoutFloat.setVisibility(View.VISIBLE);
			layoutBottom.setVisibility(View.GONE);
			floatArea.show();
			if(isMoveToCenterVertical){
				floatArea.moveTo(0, boundHeight / 2);
			}
			hideConfirmDialog();
			fadeIn(false);
			idleHandler.removeCallbacksAndMessages(null);
			idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);

			if (NotificationUtils.hasNtf(activity)) {
				if(isShowTimer || isShowingMenu){
					Log.d(TAG, "Vao day 1");
					floatButtonNtf.setVisibility(View.GONE);
					return;
				}else{
					Log.d(TAG, "Vao day 5");
					floatButtonNtf.setVisibility(View.VISIBLE);
					updateFloatButtonNotf();
					return;
				}
			}
			Log.d(TAG, "Vao day 4");
			floatButtonNtf.setVisibility(View.GONE);
			Preference.save(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false);
		}catch (Exception e){
			e.printStackTrace();
		}
	}


	public void hide() {
		try {
			hideMenu();
			layoutFloat.setVisibility(View.GONE);
			layoutBottom.setVisibility(View.GONE);
			floatArea.hide();
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void viberate() {
		try {
			if(!Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false)){
				Log.d(TAG, "AAA : " + FloatButtonTimerHelper.isRuningTimer());
				show(FloatButtonTimerHelper.isRuningTimer(),!isShowing());
				floatMenu.refreshFloatMenu();
			}
			Animation viberate = AnimationUtils.loadAnimation(activity, R.anim.viberate);
			floatButton.startAnimation(viberate);
			GameConfigManager.getInstance().setHasUnreadNotifications(false);
			animationLayout.setX(0);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public boolean isShowing() {
		try {
			return layoutFloat.getVisibility() == View.VISIBLE;
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

	public boolean isShowingConfirmDialog() {
		try {
			return dialog != null && dialog.isVisible();
		}catch (Exception e){
			e.printStackTrace();
			return false;
		}
	}

	public void dismiss() {
		try {
			rootView.setVisibility(View.GONE);
			WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
					Activity.WINDOW_SERVICE);
			windowManager.removeView(rootView);
			if (floatMenu != null) {
				floatMenu.dismiss();
			}
			if (floatArea != null) {
				floatArea.dismiss();
			}
			rootView = null;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public int getFloatButtonX() {
		try {
			return floatArea.getX();
		}catch (Exception e){
			e.printStackTrace();
			return 0;
		}
	}

	public int getFloatButtonY() {
		try {
			return floatArea.getY();
		}catch (Exception e){
			e.printStackTrace();
			return 0;
		}
	}
	long startTime , endTime;
	int id;
	ArrayList<TimerObject> listTimers = new ArrayList<>();
	public void startTimer() {
		Log.d(TAG, "startTimer");
		try {
			final long now = Calendar.getInstance().getTimeInMillis();
			final TimerData timerData = FloatButtonTimerHelper.getFloatButtonTimerData(activity);
			if(timerData != null){
				listTimers = timerData.getListTimerObject();

				Log.i(TAG, "Now: ");
				if(listTimers.isEmpty()){
					Log.d(TAG, "Queue timer is empty!");
					return;
				}

				if(countdownTimer != null){
					countdownTimer.setVisibility(countdownTimer.isRunning() ? View.VISIBLE : View.GONE);
				}
				startTime = listTimers.get(0).getStartTime();
				endTime = listTimers.get(0).getEndTime();
				id = listTimers.get(0).getId();
				Log.i(TAG, "start: " + startTime + " , end :" + endTime + " , " + now);

				//su kien chua toi thoi gian
				for (int i = 0; i < listTimers.size(); i++) {
					if(listTimers.get(i).getStartTime() < now){
						startTime = listTimers.get(i).getStartTime();
						endTime = listTimers.get(i).getEndTime();
						id = listTimers.get(i).getId();
						break;
					}
				}

				//su kien da qua - thi clear su kien do di
				if(endTime < now){
					Log.d(TAG,  "End time < Now, restart timer :endTime " + endTime + " , now:" + now );
					try {
						TimerObject timerObject = new TimerObject(id , startTime , endTime);
						timerData.removeData(activity , timerObject , listTimers);
						if(listTimers.isEmpty()){
							return;
						}
						startTimer();
					} catch (Exception e) {
						e.printStackTrace();
					}
					return;
				}

				//Check hien thi timer
				Log.i(TAG, "Countdown time: " + startTime + " ," + endTime);
				if(startTime <= now && endTime > now){
					floatButtonNtf.setVisibility(View.INVISIBLE);
					final long countDownTime = endTime - now;
					//Thoi code
					FloatButtonTimerHelper.setisRuningTimer(true);
					Log.i(TAG, "Countdown time: " + countDownTime / 1000 + "s");

					int countTime2 = (int) (countDownTime)/1000;
					ValueAnimator anim2 = new ValueAnimator();

					anim2.setIntValues(Color.parseColor("#ee4242"), Color.parseColor("#ad2020"));
					anim2.setEvaluator(new ArgbEvaluator());
					anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
						@Override
						public void onAnimationUpdate(ValueAnimator valueAnimator) {
							countdownTimer.setBackgroundColor((Integer)valueAnimator.getAnimatedValue());
						}
					});
					anim2.setRepeatCount(countTime2);
					anim2.setDuration(2000);
					anim2.start();

					countdownTimer.setVisibility(View.VISIBLE);
					if(!isShowingMenu){
						timerLayout.setVisibility(View.VISIBLE);
					}
					countdownTimer.setBase(Calendar.getInstance().getTime().getTime() + countDownTime);
					countdownTimer.setCountdownListener(new CountdownListener() {

						@Override
						public void done() {
							Log.d(TAG, "Countdown done!");

							try {
//								Log.d(TAG,  "Start time: " + startTime + " - Now: " + now);
//								TimerObject timer = new TimerObject(id, startTime, endTime);
//								timerData.removeData(activity,timer , listTimers);

								if(countdownTimer != null){
									countdownTimer.setVisibility(View.GONE);
									timerLayout.setVisibility(View.GONE);
									FloatButtonTimerHelper.setcanRunTimer(false);
									FloatButtonTimerHelper.setisRuningTimer(false);
									floatMenu.refreshFloatMenu();
									countdownTimer.clearAnimation();
									countdownTimer.clearComposingText();
									countdownTimer.clearFocus();
								}
								if(NotificationUtils.hasNtf(activity)){
									floatButtonNtf.setVisibility(View.VISIBLE);
								}

							    new Handler().postDelayed(new Runnable() {
									@Override
									public void run() {
										startTimer();
									}
								},1500);
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					});
					countdownTimer.start();
					Log.d(TAG,  "Start countdown");
					return;
				}

				Log.d(TAG, "Events have not started yet!");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	public static boolean isStartShowMenu() {
		return startShowMenu;
	}
}
