package com.mobgame.gui.floatbutton;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.PixelFormat;
import android.view.GestureDetector;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.OvershootInterpolator;
import android.view.animation.Transformation;

import com.mobgame.R;
import com.mobgame.utils.DeviceUtils;

@SuppressLint({ "InflateParams", "ClickableViewAccessibility" })
public class MobGameFloatGestureView {

//	private static String TAG = MobFloatGestureView.class.getSimpleName();

	static final int ANIMAION_TIME_MOVE_TO_EDGE = 200;
	static final int BUTTON_SIZE = 44;

	Activity activity;
	View rootView, floatArea;
	EventListener listener;
	GestureDetector gestureDetector;

	int buttonSize;
	// Screen
	int movableWidth, movableHeight;
	float density;
	// Touch event
	long timeTouchDown, timeTouchUp;
	float deltaX, deltaY;
	
	WindowManager windowManager;
	WindowManager.LayoutParams params;

	public MobGameFloatGestureView(Activity a) {
		activity = a;
		
		density = DeviceUtils.getDensity(a);
		movableWidth = DeviceUtils.getScreenWidthInPixels(a);
		movableHeight = DeviceUtils.getScreenHeightInPixels(a);
		buttonSize = (int) (BUTTON_SIZE * density);

		gestureDetector = new GestureDetector(a, new GestureListener());

		initView();
		attachView();
	}

	public void initView()
	{
		rootView = LayoutInflater.from(activity).inflate(R.layout.float_area, null);
		floatArea = rootView.findViewById(R.id.layout_float);

		floatArea.getLayoutParams().width = buttonSize;
		floatArea.getLayoutParams().height = buttonSize;
		floatArea.setOnTouchListener(mOnTouchListener);
	}

	public void attachView()
	{
		try {
			windowManager = (WindowManager) activity.getApplicationContext()
					.getSystemService(Activity.WINDOW_SERVICE);
			if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
				params = new WindowManager.LayoutParams(
						WindowManager.LayoutParams.WRAP_CONTENT,
						WindowManager.LayoutParams.WRAP_CONTENT,
						WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY,
						WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
						PixelFormat.TRANSPARENT);
			} else {
				params = new WindowManager.LayoutParams(
						WindowManager.LayoutParams.WRAP_CONTENT,
						WindowManager.LayoutParams.WRAP_CONTENT,
						WindowManager.LayoutParams.TYPE_PHONE,
						WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE,
						PixelFormat.TRANSPARENT);
			}
			params.gravity = Gravity.LEFT | Gravity.TOP;
			params.x = 0;
			params.y = 0;
			windowManager.addView(rootView, params);

			if (listener != null) {
				listener.onMove(params.x, params.y);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	public void setEventListener(EventListener listener) {
		this.listener = listener;
	}
	
	public void setMovableWidth(int width) {
		movableWidth = width;
	}
	
	public void setMovableHeight(int height) {
		movableHeight = height;
	}
	
	public int getSize() {
		return BUTTON_SIZE;
	}
	
	public int getSizeInPixels()
	{
		return buttonSize;
	}
	
	public int getX()
	{
		if (rootView == null) return 0;
		return params.x;
	}
	
	public int getY()
	{
		if (rootView == null) return 0;
		return params.y;
	}

	public void moveTo(int x, int y) {
		moveTo(x, y, false);
	}
	
	public void moveTo(int x, int y, boolean isAnimated) {
		try {
			params.x = x;
			params.y = y;
			windowManager.updateViewLayout(rootView, params);
			if (listener != null) {
				listener.onMove(params.x, params.y);
				listener.onTouchUp(null);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	public void moveToEdge(boolean isAnimated) {
		try {
			if (isAnimated) {
				Animation animation = new Animation() {

					@Override
					protected void applyTransformation(float interpolatedTime, Transformation t)
					{
						super.applyTransformation(interpolatedTime, t);
                        try{
							float left = params.x;
							float right = movableWidth - buttonSize - left;

							if (left <= right) {
								params.x = (int) (left - left * interpolatedTime);
							} else {
								params.x = (int) (left - (left - movableWidth) * interpolatedTime);
							}

							windowManager.updateViewLayout(rootView, params);
							if (listener != null) {
								listener.onMove(params.x, params.y);
							}
						}catch (Exception e){
							e.printStackTrace();
						}
					}
				};

				animation.setDuration(ANIMAION_TIME_MOVE_TO_EDGE);
				animation.setInterpolator(new OvershootInterpolator(0.5f));
				floatArea.startAnimation(animation);
			} else {

				float left = params.x;
				float right = movableWidth - buttonSize - left;
				if (left <= right) {
					params.x = 0;
				} else {
					params.x = movableWidth - buttonSize;
				}
				windowManager.updateViewLayout(rootView, params);
				if (listener != null) {
					listener.onMove(params.x, params.y);
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	private OnTouchListener mOnTouchListener = new OnTouchListener() {

		@Override
		public boolean onTouch(View v, MotionEvent event)
		{
			boolean comsumed = true;
			try {
				gestureDetector.onTouchEvent(event);
				switch (event.getAction() & MotionEvent.ACTION_MASK) {
					case MotionEvent.ACTION_DOWN: {
						timeTouchDown = System.currentTimeMillis();
						onTouchDown(event);
						break;
					}
					case MotionEvent.ACTION_UP: {
					/*double distance = Math.sqrt(Math.pow(deltaX - event.getX(), 2)
							+ Math.pow(deltaY - event.getY(), 2));
					if ((System.currentTimeMillis() - timeTouchDown < 250
					||	distance == 0)
					&& System.currentTimeMillis() - timeTouchUp > 1250) {
						timeTouchUp = System.currentTimeMillis();
						onClick(event);
						comsumed = false;
					}*/

						onTouchUp(event);
						break;
					}
					case MotionEvent.ACTION_POINTER_DOWN:
						break;
					case MotionEvent.ACTION_POINTER_UP:
						break;
					case MotionEvent.ACTION_MOVE: {
						onTouchMove(event);
						break;
					}
				}
			}catch (Exception e){
				e.printStackTrace();
			}
			return comsumed;
		}
	};
	
	private void onTouchDown(MotionEvent event) {
		try {
			deltaX = event.getX();
			deltaY = event.getY();

			if (listener != null) {
				listener.onTouchDown(event);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	private void onTouchMove(MotionEvent event) {
		try{
			float left = event.getRawX() - deltaX;
			float top = event.getRawY() - deltaY;
//		top = top - statusBarHeightf;

			left = Math.max(0, Math.min(movableWidth - buttonSize, left));
			top = Math.max(0, Math.min(movableHeight - buttonSize, top));

			params.x = (int) left;
			params.y = (int) top;
			rootView.setLayoutParams(params);

			windowManager.updateViewLayout(rootView, params);

			if (listener != null) {
				listener.onTouchMove(event);
				listener.onMove(params.x, params.y);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}
	
	private void onTouchUp(MotionEvent event) {
		if (listener != null) {
			listener.onTouchUp(event);
		}
	}
	
	public void show() {
		try {
			rootView.setVisibility(View.VISIBLE);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void hide() {
		try {
			if(rootView != null){
				rootView.setVisibility(View.GONE);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	public void dismiss() {
		try {
			rootView.setVisibility(View.GONE);
			windowManager.removeView(rootView);
			rootView = null;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	interface EventListener {
		public void onTouchUp(MotionEvent event);
		public void onTouchDown(MotionEvent event);
		public void onTouchMove(MotionEvent event);
		public void onClick(MotionEvent event);
		public void onMove(int x, int y);
	}
	
	GestureListener mGestureListener = new GestureListener();
	
	private class GestureListener extends GestureDetector.SimpleOnGestureListener {

		@Override
		public boolean onDown(MotionEvent e) {
			return true;
		}

		@Override
		public boolean onDoubleTapEvent(MotionEvent e) {
			return false;
		}

		@Override
		public boolean onSingleTapConfirmed(MotionEvent e) {
			if (listener != null) {
				listener.onClick(e);
			}
			return true;
		}

		@Override
		public void onLongPress(MotionEvent e) {
		}
	}

}
