/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.floatbutton;

import android.app.Activity;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.AnimationDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.mobgame.R;
import com.mobgame.gui.floatbutton.MobGameOverlayView;
import com.mobgame.utils.Res;

public class MobGameFloatConfirmDialog
extends DialogFragment {
    private static String TAG = MobGameOverlayView.class.getSimpleName();
    Activity activity;
    EventListener eventListener;

    public MobGameFloatConfirmDialog(Activity activity, EventListener eventListener) {
        this.activity = activity;
        this.eventListener = eventListener;
        this.setStyle(1, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.float_dialog, container, false);
        TextView txtTitle = (TextView)view.findViewById(R.id.txt_guide);
        ImageView imgGuide = (ImageView)view.findViewById(R.id.img_guide);
        Button btnConfirm = (Button)view.findViewById(R.id.btn_confirm);
        CheckBox cbxShowAgain = (CheckBox)view.findViewById(R.id.cbx_show_tips_again);
        imgGuide.setImageResource(Res.drawableResource((Context)this.activity, R.drawable.float_hide_tips_animation));
        AnimationDrawable frameAnimation = (AnimationDrawable)imgGuide.getDrawable();
        frameAnimation.start();
        txtTitle.setText((CharSequence)Res.string((Context)this.activity, R.string.dialog_tips_title));
        cbxShowAgain.setText((CharSequence)Res.string((Context)this.activity, R.string.dont_ask_again));
        btnConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MobGameFloatConfirmDialog.this.eventListener != null) {
                    MobGameFloatConfirmDialog.this.eventListener.onConfirmClick(v);
                }
            }
        });
        cbxShowAgain.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (MobGameFloatConfirmDialog.this.eventListener != null) {
                    MobGameFloatConfirmDialog.this.eventListener.onCheckedChanged(buttonView, isChecked);
                }
            }
        });
        return view;
    }

    public void onCancel(DialogInterface dialog) {
        if (this.eventListener != null) {
            this.eventListener.onCancelClick(null);
        }
    }

    public void show() {
        this.show(this.activity.getFragmentManager(), TAG);
    }

    public void onSaveInstanceState(Bundle outState) {
    }

    public static interface EventListener {
        public void onCancelClick(View var1);

        public void onConfirmClick(View var1);

        public void onCheckedChanged(CompoundButton var1, boolean var2);
    }
}

