package com.mobgame.component;

import android.app.Activity;
import android.util.Log;

import com.appsflyer.AppsFlyerLib;
import com.google.ads.conversiontracking.AdWordsAutomatedUsageReporter;
import com.mobgame.MobGameSDK;
import com.mobgame.ads.AdsManager;
import com.mobgame.model.CharacterInfo;
import com.mobgame.model.Game;
import com.mobgame.model.Game.AdsConfig;
import com.mobgame.model.Game.AdwordsConfig;
import com.mobgame.model.Game.AppsFlyerConfig;
import com.mobgame.model.MobMenu;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.Constants;
import com.mobgame.utils.Preference;

public final class GameConfigManager {
	
	private static final String TAG = GameConfigManager.class.getSimpleName();
	private static final String SHARED_PREF_MACCESS_TOKEN = "shared_pref_maccess_token";
	private static GameConfigManager INSTANCE;

	private String appkey;
	private Game gameConfig;
	private UserInfo userInfo;
	private CharacterInfo characterInfo;
	private MobMenu mobMenu;
//	private MobAccessToken accessToken;
	private String accessToken;
	private boolean hasUnreadNotifications;

	public static GameConfigManager getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new GameConfigManager();
		}
		return INSTANCE;
	}
	
	public String getAppKey() {
		return appkey;
	}

	public void setAppKey(String appkey) {
		this.appkey = appkey;
	}

	public Game getGameConfig() {
		return gameConfig;
	}

	public void setGameConfig(Game gameConfig) {
		this.gameConfig = gameConfig;
		
		initLang(gameConfig.getLang());
		initGoogleAuth();
		initFacebook(gameConfig.getFacebookId());
		initAppsFlyer(gameConfig.getAppsflyer());
		initGoogleAnalytics(new String[] {
			gameConfig.getGoogleAnalyticsId(),
			gameConfig.getGoogleAnalyticsIdTotal(),
			gameConfig.getGoogleAnalyticsIdLocal()
		});
		initAdwords(gameConfig.getAdwords());
		initAds(gameConfig.getAdsConfig());
	}

	public UserInfo getUserInfo() {
		return userInfo;
	}

	public void setUserInfo(UserInfo userInfo) {
		this.userInfo = userInfo;
	}
	
	public void clearUserInfo() {
		this.userInfo = null;
	}
	
	public CharacterInfo getCharacterInfo() {
		if (characterInfo == null) {
			characterInfo = new CharacterInfo();
		}
		return characterInfo;
	}

	public void setCharacterInfo(CharacterInfo characterInfo) {
		this.characterInfo = characterInfo;
	}
	
	public void clearCharacterInfo() {
		this.characterInfo = null;
	}
	
	public String getAccessToken() {
		if (accessToken == null) {
			Activity a = MobGameSDK.activity;
			accessToken = Preference.getString(a, SHARED_PREF_MACCESS_TOKEN);
			
		}
		return accessToken;
	}

	public void setAccessToken(String accessToken) {
		Activity a = MobGameSDK.activity;
		Preference.save(a, SHARED_PREF_MACCESS_TOKEN, accessToken);
		this.accessToken = accessToken;
	}
	
	public void clearAccessToken() {
		Activity a = MobGameSDK.activity;
		Preference.remove(a, SHARED_PREF_MACCESS_TOKEN);
		this.accessToken = null;
	}
	
	public MobMenu getMobMenu() {
		if (mobMenu == null) {
			mobMenu = new MobMenu();
		}
		return mobMenu;
	}

	public void setMobMenu(MobMenu mobMenu) {
		this.mobMenu = mobMenu;
	}
	
	public void clearMobMenu() {
		this.mobMenu = null;
	}
	
	public void clearLogin() {
		clearMobMenu();
		clearUserInfo();
		clearCharacterInfo();
		clearAccessToken();
	}	

	public boolean isHasUnreadNotifications() {
		return hasUnreadNotifications;
	}

	public void setHasUnreadNotifications(boolean hasUnreadNotifications) {
		this.hasUnreadNotifications = hasUnreadNotifications;
	}
	
	public void clearUnreadNotifications() {
		hasUnreadNotifications = false;
	}
	
	public String getFacebookId() {
		return gameConfig.getFacebookId();
	}
	
	private void initFacebook(String facebookAppId) {
		try {
			Log.i(TAG, "initFacebook");
			Activity a = MobGameSDK.activity;
			FacebookManager.getInstance().init(a.getApplicationContext(), facebookAppId);
		} catch (Exception e) {
		}
	}
	
	private void initGoogleAuth() {
		Activity a = MobGameSDK.activity;
		GoogleAuthManager.getInstance().init(a);
	}

	private void initAppsFlyer(AppsFlyerConfig config) {
		try {
			Log.i(TAG, "initAppsFlyer");
			Activity a = MobGameSDK.activity;
//			AppsFlyerLib.getInstance().setUseHTTPFalback(config.isUseHttp());
			AppsFlyerLib.getInstance().setCurrencyCode(config.getCurrency());
			AppsFlyerLib.getInstance().startTracking(a.getApplication(), config.getDevKey());
		} catch (Exception e) {
		}
	}

	private void initGoogleAnalytics(String id) {
		initGoogleAnalytics(new String[] {
			id
		});
	}
	
	private void initGoogleAnalytics(String[] ids) {
		try {
			Activity a = MobGameSDK.activity;
			GoogleAnalyticsManager.getInstance().init(a.getApplicationContext());
			for (String id : ids) {
				GoogleAnalyticsManager.getInstance().addTracker(id);	
			}
		} catch (Exception e) {
		}
	}

	private void initAdwords(AdwordsConfig config) {
		try {
			Activity a = MobGameSDK.activity;
			String conversionId = config.getConversionId();
			AdWordsAutomatedUsageReporter.enableAutomatedUsageReporting(a.getApplicationContext(), conversionId);
		} catch (Exception e) {
		}
	}
	
	private void initAds(AdsConfig config) {
		try {
			Activity a = MobGameSDK.activity;
			AdsManager.setApiKey(config.getApiKey());
			AdsManager.startTracking(a.getApplicationContext());
		} catch (Exception e) {
		}
	}
	
	private void initLang(String lang) {
		if (
			"vie".equalsIgnoreCase(lang)
		||	"vi".equalsIgnoreCase(lang)) {
			gameConfig.setLang(Constants.LANG_VI);
		} else if (
			"eng".equalsIgnoreCase(lang)
		||	"en".equalsIgnoreCase(lang)) {
			gameConfig.setLang(Constants.LANG_EN);
		} else if (
			"es_es".equalsIgnoreCase(lang)) {
			gameConfig.setLang(Constants.LANG_ES);
		} else if (
			"zh".equalsIgnoreCase(lang)
		||	"zh_cn".equalsIgnoreCase(lang)
		||	"zh_tw".equalsIgnoreCase(lang)) {
			gameConfig.setLang(Constants.LANG_CN);
		} else if (
			"th".equalsIgnoreCase(lang)
		||	"tha".equalsIgnoreCase(lang)) {
			gameConfig.setLang(Constants.LANG_TH);
		} else if (
			"ind".equalsIgnoreCase(lang)
		||	"id".equalsIgnoreCase(lang)) {
			gameConfig.setLang(Constants.LANG_ID);
		}
		
	}
	
}
