/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextThemeWrapper;
import com.mobgame.model.MUrl;
import com.mobgame.utils.Constants;
import com.mobgame.utils.Preference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    private static String TAG = Utils.class.getSimpleName();
    private static ProgressDialog progressDialog;
    private boolean isShowUpgrade;

    public static String getReferrer(Context c) {
        return Preference.getString(c, "shared_pref_referrer");
    }

    public static void setReferrer(Context c, String value) {
        Preference.save(c, "shared_pref_referrer", value);
    }

    public static String getGameVersion(Context c) {
        String versionName = null;
        PackageManager packageManager = c.getPackageManager();
        if (packageManager != null) {
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(c.getPackageName(), 0);
                versionName = packageInfo.versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                versionName = null;
            }
        }
        return versionName;
    }

    public static String getGameVersionCode(Context c) {
        String versionCode = null;
        PackageManager packageManager = c.getPackageManager();
        if (packageManager != null) {
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(c.getPackageName(), 0);
                versionCode = packageInfo.versionCode + "";
            }
            catch (PackageManager.NameNotFoundException e) {
                versionCode = null;
            }
        }
        return versionCode;
    }

    public static String getSDKVersion(Context c) {
        return "2.4.4.3b.AS";
    }

    public static String getNetwork(Context context) {
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = manager.getActiveNetworkInfo();
            if (info != null) {
                return info.getTypeName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void addNtf(Context c, int id2) {
        try {
            String ntfsString = Preference.getString(c, "shared_pref_notificatons");
            JSONArray ntfs = new JSONArray();
            try {
                ntfs = new JSONArray(ntfsString);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            ntfs.put(id2);
            Preference.save(c, "shared_pref_notificatons", ntfs.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeNtf(Context c, int id2) {
        Log.d((String)TAG, (String)("removeNotificationId" + id2));
        try {
            String ntfsString = Preference.getString(c, "shared_pref_notificatons");
            JSONArray ntfs = new JSONArray(ntfsString);
            JSONArray newNtfs = new JSONArray();
            for (int i = 0; i < ntfs.length(); ++i) {
                if (id2 == ntfs.getInt(i)) continue;
                newNtfs.put(ntfs.getInt(i));
            }
            Log.d((String)TAG, (String)("left removeNotificationId" + newNtfs));
            Preference.save(c, "shared_pref_notificatons", newNtfs.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static boolean hasNtf(Context c) {
        return !Utils.getNtfs(c).isEmpty();
    }

    public static boolean hasNtf(Context c, int id2) {
        return Utils.getNtfs(c).contains(id2);
    }

    public static ArrayList<Integer> getNtfs(Context c) {
        try {
            String ntfsString = Preference.getString(c, "shared_pref_notificatons");
            JSONArray ntfs = new JSONArray(ntfsString);
            ArrayList<Integer> ntfIds = new ArrayList<Integer>();
            for (int i = ntfs.length() - 1; i >= 0; --i) {
                ntfIds.add(ntfs.getInt(i));
            }
            return ntfIds;
        }
        catch (JSONException jSONException) {
            return new ArrayList<Integer>();
        }
    }

    public static int countNtfs(Context c) {
        try {
            return Utils.getNtfs(c).size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isDashboardEnabled(Context c) {
        return Preference.getBoolean(c, "shared_pref_db_enabled", false);
    }

    public static boolean isPlfUrl(MUrl url) {
        return Utils.isPlfUrl(url.getPath());
    }

    public static boolean hasDomain(String url) {
        String u = url.toLowerCase();
        return u.contains(Constants.BASE_URL_DOMAIN);
    }

    public static boolean isPlfUrl(String url) {
        String u = url.toLowerCase(Locale.ENGLISH);
        return u.startsWith("http://" + Constants.DOMAIN_NAME) || u.startsWith("https://" + Constants.DOMAIN_NAME);
    }

    public static void showLoading(Activity a, String message) {
        Utils.showLoading(a, null, message);
    }

    public static void showLoading(Activity a, String title, String message) {
        Utils.showLoading(a, null, message, true);
    }

    public static void showLoading(Activity a, String title, String message, boolean cancelable) {
        Utils.hideLoading();
        progressDialog = new ProgressDialog((Context)Utils.getContextThemeWrapper((Context)a));
        progressDialog.setMessage((CharSequence)message);
        progressDialog.setIndeterminateDrawable(null);
        progressDialog.show();
    }

    public static void hideLoading() {
        if (progressDialog != null) {
            progressDialog.dismiss();
        }
    }

    public static ContextThemeWrapper getContextThemeWrapper(Context c) {
        if (Build.VERSION.SDK_INT >= 11) {
            return new ContextThemeWrapper(c, 16973941);
        }
        return new ContextThemeWrapper(c, 16973837);
    }

    public static String getSHACheckSum(String checksum) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(checksum.getBytes());
            byte[] byteData = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isJSONValid(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return false;
        }
        try {
            new JSONObject(jsonString);
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }

    public static boolean canDrawOverApp(Context c) {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Method m = Settings.class.getDeclaredMethod("canDrawOverlays", Context.class);
                m.setAccessible(true);
                Boolean o = (Boolean)m.invoke(null, c);
                return o;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        int width = drawable2.getIntrinsicWidth();
        width = width > 0 ? width : 1;
        int height = drawable2.getIntrinsicHeight();
        height = height > 0 ? height : 1;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static boolean isOnline(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnectedOrConnecting();
    }

    public boolean getShowUpgrade() {
        return this.isShowUpgrade;
    }

    public void setShowUpgrade(boolean isShowUpgrade) {
        this.isShowUpgrade = isShowUpgrade;
    }
}

