package com.mobgame.component;

import java.util.ArrayList;

import android.content.Context;

import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

public final class GoogleAnalyticsManager {

	// private final static String TAG = FacebookManager.class.getSimpleName();
	private static GoogleAnalyticsManager INSTANCE;

	private GoogleAnalytics analytics;
	private ArrayList<Tracker> trackers;

	{
		trackers = new ArrayList<Tracker>();
	}

	public static GoogleAnalyticsManager getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new GoogleAnalyticsManager();
		}
		return INSTANCE;
	}

	private GoogleAnalyticsManager() {
	}

	void init(Context applicationContext) {
		analytics = GoogleAnalytics.getInstance(applicationContext);
	}

	public void addTracker(String gaId) {
		Tracker t = analytics.newTracker(gaId);
		t.send(new HitBuilders.EventBuilder().setCategory("UX")
				.setAction("appstart").setNewSession().build());
		trackers.add(t);
	}
	
	public void removeTrackers() {
		trackers = new ArrayList<Tracker>();
	}

	public void trackEvent(String category, String action, String label, long value) {
		if (trackers != null) {
			for (Tracker t : trackers) {
				t.send(new HitBuilders.EventBuilder()
						.setCategory(category)
						.setAction(action)
						.setLabel(label)
						.setValue(value)
						.build());
			}
		}
	}
	
	public void trackScreen(String screenName) {
		if (trackers != null) {
			for (Tracker t : trackers) {
				t.setScreenName(screenName);
				t.send(new HitBuilders.ScreenViewBuilder().build());
			}
		}
	}

}
