/*
 * Decompiled with CFR 0.152.
 */
package com.mobandme.android.bind;

import android.view.ViewGroup;
import com.mobandme.android.bind.binder.BinderFactory;
import com.mobandme.android.bind.binder.DataBinder;
import com.mobandme.android.bind.compiler.Compiler;
import java.util.Collection;

public class Binder {
    public static final int DIRECTION_UNKNOW = 0;
    public static final int DIRECTION_OBJECT_TO_VIEWS = 1;
    public static final int DIRECTION_VIEWS_TO_OBJECT = 2;
    private Compiler compiler;
    private Builder builder;

    public void bind() {
        int direction = this.builder.getBindDirection();
        Object modelObject = this.getModelObject();
        this.bind(direction, modelObject);
    }

    public void bindWithModel(Object modelObject) {
        if (modelObject == null) {
            throw new IllegalArgumentException("The modelObject argument cannot be null.");
        }
        if (modelObject.getClass() != this.getModelObject().getClass()) {
            throw new IllegalArgumentException("The model object type not is valid. Please pass an object of the same type that you passed on your Binder.Builder.");
        }
        int direction = this.builder.getBindDirection();
        this.bind(direction, modelObject);
    }

    public void bindReverse() {
        int direction = this.builder.getBindDirectionReverse();
        Object modelObject = this.getModelObject();
        this.bind(direction, modelObject);
    }

    public void bindReverseWithModel(Object modelObject) {
        if (modelObject == null) {
            throw new IllegalArgumentException("The modelObject argument cannot be null.");
        }
        if (modelObject.getClass() != this.getModelObject().getClass()) {
            throw new IllegalArgumentException("The model object type not is valid. Please pass an object of the same type that you passed on your Binder.Builder.");
        }
        int direction = this.builder.getBindDirectionReverse();
        this.bind(direction, modelObject);
    }

    private Binder(Builder builder) {
        this.builder = builder;
        this.initializeCompiler();
    }

    private void initializeCompiler() {
        this.compiler = this.builder.getBindDirection() == 1 ? new Compiler(this.builder.getSource(), (ViewGroup)this.builder.getDestination()) : new Compiler(this.builder.getDestination(), (ViewGroup)this.builder.getSource());
        this.compiler.compile();
    }

    private Object getModelObject() {
        if (this.builder.getBindDirection() == 1) {
            return this.builder.getSource();
        }
        return this.builder.getDestination();
    }

    private void bind(int direction, Object modelObject) {
        Collection<Compiler.Mapping> mappingsList = this.compiler.getMappingsList();
        for (Compiler.Mapping mapping : mappingsList) {
            DataBinder binder = BinderFactory.getBinder(mapping);
            binder.bind(mapping, modelObject, direction);
        }
    }

    public static final class Builder {
        private Integer bindDirection = 0;
        private Object source;
        private Object destination;

        public Builder setSource(Object source) {
            if (source == null) {
                throw new IllegalArgumentException("The argument source cannot be null.");
            }
            this.source = source;
            return this;
        }

        protected Object getSource() {
            return this.source;
        }

        public Builder setDestination(Object destination) {
            if (destination == null) {
                throw new IllegalArgumentException("The argument destination cannot be null.");
            }
            this.destination = destination;
            return this;
        }

        protected Object getDestination() {
            return this.destination;
        }

        public Integer getBindDirection() {
            return this.bindDirection;
        }

        public Integer getBindDirectionReverse() {
            if (this.bindDirection == 1) {
                return 2;
            }
            return 1;
        }

        public Binder build() {
            if (this.getSource() == null || this.getDestination() == null) {
                throw new IllegalArgumentException("The parameters Source and Destination cannot be null. Please use the method setSource and setDestination to establish these.");
            }
            if (this.source instanceof ViewGroup) {
                this.bindDirection = 2;
            }
            if (this.destination instanceof ViewGroup) {
                this.bindDirection = 1;
            }
            if (this.bindDirection == 0) {
                throw new IllegalArgumentException("The parameters Source or Destination not is an android.view.ViewGroup member.");
            }
            return new Binder(this);
        }
    }
}

