/*
 * Decompiled with CFR 0.152.
 */
package com.mobandme.android.bind.compiler;

import android.view.View;
import android.view.ViewGroup;
import com.mobandme.android.bind.annotations.BindTo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;

public final class Compiler {
    private Object object;
    private ViewGroup rootView;
    private HashMap<String, Mapping> mappings;

    public Compiler(Object object, ViewGroup rootView) {
        this.object = object;
        this.rootView = rootView;
        this.mappings = new HashMap();
    }

    public Compiler compile() {
        this.readObjectConfiguration();
        return this;
    }

    public Set<String> getMappingsList() {
        return this.mappings.keySet();
    }

    public Mapping getMappig(String field) {
        return this.mappings.get(field);
    }

    private void readObjectConfiguration() {
        Field[] declaredFields;
        for (Field field : declaredFields = this.object.getClass().getDeclaredFields()) {
            BindTo bindAnnotation = field.getAnnotation(BindTo.class);
            if (bindAnnotation == null) continue;
            String fieldName = field.getName();
            int viewId = bindAnnotation.viewId();
            View view = this.extractView(viewId);
            if (view == null) continue;
            Method getterMethod = this.extractGetterMethod(this.object, field, bindAnnotation);
            Method setterMethod = this.extractSetterMethod(this.object, field, bindAnnotation);
            Class<?> binder = bindAnnotation.binder();
            Class<?> parser = bindAnnotation.parser();
            Mapping mapping = new Mapping(field, view, getterMethod, setterMethod, binder, parser);
            this.mappings.put(fieldName, mapping);
        }
    }

    private Method extractGetterMethod(Object object, Field field, BindTo bind) {
        Method result = null;
        if (bind.getter() != null) {
            String methodName;
            if (bind.getter().equals("")) {
                String methodSuffix = this.capitalize(field.getName());
                methodName = field.getType() != Boolean.class ? String.format("get%s", methodSuffix) : String.format("is%s", methodSuffix);
            } else {
                methodName = bind.getter();
            }
            result = this.extractMethod(object.getClass(), methodName, null);
        }
        return result;
    }

    private Method extractSetterMethod(Object object, Field field, BindTo bind) {
        Method result = null;
        if (bind.setter() != null) {
            String methodName;
            if (bind.setter().equals("")) {
                String methodSuffix = this.capitalize(field.getName());
                methodName = String.format("set%s", methodSuffix);
            } else {
                methodName = bind.setter();
            }
            result = this.extractMethod(object.getClass(), methodName, new Class[]{field.getType()});
        }
        return result;
    }

    private Method extractMethod(Class objectClass, String methodName, Class[] argumentsTypes) {
        Method result = null;
        try {
            result = objectClass.getMethod(methodName, argumentsTypes);
        }
        catch (NoSuchMethodException error) {
            // empty catch block
        }
        return result;
    }

    private View extractView(int viewId) {
        return this.rootView.findViewById(viewId);
    }

    private String capitalize(String source) {
        String result = source.trim();
        if (result != null && !result.equals("")) {
            result = result.length() > 1 ? Character.toUpperCase(result.charAt(0)) + result.substring(1) : result.toUpperCase();
        }
        return result;
    }

    public class Mapping {
        private Field field;
        private View view;
        private Method getter;
        private Method setter;
        private Class binder;
        private Class parser;

        public Field getField() {
            return this.field;
        }

        public View getView() {
            return this.view;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public Class getBinder() {
            return this.binder;
        }

        public Class getParser() {
            return this.parser;
        }

        public Mapping(Field field, View view, Method getter, Method setter, Class binder, Class parser) {
            this.field = field;
            this.view = view;
            this.getter = getter;
            this.setter = setter;
            this.binder = binder;
            this.parser = parser;
        }

        public String toString() {
            if (this.field != null) {
                return this.field.getName();
            }
            return super.toString();
        }
    }
}

