/*
 * Decompiled with CFR 0.152.
 */
package com.mn.tiger.log;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.mn.tiger.log.LogConfig;
import com.mn.tiger.log.LogLevel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class Logger {
    private String mDefaultTag = "logger";
    private LogLevel mLevel;
    private static LogLevel mCurrentLogLevel = LogLevel.LOG_LEVEL_DEBUG;
    private static HashMap<String, SoftReference<Logger>> mCacheLogger = new HashMap();
    private OutputStreamWriter mWriter;
    public static final String LOG_FILE_PATH_DEFAULT = "%1$s/%2$s/log/%3$s.log";
    private static SimpleDateFormat mDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat mTimeFormatter = new SimpleDateFormat("MM-dd HH:mm:ss");
    private static List<LogConfig> mConfigs = null;
    private static String packageName = "tiger";

    private Logger(String defaultTag, LogLevel level) {
        this.mDefaultTag = defaultTag;
        this.mLevel = level;
    }

    public String getDefultTag() {
        return this.mDefaultTag;
    }

    public void setLogWriter(OutputStreamWriter writer) {
        this.mWriter = writer;
    }

    public static void setPackageName(String packageName) {
        Logger.packageName = packageName;
    }

    public static Logger getLogger(Class<?> cls, boolean isLog2File) {
        String tag = cls.getSimpleName();
        Package pkg = cls.getPackage();
        String pkgName = "";
        if (pkg != null) {
            pkgName = pkg.getName();
        }
        Logger logger = null;
        if (!mCacheLogger.containsKey(tag)) {
            logger = Logger.newInstance2Cache(tag, pkgName);
        } else {
            SoftReference<Logger> sr = mCacheLogger.get(tag);
            logger = sr.get();
            if (logger == null) {
                logger = Logger.newInstance2Cache(tag, pkgName);
            }
        }
        if (isLog2File && "mounted".equals(Environment.getExternalStorageState())) {
            String sdcardPath = Environment.getExternalStorageDirectory().getPath();
            String filePath = String.format(LOG_FILE_PATH_DEFAULT, sdcardPath, packageName, mDateFormatter.format(new Date()));
            try {
                File logFile = new File(filePath);
                if (!logFile.getParentFile().exists()) {
                    logFile.getParentFile().mkdirs();
                }
                if (logger.mWriter == null) {
                    logger.mWriter = new FileWriter(filePath, true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                Log.e((String)Logger.class.getSimpleName(), (String)e.getMessage());
            }
        }
        return logger;
    }

    public static Logger getLogger(Class<?> cls) {
        return Logger.getLogger(cls, false);
    }

    private static Logger newInstance2Cache(String tag, String pkgName) {
        LogConfig config = null;
        String cfgTagPrefix = null;
        if (mConfigs != null) {
            for (LogConfig cfg : mConfigs) {
                if (tag.equals(cfg.filter)) {
                    config = cfg;
                    break;
                }
                if (TextUtils.isEmpty((CharSequence)cfg.filter) || !cfg.filter.endsWith(".*")) continue;
                cfgTagPrefix = cfg.filter.substring(0, cfg.filter.lastIndexOf(46));
                if (!pkgName.startsWith(cfgTagPrefix)) break;
                config = cfg;
                break;
            }
        }
        Logger logger = config != null ? new Logger(tag, config.logLevel) : new Logger(tag, mCurrentLogLevel);
        SoftReference<Logger> srLogger = new SoftReference<Logger>(logger);
        mCacheLogger.put(tag, srLogger);
        return logger;
    }

    private static void initConfig() {
    }

    public static void setGlobalLogLevel(LogLevel logLevel) {
        mCurrentLogLevel = logLevel;
    }

    public static LogLevel getGlobalLogLevel() {
        return mCurrentLogLevel;
    }

    public void e(String msg) {
        this.e(this.mDefaultTag, msg);
    }

    public void e(Throwable throwable) {
        this.e(this.mDefaultTag, throwable);
    }

    public void e(String msg, Throwable throwable) {
        if (mCurrentLogLevel.getValue() >= LogLevel.LOG_LEVEL_ERROR.getValue()) {
            Log.e((String)this.mDefaultTag, (String)msg, (Throwable)throwable);
            this.writeFile("E", this.mDefaultTag, msg + "--->" + throwable.getMessage());
        }
    }

    public void w(String msg) {
        this.w(this.mDefaultTag, msg);
    }

    public void d(String msg) {
        this.d(this.mDefaultTag, msg);
    }

    public void i(String msg) {
        this.i(this.mDefaultTag, msg);
    }

    public void w(String tag, String msg) {
        if (mCurrentLogLevel.getValue() >= LogLevel.LOG_LEVEL_WARN.getValue()) {
            Log.w((String)tag, (String)msg);
            this.writeFile("W", tag, msg);
        }
    }

    private void writeFile(String level, String tag, String msg) {
        String line = level + ":" + tag + "\t" + mTimeFormatter.format(new Date()) + "\t" + msg;
        if (this.mWriter != null) {
            try {
                this.mWriter.write(line);
                this.mWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void d(String tag, String msg) {
        if (mCurrentLogLevel.getValue() >= LogLevel.LOG_LEVEL_DEBUG.getValue()) {
            Log.d((String)tag, (String)msg);
            this.writeFile("D", tag, msg);
        }
    }

    public void e(String tag, String msg) {
        if (mCurrentLogLevel.getValue() >= LogLevel.LOG_LEVEL_ERROR.getValue()) {
            Log.e((String)tag, (String)msg);
            this.writeFile("E", tag, msg);
        }
    }

    public void e(String tag, String msg, Throwable throwable) {
        if (mCurrentLogLevel.getValue() >= LogLevel.LOG_LEVEL_ERROR.getValue()) {
            Log.e((String)tag, (String)msg, (Throwable)throwable);
            this.writeFile("E", tag, msg + "--->" + throwable.getMessage());
        }
    }

    public void i(String tag, String msg) {
        if (mCurrentLogLevel.getValue() >= LogLevel.LOG_LEVEL_INFO.getValue()) {
            Log.i((String)tag, (String)msg);
            this.writeFile("I", tag, msg);
        }
    }

    public void r(String message) {
    }

    public LogLevel getLogLevel() {
        return this.mLevel;
    }

    public void setLogLevel(LogLevel level) {
        this.mLevel = level;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mWriter != null) {
            try {
                this.mWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mWriter = null;
        }
    }

    static {
        Logger.initConfig();
    }
}

