/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import org.bitcoinj.core.Utils;

public class ByteUtils {
    public static final int UINT_32_LENGTH = 4;
    public static final int UINT_64_LENGTH = 8;
    public static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static byte[] readBytes(byte[] buf, int offset, int length) {
        byte[] b = new byte[length];
        System.arraycopy(buf, offset, b, 0, length);
        return b;
    }

    public static BigInteger readUint64(byte[] buf, int offset) {
        return new BigInteger(Utils.reverseBytes((byte[])ByteUtils.readBytes(buf, offset, 8)));
    }

    public static BigInteger readUint64Price(byte[] buf, int offset) {
        return new BigInteger(ByteUtils.readBytes(buf, offset, 8));
    }

    public static void uint64ToByteStreamLE(BigInteger val, OutputStream stream) throws IOException {
        byte[] bytes = val.toByteArray();
        if (bytes.length > 8) {
            if (bytes[0] == 0) {
                bytes = ByteUtils.readBytes(bytes, 1, bytes.length - 1);
            } else {
                throw new RuntimeException("Input too large to encode into a uint64");
            }
        }
        bytes = Utils.reverseBytes((byte[])bytes);
        stream.write(bytes);
        if (bytes.length < 8) {
            for (int i = 0; i < 8 - bytes.length; ++i) {
                stream.write(0);
            }
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] trim(byte[] bytes) {
        int i;
        for (i = bytes.length - 1; i >= 0 && bytes[i] == 0; --i) {
        }
        return Arrays.copyOf(bytes, i + 1);
    }

    public static int getBit(byte[] data, int pos) {
        int posByte = pos / 8;
        int posBit = pos % 8;
        byte valByte = data[posByte];
        int valInt = valByte >> posBit & 1;
        return valInt;
    }
}

