/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.programs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import org.p2p.solanaj.core.AccountMeta;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.TransactionInstruction;
import org.p2p.solanaj.programs.Program;

public class ComputeBudgetProgram
extends Program {
    public static final PublicKey PROGRAM_ID = PublicKey.valueOf("ComputeBudget111111111111111111111111111111");
    private static final byte REQUEST_HEAP_FRAME = 1;
    private static final byte SET_COMPUTE_UNIT_LIMIT = 2;
    private static final byte SET_COMPUTE_UNIT_PRICE = 3;
    private static final byte SET_LOADED_ACCOUNTS_DATA_SIZE_LIMIT = 4;

    public static TransactionInstruction setComputeUnitPrice(int microLamports) {
        byte[] transactionData = ComputeBudgetProgram.encodeSetComputeUnitPriceTransaction(microLamports);
        return ComputeBudgetProgram.createTransactionInstruction(PROGRAM_ID, Collections.emptyList(), transactionData);
    }

    public static TransactionInstruction setComputeUnitLimit(int units) {
        byte[] transactionData = ComputeBudgetProgram.encodeSetComputeUnitLimitTransaction(units);
        return ComputeBudgetProgram.createTransactionInstruction(PROGRAM_ID, Collections.emptyList(), transactionData);
    }

    public static TransactionInstruction setLoadedAccountsDataSizeLimit(int bytes) {
        byte[] transactionData = ComputeBudgetProgram.encodeSetLoadedAccountsDataSizeLimitTransaction(bytes);
        return ComputeBudgetProgram.createTransactionInstruction(PROGRAM_ID, Collections.emptyList(), transactionData);
    }

    public static TransactionInstruction requestHeapFrame(int bytes) {
        byte[] data = new byte[]{1, (byte)(bytes & 0xFF), (byte)(bytes >> 8 & 0xFF), (byte)(bytes >> 16 & 0xFF), (byte)(bytes >> 24 & 0xFF)};
        return new TransactionInstruction(PROGRAM_ID, new ArrayList<AccountMeta>(), data);
    }

    private static byte[] encodeSetComputeUnitPriceTransaction(int microLamports) {
        ByteBuffer result = ByteBuffer.allocate(9);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put((byte)3);
        result.putLong(microLamports);
        return result.array();
    }

    private static byte[] encodeSetComputeUnitLimitTransaction(int units) {
        ByteBuffer result = ByteBuffer.allocate(5);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put((byte)2);
        result.putInt(units);
        return result.array();
    }

    private static byte[] encodeSetLoadedAccountsDataSizeLimitTransaction(int bytes) {
        ByteBuffer result = ByteBuffer.allocate(5);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put((byte)4);
        result.putInt(bytes);
        return result.array();
    }
}

