/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.core;

import java.util.List;
import java.util.Objects;
import org.p2p.solanaj.core.Account;
import org.p2p.solanaj.core.Transaction;
import org.p2p.solanaj.core.TransactionInstruction;

public class TransactionBuilder {
    private final Transaction transaction = new Transaction();

    public TransactionBuilder addInstruction(TransactionInstruction transactionInstruction) {
        Objects.requireNonNull(transactionInstruction, "Transaction instruction cannot be null");
        this.transaction.addInstruction(transactionInstruction);
        return this;
    }

    public TransactionBuilder addInstructions(List<TransactionInstruction> instructions) {
        Objects.requireNonNull(instructions, "Instructions list cannot be null");
        instructions.forEach(this::addInstruction);
        return this;
    }

    public TransactionBuilder setRecentBlockHash(String recentBlockHash) {
        Objects.requireNonNull(recentBlockHash, "Recent block hash cannot be null");
        this.transaction.setRecentBlockHash(recentBlockHash);
        return this;
    }

    public TransactionBuilder setSigners(List<Account> signers) {
        Objects.requireNonNull(signers, "Signers list cannot be null");
        if (signers.isEmpty()) {
            throw new IllegalArgumentException("Signers list cannot be empty");
        }
        this.transaction.sign(signers);
        return this;
    }

    public Transaction build() {
        return this.transaction;
    }
}

