/*
 * Decompiled with CFR 0.152.
 */
package com.mlsdev.rxkeyboard;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import com.mlsdev.rxkeyboard.KeyboardState;
import java.lang.ref.WeakReference;
import rx.Observable;
import rx.functions.Action0;
import rx.subjects.PublishSubject;

public class RxKeyboard {
    private ViewTreeObserver.OnGlobalLayoutListener viewTreeObserverListener;
    private WeakReference<View> rootView;
    private PublishSubject<KeyboardState> publishSubject;
    private static RxKeyboard instance;

    public static synchronized RxKeyboard instance() {
        if (instance == null) {
            instance = new RxKeyboard();
        }
        return instance;
    }

    private RxKeyboard() {
    }

    public Observable<KeyboardState> requestKeyboardUpdates(Activity activity) {
        this.publishSubject = PublishSubject.create();
        activity.getWindow().setSoftInputMode(16);
        this.viewTreeObserverListener = new GlobalLayoutListener();
        this.rootView = new WeakReference<View>(activity.findViewById(0x1020002));
        ((View)this.rootView.get()).getViewTreeObserver().addOnGlobalLayoutListener(this.viewTreeObserverListener);
        this.publishSubject.doOnUnsubscribe(new Action0(){

            public void call() {
                RxKeyboard.this.destroy();
            }
        });
        return this.publishSubject;
    }

    public void destroy() {
        if (this.rootView.get() != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                ((View)this.rootView.get()).getViewTreeObserver().removeOnGlobalLayoutListener(this.viewTreeObserverListener);
            } else {
                ((View)this.rootView.get()).getViewTreeObserver().removeGlobalOnLayoutListener(this.viewTreeObserverListener);
            }
        }
    }

    private class GlobalLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        int initialValue;
        boolean hasSentInitialAction;
        boolean isKeyboardShown;

        private GlobalLayoutListener() {
        }

        public void onGlobalLayout() {
            if (this.initialValue == 0) {
                this.initialValue = ((View)RxKeyboard.this.rootView.get()).getHeight();
            } else {
                if (this.initialValue > ((View)RxKeyboard.this.rootView.get()).getHeight()) {
                    if (!this.hasSentInitialAction || !this.isKeyboardShown) {
                        this.isKeyboardShown = true;
                        RxKeyboard.this.publishSubject.onNext((Object)new KeyboardState(true, this.initialValue - ((View)RxKeyboard.this.rootView.get()).getHeight()));
                    }
                } else if (!this.hasSentInitialAction || this.isKeyboardShown) {
                    this.isKeyboardShown = false;
                    ((View)RxKeyboard.this.rootView.get()).post(new Runnable(){

                        @Override
                        public void run() {
                            RxKeyboard.this.publishSubject.onNext((Object)new KeyboardState(false));
                        }
                    });
                }
                this.hasSentInitialAction = true;
            }
        }
    }
}

