/*
 * Decompiled with CFR 0.152.
 */
package com.mlsdev.rximagepicker;

import android.annotation.TargetApi;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.mlsdev.rximagepicker.RxImagePicker$WhenMappings;
import com.mlsdev.rximagepicker.Sources;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.PublishSubject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 62\u00020\u0001:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0012\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u001f\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0002J\"\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010#\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010$\u001a\u00020\u00182\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0012\u0010'\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010(\u001a\u00020\u00182\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J+\u0010*\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0,2\u0006\u0010-\u001a\u00020.H\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u0018H\u0002J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u000e022\u0006\u00103\u001a\u00020\fJ\u001e\u00101\u001a\b\u0012\u0004\u0012\u00020\u000e022\u0006\u00103\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0014\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001002H\u0007J\b\u00105\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00100\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/mlsdev/rximagepicker/RxImagePicker;", "Landroidx/fragment/app/Fragment;", "()V", "allowMultipleImages", "", "attachedSubject", "Lio/reactivex/subjects/PublishSubject;", "canceledSubject", "", "chooserTitle", "", "imageSource", "Lcom/mlsdev/rximagepicker/Sources;", "publishSubject", "Landroid/net/Uri;", "publishSubjectMultipleImages", "", "checkPermission", "createChooserIntent", "Landroid/content/Intent;", "createImageUri", "createPickFromDocumentsIntent", "createPickFromGalleryIntent", "grantWritePermission", "", "context", "Landroid/content/Context;", "intent", "uri", "handleGalleryResult", "data", "isPhoto", "onActivityResult", "requestCode", "resultCode", "onAttach", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onImagePicked", "onImagesPicked", "uris", "onRequestPermissionsResult", "permissions", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "pickImage", "requestImage", "Lio/reactivex/Observable;", "source", "requestMultipleImages", "requestPickImage", "Companion", "library_release"})
public final class RxImagePicker
extends Fragment {
    private PublishSubject<Boolean> attachedSubject;
    private PublishSubject<Uri> publishSubject;
    private PublishSubject<List<Uri>> publishSubjectMultipleImages;
    private PublishSubject<Integer> canceledSubject;
    private boolean allowMultipleImages;
    private Sources imageSource;
    private String chooserTitle;
    private static final int SELECT_PHOTO = 100;
    private static final int TAKE_PHOTO = 101;
    private static final int CHOOSER = 102;
    private static final String TAG;
    private static Uri cameraPictureUrl;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @NotNull
    public final Observable<Uri> requestImage(@NotNull Sources source, @Nullable String chooserTitle) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)source), (String)"source");
        this.chooserTitle = chooserTitle;
        return this.requestImage(source);
    }

    @NotNull
    public final Observable<Uri> requestImage(@NotNull Sources source) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)source), (String)"source");
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create()");
        this.publishSubject = publishSubject;
        PublishSubject publishSubject2 = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject2, (String)"PublishSubject.create()");
        this.attachedSubject = publishSubject2;
        PublishSubject publishSubject3 = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject3, (String)"PublishSubject.create()");
        this.canceledSubject = publishSubject3;
        this.allowMultipleImages = false;
        this.imageSource = source;
        this.requestPickImage();
        PublishSubject<Uri> publishSubject4 = this.publishSubject;
        if (publishSubject4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"publishSubject");
        }
        PublishSubject<Integer> publishSubject5 = this.canceledSubject;
        if (publishSubject5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canceledSubject");
        }
        Observable observable = publishSubject4.takeUntil((ObservableSource)publishSubject5);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"publishSubject.takeUntil(canceledSubject)");
        return observable;
    }

    @TargetApi(value=18)
    @NotNull
    public final Observable<List<Uri>> requestMultipleImages() {
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create()");
        this.publishSubjectMultipleImages = publishSubject;
        PublishSubject publishSubject2 = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject2, (String)"PublishSubject.create()");
        this.attachedSubject = publishSubject2;
        PublishSubject publishSubject3 = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject3, (String)"PublishSubject.create()");
        this.canceledSubject = publishSubject3;
        this.imageSource = Sources.GALLERY;
        this.allowMultipleImages = true;
        this.requestPickImage();
        PublishSubject<List<Uri>> publishSubject4 = this.publishSubjectMultipleImages;
        if (publishSubject4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"publishSubjectMultipleImages");
        }
        PublishSubject<Integer> publishSubject5 = this.canceledSubject;
        if (publishSubject5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"canceledSubject");
        }
        Observable observable = publishSubject4.takeUntil((ObservableSource)publishSubject5);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"publishSubjectMultipleIm\u2026akeUntil(canceledSubject)");
        return observable;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    public void onAttach(@Nullable Context context) {
        super.onAttach(context);
        PublishSubject<Boolean> publishSubject = this.attachedSubject;
        if (publishSubject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachedSubject");
        }
        publishSubject.onNext((Object)true);
        PublishSubject<Boolean> publishSubject2 = this.attachedSubject;
        if (publishSubject2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachedSubject");
        }
        publishSubject2.onComplete();
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        int[] nArray;
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        int[] nArray2 = nArray = grantResults;
        if (!(nArray2.length == 0) && grantResults[0] == 0) {
            this.pickImage();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 100: {
                    this.handleGalleryResult(data);
                    break;
                }
                case 101: {
                    this.onImagePicked(cameraPictureUrl);
                    break;
                }
                case 102: {
                    if (this.isPhoto(data)) {
                        this.onImagePicked(cameraPictureUrl);
                        break;
                    }
                    this.handleGalleryResult(data);
                }
            }
        } else {
            PublishSubject<Integer> publishSubject = this.canceledSubject;
            if (publishSubject == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"canceledSubject");
            }
            publishSubject.onNext((Object)requestCode);
        }
    }

    private final boolean isPhoto(Intent data) {
        return data == null || data.getData() == null && data.getClipData() == null;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleGalleryResult(Intent data) {
        if (this.allowMultipleImages) {
            ClipData clipData;
            ArrayList<Uri> imageUris = new ArrayList<Uri>();
            Intent intent = data;
            if (intent == null) {
                Intrinsics.throwNpe();
            }
            if ((clipData = intent.getClipData()) != null) {
                int n = 0;
                int n2 = clipData.getItemCount();
                while (n < n2) {
                    void i;
                    ClipData.Item item = clipData.getItemAt((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"clipData.getItemAt(i)");
                    imageUris.add(item.getUri());
                    ++i;
                }
            } else {
                imageUris.add(data.getData());
            }
            this.onImagesPicked((List<? extends Uri>)imageUris);
        } else {
            Intent intent = data;
            if (intent == null) {
                Intrinsics.throwNpe();
            }
            this.onImagePicked(intent.getData());
        }
    }

    private final void requestPickImage() {
        if (!this.isAdded()) {
            PublishSubject<Boolean> publishSubject = this.attachedSubject;
            if (publishSubject == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachedSubject");
            }
            publishSubject.subscribe((Consumer)new Consumer<Boolean>(this){
                final /* synthetic */ RxImagePicker this$0;

                public final void accept(Boolean it) {
                    RxImagePicker.access$pickImage(this.this$0);
                }
                {
                    this.this$0 = rxImagePicker;
                }
            });
        } else {
            this.pickImage();
        }
    }

    private final void pickImage() {
        if (!this.checkPermission()) {
            return;
        }
        int chooseCode = 0;
        Intent pictureChooseIntent = null;
        Sources sources = this.imageSource;
        if (sources != null) {
            switch (RxImagePicker$WhenMappings.$EnumSwitchMapping$0[sources.ordinal()]) {
                case 1: {
                    cameraPictureUrl = this.createImageUri();
                    pictureChooseIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                    pictureChooseIntent.putExtra("output", (Parcelable)cameraPictureUrl);
                    Context context = this.getContext();
                    if (context == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context!!");
                    Uri uri = cameraPictureUrl;
                    if (uri == null) {
                        Intrinsics.throwNpe();
                    }
                    this.grantWritePermission(context, pictureChooseIntent, uri);
                    chooseCode = 101;
                    break;
                }
                case 2: {
                    pictureChooseIntent = this.createPickFromGalleryIntent();
                    chooseCode = 100;
                    break;
                }
                case 3: {
                    pictureChooseIntent = this.createPickFromDocumentsIntent();
                    chooseCode = 100;
                    break;
                }
                case 4: {
                    pictureChooseIntent = this.createChooserIntent(this.chooserTitle);
                    chooseCode = 102;
                }
            }
        }
        this.startActivityForResult(pictureChooseIntent, chooseCode);
    }

    /*
     * WARNING - void declaration
     */
    private final Intent createChooserIntent(String chooserTitle) {
        void $receiver$iv;
        Object packageName;
        cameraPictureUrl = this.createImageUri();
        ArrayList<Intent> cameraIntents = new ArrayList<Intent>();
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        Context context = this.getContext();
        if (context == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context!!");
        PackageManager packageManager = context.getPackageManager();
        List camList = packageManager.queryIntentActivities(captureIntent, 0);
        for (ResolveInfo res : camList) {
            packageName = res.activityInfo.packageName;
            Intent intent = new Intent(captureIntent);
            intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
            intent.setPackage((String)packageName);
            intent.putExtra("output", (Parcelable)cameraPictureUrl);
            Context context2 = this.getContext();
            if (context2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context!!");
            Uri uri = cameraPictureUrl;
            if (uri == null) {
                Intrinsics.throwNpe();
            }
            this.grantWritePermission(context2, intent, uri);
            cameraIntents.add(intent);
        }
        Intent galleryIntent = this.createPickFromDocumentsIntent();
        Intent chooserIntent = Intent.createChooser((Intent)galleryIntent, (CharSequence)chooserTitle);
        packageName = cameraIntents;
        String string = "android.intent.extra.INITIAL_INTENTS";
        Intent intent = chooserIntent;
        void thisCollection$iv = $receiver$iv;
        Intent[] intentArray = thisCollection$iv.toArray(new Intent[0]);
        if (intentArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Intent[] intentArray2 = intentArray;
        intent.putExtra(string, (Parcelable[])intentArray2);
        Intent intent2 = chooserIntent;
        Intrinsics.checkExpressionValueIsNotNull((Object)intent2, (String)"chooserIntent");
        return intent2;
    }

    private final Intent createPickFromGalleryIntent() {
        Intent pictureChooseIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        if (Build.VERSION.SDK_INT >= 19) {
            pictureChooseIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", this.allowMultipleImages);
        }
        return pictureChooseIntent;
    }

    private final Intent createPickFromDocumentsIntent() {
        Intent pictureChooseIntent;
        if (Build.VERSION.SDK_INT >= 19) {
            pictureChooseIntent = new Intent("android.intent.action.OPEN_DOCUMENT");
            pictureChooseIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", this.allowMultipleImages);
            pictureChooseIntent.addFlags(64);
        } else {
            pictureChooseIntent = new Intent("android.intent.action.GET_CONTENT");
        }
        pictureChooseIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        pictureChooseIntent.addFlags(1);
        pictureChooseIntent.setType("image/*");
        return pictureChooseIntent;
    }

    private final boolean checkPermission() {
        boolean bl;
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            Intrinsics.throwNpe();
        }
        if (ContextCompat.checkSelfPermission((Context)((Context)fragmentActivity), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 0);
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final Uri createImageUri() {
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"activity!!");
        ContentResolver contentResolver = fragmentActivity.getContentResolver();
        ContentValues cv = new ContentValues();
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        cv.put("title", timeStamp);
        return contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, cv);
    }

    private final void grantWritePermission(Context context, Intent intent, Uri uri) {
        List resInfoList = context.getPackageManager().queryIntentActivities(intent, 65536);
        for (ResolveInfo resolveInfo : resInfoList) {
            String packageName = resolveInfo.activityInfo.packageName;
            context.grantUriPermission(packageName, uri, 3);
        }
    }

    private final void onImagesPicked(List<? extends Uri> uris) {
        PublishSubject<List<Uri>> publishSubject = this.publishSubjectMultipleImages;
        if (publishSubject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"publishSubjectMultipleImages");
        }
        publishSubject.onNext(uris);
        PublishSubject<List<Uri>> publishSubject2 = this.publishSubjectMultipleImages;
        if (publishSubject2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"publishSubjectMultipleImages");
        }
        publishSubject2.onComplete();
    }

    private final void onImagePicked(Uri uri) {
        PublishSubject<Uri> publishSubject = this.publishSubject;
        if (publishSubject == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"publishSubject");
        }
        Uri uri2 = uri;
        if (uri2 == null) {
            Intrinsics.throwNpe();
        }
        publishSubject.onNext((Object)uri2);
        PublishSubject<Uri> publishSubject2 = this.publishSubject;
        if (publishSubject2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"publishSubject");
        }
        publishSubject2.onComplete();
    }

    static {
        Companion = new Companion(null);
        TAG = RxImagePicker.class.getSimpleName();
    }

    public static final /* synthetic */ void access$pickImage(RxImagePicker $this) {
        $this.pickImage();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mlsdev/rximagepicker/RxImagePicker$Companion;", "", "()V", "CHOOSER", "", "SELECT_PHOTO", "TAG", "", "kotlin.jvm.PlatformType", "TAKE_PHOTO", "cameraPictureUrl", "Landroid/net/Uri;", "with", "Lcom/mlsdev/rximagepicker/RxImagePicker;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "library_release"})
    public static final class Companion {
        @NotNull
        public final RxImagePicker with(@NotNull FragmentManager fragmentManager) {
            Intrinsics.checkParameterIsNotNull((Object)fragmentManager, (String)"fragmentManager");
            RxImagePicker rxImagePickerFragment = (RxImagePicker)fragmentManager.findFragmentByTag(TAG);
            if (rxImagePickerFragment == null) {
                rxImagePickerFragment = new RxImagePicker();
                fragmentManager.beginTransaction().add((Fragment)rxImagePickerFragment, TAG).commit();
            }
            return rxImagePickerFragment;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

