/*
 * Decompiled with CFR 0.152.
 */
package com.mlsdev.rximagepicker;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.mlsdev.rximagepicker.Sources;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.PublishSubject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class RxImagePicker
extends Fragment {
    private static final int SELECT_PHOTO = 100;
    private static final int TAKE_PHOTO = 101;
    private static final String TAG = RxImagePicker.class.getSimpleName();
    private static Uri cameraPictureUrl;
    private PublishSubject<Boolean> attachedSubject;
    private PublishSubject<Uri> publishSubject;
    private PublishSubject<List<Uri>> publishSubjectMultipleImages;
    private boolean allowMultipleImages = false;
    private Sources imageSource;

    public static RxImagePicker with(FragmentManager fragmentManager) {
        RxImagePicker rxImagePickerFragment = (RxImagePicker)fragmentManager.findFragmentByTag(TAG);
        if (rxImagePickerFragment == null) {
            rxImagePickerFragment = new RxImagePicker();
            fragmentManager.beginTransaction().add((Fragment)rxImagePickerFragment, TAG).commit();
        }
        return rxImagePickerFragment;
    }

    public Observable<Uri> requestImage(Sources source) {
        this.publishSubject = PublishSubject.create();
        this.attachedSubject = PublishSubject.create();
        this.allowMultipleImages = false;
        this.imageSource = source;
        this.requestPickImage();
        return this.publishSubject;
    }

    @TargetApi(value=18)
    public Observable<List<Uri>> requestMultipleImages() {
        this.publishSubjectMultipleImages = PublishSubject.create();
        this.attachedSubject = PublishSubject.create();
        this.imageSource = Sources.GALLERY;
        this.allowMultipleImages = true;
        this.requestPickImage();
        return this.publishSubjectMultipleImages;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.attachedSubject.onNext((Object)true);
        this.attachedSubject.onComplete();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.attachedSubject.onNext((Object)true);
        this.attachedSubject.onComplete();
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            this.pickImage();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 100: {
                    this.handleGalleryResult(data);
                    break;
                }
                case 101: {
                    this.onImagePicked(cameraPictureUrl);
                }
            }
        }
    }

    private void handleGalleryResult(Intent data) {
        if (this.allowMultipleImages) {
            ArrayList<Uri> imageUris = new ArrayList<Uri>();
            ClipData clipData = data.getClipData();
            if (clipData != null) {
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    imageUris.add(clipData.getItemAt(i).getUri());
                }
            } else {
                imageUris.add(data.getData());
            }
            this.onImagesPicked(imageUris);
        } else {
            this.onImagePicked(data.getData());
        }
    }

    private void requestPickImage() {
        if (!this.isAdded()) {
            this.attachedSubject.subscribe((Consumer)new Consumer<Boolean>(){

                public void accept(Boolean attached) throws Exception {
                    RxImagePicker.this.pickImage();
                }
            });
        } else {
            this.pickImage();
        }
    }

    private void pickImage() {
        if (!this.checkPermission()) {
            return;
        }
        int chooseCode = 0;
        Intent pictureChooseIntent = null;
        switch (this.imageSource) {
            case CAMERA: {
                cameraPictureUrl = this.createImageUri();
                pictureChooseIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                pictureChooseIntent.putExtra("output", (Parcelable)cameraPictureUrl);
                chooseCode = 101;
                break;
            }
            case GALLERY: {
                if (Build.VERSION.SDK_INT >= 19) {
                    pictureChooseIntent = new Intent("android.intent.action.OPEN_DOCUMENT");
                    pictureChooseIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", this.allowMultipleImages);
                    pictureChooseIntent.addFlags(64);
                } else {
                    pictureChooseIntent = new Intent("android.intent.action.GET_CONTENT");
                }
                pictureChooseIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
                pictureChooseIntent.addFlags(1);
                pictureChooseIntent.setType("image/*");
                chooseCode = 100;
            }
        }
        this.startActivityForResult(pictureChooseIntent, chooseCode);
    }

    private boolean checkPermission() {
        if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)0);
            return false;
        }
        return true;
    }

    private Uri createImageUri() {
        ContentResolver contentResolver = this.getActivity().getContentResolver();
        ContentValues cv = new ContentValues();
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        cv.put("title", timeStamp);
        return contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, cv);
    }

    private void onImagesPicked(List<Uri> uris) {
        if (this.publishSubjectMultipleImages != null) {
            this.publishSubjectMultipleImages.onNext(uris);
            this.publishSubjectMultipleImages.onComplete();
        }
    }

    private void onImagePicked(Uri uri) {
        if (this.publishSubject != null) {
            this.publishSubject.onNext((Object)uri);
            this.publishSubject.onComplete();
        }
    }
}

