/*
 * Decompiled with CFR 0.152.
 */
package com.mlsdev.rximagepicker;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RxImageConverters {
    public static Observable<File> uriToFile(final Context context, final Uri uri, final File file) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<File>(){

            public void subscribe(@NonNull ObservableEmitter<File> emitter) throws Exception {
                try {
                    InputStream inputStream = context.getContentResolver().openInputStream(uri);
                    RxImageConverters.copyInputStreamToFile(inputStream, file);
                    emitter.onNext((Object)file);
                    emitter.onComplete();
                }
                catch (Exception e) {
                    Log.e((String)RxImageConverters.class.getSimpleName(), (String)"Error converting uri", (Throwable)e);
                    emitter.onError((Throwable)e);
                }
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
    }

    public static Observable<Bitmap> uriToBitmap(final Context context, final Uri uri) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Bitmap>(){

            public void subscribe(@NonNull ObservableEmitter<Bitmap> emitter) throws Exception {
                try {
                    Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)uri);
                    emitter.onNext((Object)bitmap);
                    emitter.onComplete();
                }
                catch (IOException e) {
                    Log.e((String)RxImageConverters.class.getSimpleName(), (String)"Error converting uri", (Throwable)e);
                    emitter.onError((Throwable)e);
                }
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
    }

    private static void copyInputStreamToFile(InputStream in, File file) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[10240];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
    }
}

