/*
 * Decompiled with CFR 0.152.
 */
package com.mlsdev.rximagepicker;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.mlsdev.rximagepicker.HiddenActivity;
import com.mlsdev.rximagepicker.Sources;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.List;

public class RxImagePicker {
    private static RxImagePicker instance;
    private Context context;
    private PublishSubject<Uri> publishSubject;
    private PublishSubject<List<Uri>> publishSubjectMultipleImages;

    public static synchronized RxImagePicker with(Context context) {
        if (instance == null) {
            instance = new RxImagePicker(context.getApplicationContext());
        }
        return instance;
    }

    private RxImagePicker(Context context) {
        this.context = context;
    }

    public Observable<Uri> getActiveSubscription() {
        return this.publishSubject;
    }

    public Observable<Uri> requestImage(Sources imageSource) {
        this.publishSubject = PublishSubject.create();
        this.startImagePickHiddenActivity(imageSource.ordinal(), false);
        return this.publishSubject;
    }

    @TargetApi(value=18)
    public Observable<List<Uri>> requestMultipleImages() {
        this.publishSubjectMultipleImages = PublishSubject.create();
        this.startImagePickHiddenActivity(Sources.GALLERY.ordinal(), true);
        return this.publishSubjectMultipleImages;
    }

    void onImagePicked(Uri uri) {
        if (this.publishSubject != null) {
            this.publishSubject.onNext((Object)uri);
            this.publishSubject.onComplete();
        }
    }

    void onImagesPicked(List<Uri> uris) {
        if (this.publishSubjectMultipleImages != null) {
            this.publishSubjectMultipleImages.onNext(uris);
            this.publishSubjectMultipleImages.onComplete();
        }
    }

    private void startImagePickHiddenActivity(int imageSource, boolean allowMultipleImages) {
        Intent intent = new Intent(this.context, HiddenActivity.class);
        intent.addFlags(0x10000000);
        intent.putExtra("allow_multiple_images", allowMultipleImages);
        intent.putExtra("image_source", imageSource);
        this.context.startActivity(intent);
    }
}

