/*
 * Decompiled with CFR 0.152.
 */
package com.mlsdev.rximagepicker;

import android.app.Activity;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.mlsdev.rximagepicker.RxImagePicker;
import com.mlsdev.rximagepicker.Sources;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class HiddenActivity
extends Activity {
    private static final String KEY_CAMERA_PICTURE_URL = "cameraPictureUrl";
    public static final String IMAGE_SOURCE = "image_source";
    public static final String ALLOW_MULTIPLE_IMAGES = "allow_multiple_images";
    private static final int SELECT_PHOTO = 100;
    private static final int TAKE_PHOTO = 101;
    private Uri cameraPictureUrl;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.handleIntent(this.getIntent());
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putParcelable(KEY_CAMERA_PICTURE_URL, (Parcelable)this.cameraPictureUrl);
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.cameraPictureUrl = (Uri)savedInstanceState.getParcelable(KEY_CAMERA_PICTURE_URL);
    }

    protected void onNewIntent(Intent intent) {
        this.handleIntent(intent);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            this.handleIntent(this.getIntent());
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 100: {
                    this.handleGalleryResult(data);
                    break;
                }
                case 101: {
                    RxImagePicker.with((Context)this).onImagePicked(this.cameraPictureUrl);
                }
            }
        }
        this.finish();
    }

    private void handleGalleryResult(Intent data) {
        if (this.getIntent().getBooleanExtra(ALLOW_MULTIPLE_IMAGES, false)) {
            ArrayList<Uri> imageUris = new ArrayList<Uri>();
            ClipData clipData = data.getClipData();
            if (clipData != null) {
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    imageUris.add(clipData.getItemAt(i).getUri());
                }
            } else {
                imageUris.add(data.getData());
            }
            RxImagePicker.with((Context)this).onImagesPicked(imageUris);
        } else {
            RxImagePicker.with((Context)this).onImagePicked(data.getData());
        }
    }

    private void handleIntent(Intent intent) {
        if (!this.checkPermission()) {
            return;
        }
        Sources sourceType = Sources.values()[intent.getIntExtra(IMAGE_SOURCE, 0)];
        int chooseCode = 0;
        Intent pictureChooseIntent = null;
        switch (sourceType) {
            case CAMERA: {
                this.cameraPictureUrl = this.createImageUri();
                pictureChooseIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                pictureChooseIntent.putExtra("output", (Parcelable)this.cameraPictureUrl);
                chooseCode = 101;
                break;
            }
            case GALLERY: {
                if (Build.VERSION.SDK_INT >= 19) {
                    pictureChooseIntent = new Intent("android.intent.action.OPEN_DOCUMENT");
                    pictureChooseIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", this.getIntent().getBooleanExtra(ALLOW_MULTIPLE_IMAGES, false));
                    pictureChooseIntent.addFlags(64);
                } else {
                    pictureChooseIntent = new Intent("android.intent.action.GET_CONTENT");
                }
                pictureChooseIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
                pictureChooseIntent.addFlags(1);
                pictureChooseIntent.setType("image/*");
                chooseCode = 100;
            }
        }
        this.startActivityForResult(pictureChooseIntent, chooseCode);
    }

    private boolean checkPermission() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0 || ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"}, (int)0);
            return false;
        }
        return true;
    }

    private Uri createImageUri() {
        ContentResolver contentResolver = this.getContentResolver();
        ContentValues cv = new ContentValues();
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        cv.put("title", timeStamp);
        return contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, cv);
    }
}

