/*
 * Decompiled with CFR 0.152.
 */
package com.mlsdev.rximagepicker;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.mlsdev.rximagepicker.HiddenActivity;
import com.mlsdev.rximagepicker.Sources;
import rx.Observable;
import rx.subjects.PublishSubject;

public class RxImagePicker {
    private static RxImagePicker instance;
    private Context context;
    private PublishSubject<Uri> publishSubject;

    public static synchronized RxImagePicker with(Context context) {
        if (instance == null) {
            instance = new RxImagePicker(context.getApplicationContext());
        }
        return instance;
    }

    private RxImagePicker(Context context) {
        this.context = context;
    }

    public Observable<Uri> getActiveSubscription() {
        return this.publishSubject;
    }

    public Observable<Uri> requestImage(Sources imageSource) {
        this.publishSubject = PublishSubject.create();
        this.startImagePickHiddenActivity(imageSource.ordinal());
        return this.publishSubject;
    }

    void onImagePicked(Uri uri) {
        if (this.publishSubject != null) {
            this.publishSubject.onNext((Object)uri);
            this.publishSubject.onCompleted();
        }
    }

    private void startImagePickHiddenActivity(int imageSource) {
        Intent intent = new Intent(this.context, HiddenActivity.class);
        intent.addFlags(0x10000000);
        intent.putExtra("image_source", imageSource);
        this.context.startActivity(intent);
    }
}

