/*
 * Decompiled with CFR 0.152.
 */
package com.mlsdev.rximagepicker;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

public class RxImageConverters {
    public static Observable<File> uriToFile(final Context context, final Uri uri, final File file) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<File>(){

            public void call(Subscriber<? super File> subscriber) {
                try {
                    InputStream inputStream = context.getContentResolver().openInputStream(uri);
                    RxImageConverters.copyInputStreamToFile(inputStream, file);
                    subscriber.onNext((Object)file);
                }
                catch (Exception e) {
                    Log.e((String)RxImageConverters.class.getSimpleName(), (String)"Error converting uri", (Throwable)e);
                    subscriber.onError((Throwable)e);
                }
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
    }

    private static void copyInputStreamToFile(InputStream in, File file) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[10240];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
    }

    public static Observable<Bitmap> uriToBitmap(final Context context, final Uri uri) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Bitmap>(){

            public void call(Subscriber<? super Bitmap> subscriber) {
                try {
                    Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)uri);
                    subscriber.onNext((Object)bitmap);
                }
                catch (IOException e) {
                    Log.e((String)RxImageConverters.class.getSimpleName(), (String)"Error converting uri", (Throwable)e);
                    subscriber.onError((Throwable)e);
                }
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread());
    }
}

