/*
 * Decompiled with CFR 0.152.
 */
package com.mlsdev.rximagepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.mlsdev.rximagepicker.RxImagePicker;
import com.mlsdev.rximagepicker.Sources;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class HiddenActivity
extends Activity {
    public static String IMAGE_SOURCE = "image_source";
    private static String TAG = "RxImagePicker";
    private static final int SELECT_PHOTO = 100;
    private static final int TAKE_PHOTO = 101;
    private Uri cameraPictureUrl;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.handleIntent(this.getIntent());
        }
    }

    protected void onNewIntent(Intent intent) {
        this.handleIntent(intent);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (grantResults.length > 0 && grantResults[0] == 0) {
            this.handleIntent(this.getIntent());
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 100: {
                    RxImagePicker.with((Context)this).onImagePicked(data.getData());
                    break;
                }
                case 101: {
                    RxImagePicker.with((Context)this).onImagePicked(this.cameraPictureUrl);
                }
            }
        }
        this.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        RxImagePicker.with((Context)this).onDestroy();
    }

    private void handleIntent(Intent intent) {
        Sources sourceType = Sources.values()[intent.getIntExtra(IMAGE_SOURCE, 0)];
        int chooseCode = 0;
        Intent pictureChooseIntent = null;
        switch (sourceType) {
            case CAMERA: {
                this.cameraPictureUrl = Uri.fromFile((File)this.createImageFile());
                pictureChooseIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                pictureChooseIntent.putExtra("output", (Parcelable)this.cameraPictureUrl);
                chooseCode = 101;
                break;
            }
            case GALLERY: {
                if (!this.checkPermission()) {
                    return;
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    pictureChooseIntent = new Intent("android.intent.action.OPEN_DOCUMENT");
                    pictureChooseIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", false);
                    pictureChooseIntent.addFlags(64);
                } else {
                    pictureChooseIntent = new Intent("android.intent.action.GET_CONTENT");
                }
                pictureChooseIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
                pictureChooseIntent.addFlags(1);
                pictureChooseIntent.setType("image/*");
                chooseCode = 100;
            }
        }
        this.startActivityForResult(pictureChooseIntent, chooseCode);
    }

    private boolean checkPermission() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)0);
            return false;
        }
        return true;
    }

    private File createImageFile() {
        File imageTempFile = null;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        File storageDir = this.getExternalFilesDir(null);
        try {
            imageTempFile = File.createTempFile(timeStamp, ".jpg", storageDir);
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
        return imageTempFile;
    }

    private String getImagePath(Uri uri) {
        String result = null;
        String[] projection = new String[]{"_data"};
        Cursor cursor = this.getContentResolver().query(uri, projection, null, null, null);
        if (cursor != null) {
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            result = cursor.getString(column_index);
            cursor.close();
        }
        return result;
    }
}

