/*
 * Decompiled with CFR 0.152.
 */
package com.mlsdev.animatedrv;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import androidx.annotation.AnimRes;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.mlsdev.animatedrv.R;

public class AnimatedRecyclerView
extends RecyclerView {
    private int orientation = 1;
    private boolean reverse = false;
    private int animationDuration = 600;
    private int layoutManagerType = 0;
    private int columns = 1;
    @AnimRes
    private int animation = R.anim.layout_animation_from_bottom;
    private LayoutAnimationController animationController;

    public AnimatedRecyclerView(Context context, int orientation, boolean reverse, int animationDuration, int layoutManagerType, int columns, int animation, LayoutAnimationController animationController) {
        super(context);
        this.orientation = orientation;
        this.reverse = reverse;
        this.animationDuration = animationDuration;
        this.layoutManagerType = layoutManagerType;
        this.columns = columns;
        this.animation = animation;
        this.animationController = animationController;
        this.init(context, null);
    }

    public AnimatedRecyclerView(Context context) {
        super(context);
        this.init(context, null);
    }

    public AnimatedRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AnimatedRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    @SuppressLint(value={"Recycle", "WrongConstant"})
    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AnimatedRecyclerView, 0, 0);
        this.orientation = typedArray.getInt(R.styleable.AnimatedRecyclerView_layoutManagerOrientation, this.orientation);
        this.reverse = typedArray.getBoolean(R.styleable.AnimatedRecyclerView_layoutManagerReverse, this.reverse);
        this.animationDuration = typedArray.getInt(R.styleable.AnimatedRecyclerView_animationDuration, this.animationDuration);
        this.layoutManagerType = typedArray.getInt(R.styleable.AnimatedRecyclerView_layoutManagerType, this.layoutManagerType);
        this.columns = typedArray.getInt(R.styleable.AnimatedRecyclerView_gridLayoutManagerColumns, this.columns);
        this.animation = typedArray.getResourceId(R.styleable.AnimatedRecyclerView_layoutAnimation, -1);
        if (this.animationController == null) {
            this.animationController = this.animation != -1 ? AnimationUtils.loadLayoutAnimation((Context)this.getContext(), (int)this.animation) : AnimationUtils.loadLayoutAnimation((Context)this.getContext(), (int)R.anim.layout_animation_from_bottom);
        }
        this.animationController.getAnimation().setDuration((long)this.animationDuration);
        this.setLayoutAnimation(this.animationController);
        if (this.layoutManagerType == 0) {
            this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, this.orientation, this.reverse));
        } else if (this.layoutManagerType == 1) {
            this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, this.columns, this.orientation, this.reverse));
        }
    }

    public void notifyDataSetChanged() throws Exception {
        if (this.getAdapter() == null) {
            throw new Exception("The adapter must be set");
        }
        this.getAdapter().notifyDataSetChanged();
        this.scheduleLayoutAnimation();
    }

    public static @interface LayoutManagerType {
        public static final int LINEAR = 0;
        public static final int GRID = 1;
    }

    public static class Builder {
        private int orientation = 1;
        private boolean reverse = false;
        private int animationDuration = 600;
        private int layoutManagerType = 0;
        private int columns = 1;
        @AnimRes
        private int animation = R.anim.layout_animation_from_bottom;
        private LayoutAnimationController animationController;
        private Context context;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder orientation(int orientation) {
            this.orientation = orientation;
            return this;
        }

        public Builder reverse(boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        public Builder animationDuration(int animationDuration) {
            this.animationDuration = animationDuration;
            return this;
        }

        public Builder layoutManagerType(@LayoutManagerType int layoutManagerType) {
            this.layoutManagerType = layoutManagerType;
            return this;
        }

        public Builder columns(int columns) {
            this.columns = columns;
            return this;
        }

        public Builder animation(@AnimRes int animation) {
            this.animation = animation;
            return this;
        }

        public Builder animationController(LayoutAnimationController animationController) {
            this.animationController = animationController;
            return this;
        }

        public AnimatedRecyclerView build() {
            return new AnimatedRecyclerView(this.context, this.orientation, this.reverse, this.animationDuration, this.layoutManagerType, this.columns, this.animation, this.animationController);
        }
    }
}

