/*
 * Decompiled with CFR 0.152.
 */
package com.mks.connect;

import com.mks.connect.BlimpException;
import com.mks.connect.BlimpInputStream;
import com.mks.connect.ExpiredTokenException;
import com.mks.connect.HttpCmdRunnerImpl;
import com.mks.connect.InvalidAppException;
import com.mks.connect.InvalidSessionException;
import com.mks.connect.UserApplicationSessionImpl;
import com.mks.connect.VersionMismatchException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;

class HttpBlimpInputStream
extends BlimpInputStream {
    private HttpCmdRunnerImpl cmdRunner;
    private static final String MKS_APP_URI_PARAMETER = "&mksApp=";
    private final UserApplicationSessionImpl session;
    private URI url;
    private Map<InputStream, HttpRequestBase> requests = new HashMap<InputStream, HttpRequestBase>(1);
    private final String vendor;
    private String invocationID;

    protected HttpBlimpInputStream(HttpCmdRunnerImpl cmdRunner, String[] cmd, UserApplicationSessionImpl session, String vendor) {
        super(cmdRunner, cmd);
        this.cmdRunner = cmdRunner;
        this.session = session;
        this.vendor = vendor;
    }

    void setInvocationID(String invocationID) {
        this.invocationID = invocationID;
    }

    @Override
    protected void blimpInterrupt(String appName) throws IOException {
        try {
            URI uri = this.getSessionURI(appName);
            HttpGet request = new HttpGet(uri);
            this.setupRequest(request);
            request.addHeader(UserApplicationSessionImpl.OUT_OF_BAND_MESSAGE);
            HttpResponse response = this.session.handleHTTPResponse(request);
            EntityUtils.consume(response.getEntity());
        }
        catch (ConnectException ce) {
            this.cleanup();
        }
    }

    @Override
    public boolean isFinished() {
        return super.isFinished() || this.url == null;
    }

    private URI getSessionURI(String appName) throws IOException {
        if (this.url == null) {
            try {
                URI uri = this.cmdRunner.getSessionURI();
                this.url = new URI(uri + MKS_APP_URI_PARAMETER + appName);
            }
            catch (URISyntaxException ue) {
                throw new BlimpException(ue);
            }
        }
        return this.url;
    }

    private void invalidateURI() {
        this.cmdRunner.invalidateURI();
        this.url = null;
    }

    @Override
    protected InputStream blimpInitiate(String appName) throws IOException {
        InputStream input = null;
        HttpGet request = null;
        try {
            URI uri = this.getSessionURI(appName);
            request = new HttpGet(uri);
            try {
                this.setupRequest(request);
                HttpResponse response = this.session.handleHTTPResponse(request);
                this.checkStatusCode(response);
                input = response.getEntity().getContent();
                this.requests.put(input, request);
                return input;
            }
            catch (InvalidSessionException ise) {
                throw ise;
            }
            catch (IOException ie) {
                throw ie;
            }
        }
        catch (InvalidSessionException ise) {
            this.invalidateURI();
            if (!this.cmdRunner.getAutoReconnect()) {
                throw ise;
            }
            return this.blimpInitiate(appName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void blimpTerminate(InputStream stream) throws IOException {
        try {
            HttpBlimpInputStream httpBlimpInputStream = this;
            synchronized (httpBlimpInputStream) {
                stream.close();
            }
        }
        finally {
            HttpRequestBase request = this.requests.get(stream);
            if (request != null) {
                this.requests.remove(stream);
            }
        }
    }

    protected void setupRequest(HttpRequest request) {
        this.session.setupRequest(request, this.cmdRunner.getToken());
        request.addHeader("enableAdvancedFeatures", String.valueOf(this.generateSubRtns));
        if (this.vendor != null && !"".equals(this.vendor)) {
            request.addHeader("APIVendor", this.vendor);
        }
        if (this.invocationID != null) {
            request.addHeader("callerID", this.invocationID);
        }
    }

    @Override
    protected InputStream blimpResponse(InputStream response) throws IOException {
        InputStream input = null;
        try {
            URI uri = this.cmdRunner.getSessionURI();
            HttpPost request = new HttpPost(uri);
            this.setupRequest(request);
            request.setEntity(new InputStreamEntity(response));
            HttpResponse httpResponse = this.session.handleHTTPResponse(request);
            input = httpResponse.getEntity().getContent();
            this.checkStatusCode(httpResponse);
            this.requests.put(input, request);
            return input;
        }
        catch (ConnectException ce) {
            this.cleanup();
            throw ce;
        }
    }

    private void checkStatusCode(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode == 503) {
            this.cleanup();
            throw new InvalidAppException(MessageFormat.format("Invalid App Name: {0}", statusLine.getReasonPhrase()));
        }
        if (statusCode == 410) {
            this.cleanup();
            throw new InvalidSessionException();
        }
        if (statusCode == 412) {
            this.cleanup();
            String msg = EntityUtils.toString(response.getEntity());
            throw new VersionMismatchException(msg);
        }
        if (statusCode == 401 && this.session.isSSO()) {
            throw new ExpiredTokenException(MessageFormat.format("Invalid/Expired token: {0}", statusLine.getReasonPhrase()));
        }
        if (statusCode != 200) {
            this.cleanup();
            throw new BlimpException(MessageFormat.format("Unexpected HTTP status: {0}", statusLine.getReasonPhrase()));
        }
    }
}

