/*
 * Decompiled with CFR 0.152.
 */
package com.mks.connect;

import com.mks.api.CmdRunner;
import com.mks.api.CmdRunnerCreator;
import com.mks.api.Command;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Session;
import com.mks.api.response.APIConnectionException;
import com.mks.api.response.APIError;
import com.mks.api.response.APIException;
import com.mks.api.response.APIExceptionFactory;
import com.mks.api.response.APIWarningException;
import com.mks.api.response.CommandAlreadyRunningException;
import com.mks.api.response.IncompatibleVersionException;
import com.mks.api.response.InvalidCommandRunnerStateException;
import com.mks.api.response.Response;
import com.mks.api.response.UnsupportedApplicationException;
import com.mks.api.response.fedsso.InvalidTokenConnectFailedException;
import com.mks.api.response.fedsso.InvalidTokenExecutionIncompleteException;
import com.mks.api.response.impl.ApplicationConnectionError;
import com.mks.api.response.impl.ExpiredTokenError;
import com.mks.api.response.impl.InvalidTokenError;
import com.mks.api.response.impl.UnsupportedApplicationError;
import com.mks.api.response.impl.UnsupportedVersionError;
import com.mks.api.response.impl.XMLResponseHandler;
import com.mks.api.response.modifiable.ModifiableResponse;
import com.mks.api.util.MKSLogger;
import com.mks.connect.BlimpInputStream;
import com.mks.connect.CmdRunnerCreatorImpl;
import com.mks.connect.UserApplicationSessionImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;

public abstract class AbstractCmdRunner
implements CmdRunner {
    private static final String EXECUTE_MSG = "Executing the command : {0}";
    private static final String EXECUTION_TIME_MSG = "Total time to execute \"{0}\": {1}ms";
    protected static final String FLAG_OPTION_MSG = "Flags/Options:";
    protected static final String SELECTION_MSG = "Selection:";
    protected static final String CACHE_RESPONSE_MSG = "Setting the cacheResponse flag to : {0}";
    protected static final String COMPLETE_RESPONSE_MSG = "Setting the setCompleteResponse flag to : {0}";
    private CmdRunnerCreator session;
    private String invocationID;
    protected boolean interrupted;
    protected BlimpInputStream bis;
    protected String defaultHost;
    protected int defaultPort;
    protected String defaultUser;
    protected String defaultPass;
    protected String impUser;
    protected boolean released;
    protected Response interimResponse;
    protected MKSLogger apiLogger;
    protected volatile String token;

    protected AbstractCmdRunner(CmdRunnerCreator session) {
        this.session = session;
        this.apiLogger = IntegrationPointFactory.getLogger();
    }

    @Override
    public Session getSession() {
        return this.session instanceof Session ? (Session)this.session : null;
    }

    @Override
    public final String getInvocationID() {
        if (this.invocationID != null) {
            return this.invocationID;
        }
        Session session = this.getSession();
        return session == null ? null : session.getIntegrationID();
    }

    @Override
    public final void setInvocationID(String invocationID) {
        this.invocationID = invocationID;
    }

    protected abstract BlimpInputStream createBlimpStream(String[] var1, boolean var2, String var3);

    @Override
    public void interrupt() throws APIException {
        try {
            if (this.interimResponse != null) {
                this.interimResponse.interrupt();
                this.interimResponse = null;
            }
            if (this.bis != null) {
                this.bis.close();
            }
        }
        catch (IOException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            throw new InvalidCommandRunnerStateException(ex);
        }
    }

    protected void setInterrupted() {
        this.interrupted = true;
    }

    protected boolean isInterrupted() {
        return this.interrupted;
    }

    protected void resetInterrupt() {
        this.interrupted = false;
    }

    @Override
    public boolean isFinished() {
        return this.bis == null || this.bis.isFinished();
    }

    protected final Response executeCommand(String[] args, boolean interimResponse, boolean cacheResults, boolean generateSubRtns, String vendorName) throws APIException {
        if (this.isInterrupted() || this.released) {
            throw new InvalidCommandRunnerStateException();
        }
        if (!this.isFinished()) {
            throw new CommandAlreadyRunningException();
        }
        LinkedList<String> tmpList = new LinkedList<String>(Arrays.asList(args));
        if (args.length > 1) {
            int idx = 2;
            if (this.impUser != null) {
                tmpList.add(idx, "--impersonateuser=" + this.impUser);
            }
            if (this.getDefaultHostname() != null) {
                tmpList.add(idx, "--hostname=" + this.getDefaultHostname());
            }
            if (this.getDefaultPort() > 0) {
                tmpList.add(idx, "--port=" + this.getDefaultPort());
            }
            if (this.getDefaultUsername() != null) {
                tmpList.add(idx, "--user=" + this.getDefaultUsername());
            }
            if (this.getDefaultPassword() != null) {
                tmpList.add(idx, "--password=" + this.getDefaultPassword());
            }
        }
        String[] cmd = tmpList.toArray(new String[tmpList.size()]);
        StringBuffer cc = new StringBuffer(cmd[0]);
        for (int i = 1; i < cmd.length; ++i) {
            if (cmd[i].startsWith("--password=")) continue;
            cc.append(" ");
            cc.append(cmd[i]);
        }
        this.executePreCondition(cmd);
        long startTime = System.currentTimeMillis();
        String msg = MessageFormat.format(EXECUTE_MSG, cc);
        this.apiLogger.message(this, "API", 0, msg);
        Response response = this.executeCommand(cc, cmd, interimResponse, cacheResults, generateSubRtns, vendorName);
        long endTime = System.currentTimeMillis();
        long diffTime = endTime - startTime;
        msg = MessageFormat.format(EXECUTION_TIME_MSG, cc, new Long(diffTime));
        this.apiLogger.message(this, "API", 10, msg);
        if (!interimResponse && response.getAPIException() != null && !(response.getAPIException() instanceof APIWarningException)) {
            throw response.getAPIException();
        }
        return response;
    }

    protected void executePreCondition(String[] cmd) throws APIException {
    }

    protected Response executeCommand(StringBuffer cmdline, String[] cmd, boolean interimResponse, boolean cacheResults, boolean generateSubRtns, String vendorName) throws APIException {
        boolean cleanup = true;
        String appName = cmd[0];
        this.bis = this.createBlimpStream(cmd, generateSubRtns, vendorName);
        Response response = null;
        XMLResponseHandler xrh = new XMLResponseHandler(this.bis, "UTF-8");
        try {
            if (!interimResponse) {
                APIException ex;
                response = xrh.getResponse(null, cmdline.toString(), true);
                ((ModifiableResponse)response).setApplicationName(appName);
                if (response != null && response.getAPIException() != null && !((ex = response.getAPIException()) instanceof APIWarningException)) {
                    throw ex;
                }
            } else {
                response = xrh.getResponse(this, cmdline.toString(), false);
                ((ModifiableResponse)response).setApplicationName(appName);
                ((ModifiableResponse)response).setUseInterim(interimResponse);
                ((ModifiableResponse)response).setCacheContents(cacheResults);
                this.interimResponse = response;
            }
        }
        catch (InvalidTokenError err) {
            this.apiLogger.exception(this, "API", 0, (Throwable)err);
            InvalidTokenConnectFailedException ite = new InvalidTokenConnectFailedException(err.getMessage());
            throw ite;
        }
        catch (ExpiredTokenError err) {
            this.apiLogger.exception(this, "API", 0, (Throwable)err);
            InvalidTokenExecutionIncompleteException ete = new InvalidTokenExecutionIncompleteException(err.getMessage());
            cleanup = false;
            throw ete;
        }
        catch (ApplicationConnectionError err) {
            this.apiLogger.exception(this, "API", 0, (Throwable)err);
            APIConnectionException ace = (APIConnectionException)APIExceptionFactory.createAPIException("APIConnectionException", err.getMessage());
            throw ace;
        }
        catch (UnsupportedVersionError err) {
            this.apiLogger.exception(this, "API", 0, (Throwable)err);
            APIException ex = APIExceptionFactory.createAPIException("IncompatibleVersionException", err.getMessage());
            IncompatibleVersionException ive = (IncompatibleVersionException)ex;
            throw ive;
        }
        catch (UnsupportedApplicationError err) {
            this.apiLogger.exception(this, "API", 0, (Throwable)err);
            UnsupportedApplicationException uae = (UnsupportedApplicationException)APIExceptionFactory.createAPIException("UnsupportedApplicationException", (String)null);
            uae.addField("applicationName", appName);
            throw uae;
        }
        finally {
            if (response != null && this.session instanceof UserApplicationSessionImpl) {
                ((UserApplicationSessionImpl)this.session).setAPINegotiatedVersion(response.getAPIVersion());
            }
            try {
                if (this.interimResponse == null && this.bis != null && cleanup) {
                    this.bis.close();
                    this.bis = null;
                }
            }
            catch (IOException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            }
        }
        return response;
    }

    @Override
    public final Response executeWithInterim(String[] args, boolean cacheResults) throws APIException {
        return this.executeWithInterim(args, cacheResults, null);
    }

    @Override
    public final Response executeWithInterim(String[] args, boolean cacheResults, String vendor) throws APIException {
        return this.executeCommand(args, true, cacheResults, false, vendor);
    }

    @Override
    public final Response executeWithInterim(Command cmd, boolean cacheResults) throws APIException {
        return this.executeCommand(cmd.toStringArray(), true, cacheResults, cmd.getGenerateSubRoutines(), cmd.getVendor());
    }

    @Override
    public final Response execute(String[] args) throws APIException {
        return this.execute(args, null);
    }

    @Override
    public final Response execute(String[] args, String vendorName) throws APIException {
        return this.executeCommand(args, false, true, false, vendorName);
    }

    @Override
    public final Response execute(Command c) throws APIException {
        return this.executeCommand(c.toStringArray(), false, true, c.getGenerateSubRoutines(), c.getVendor());
    }

    @Override
    public void release() throws APIException {
        if (this.isFinished()) {
            if (this.bis != null) {
                try {
                    if (this.interimResponse != null) {
                        this.interimResponse.interrupt();
                        this.interimResponse = null;
                    }
                    if (this.bis != null) {
                        this.bis.close();
                        this.bis = null;
                    }
                }
                catch (IOException ex) {
                    this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                }
            }
            if (!this.released && this.session instanceof CmdRunnerCreatorImpl) {
                ((CmdRunnerCreatorImpl)this.session).removeCmdRunner(this);
            }
        } else {
            throw new CommandAlreadyRunningException();
        }
        this.released = true;
    }

    @Override
    public String getDefaultHostname() {
        return this.defaultHost;
    }

    @Override
    public void setDefaultHostname(String host) {
        this.defaultHost = host;
    }

    @Override
    public int getDefaultPort() {
        return this.defaultPort;
    }

    @Override
    public void setDefaultPort(int port) {
        this.defaultPort = port;
    }

    @Override
    public String getDefaultUsername() {
        return this.defaultUser;
    }

    @Override
    public void setDefaultUsername(String user) {
        this.defaultUser = user;
    }

    @Override
    public String getDefaultPassword() {
        return this.defaultPass;
    }

    @Override
    public void setDefaultPassword(String pass) {
        this.defaultPass = pass;
    }

    @Override
    public void setDefaultImpersonationUser(String impUser) {
        this.impUser = impUser;
    }

    @Override
    public String getDefaultImpersonationUser() {
        return this.impUser;
    }

    public final String executeWithXML(String[] cmd, String apiVendor) throws APIException {
        this.executePreCondition(cmd);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (this.isInterrupted() || this.released) {
            throw new InvalidCommandRunnerStateException();
        }
        if (!this.isFinished()) {
            throw new CommandAlreadyRunningException();
        }
        LinkedList<String> tmpList = new LinkedList<String>(Arrays.asList(cmd));
        if (cmd.length > 1) {
            int idx = 2;
            if (this.impUser != null) {
                tmpList.add(idx, "--impersonateuser=" + this.impUser);
            }
            if (this.getDefaultHostname() != null) {
                tmpList.add(idx, "--hostname=" + this.getDefaultHostname());
            }
            if (this.getDefaultPort() > 0) {
                tmpList.add(idx, "--port=" + this.getDefaultPort());
            }
            if (this.getDefaultUsername() != null) {
                tmpList.add(idx, "--user=" + this.getDefaultUsername());
            }
            if (this.getDefaultPassword() != null) {
                tmpList.add(idx, "--password=" + this.getDefaultPassword());
            }
        }
        String[] cmdArr = tmpList.toArray(new String[tmpList.size()]);
        String appName = cmdArr[0];
        StringBuffer cc = new StringBuffer(cmdArr[0]);
        for (int i = 1; i < cmdArr.length; ++i) {
            if (cmdArr[i].startsWith("--password=")) continue;
            cc.append(" ");
            cc.append(cmdArr[i]);
        }
        String msg = MessageFormat.format(EXECUTE_MSG, cc);
        this.apiLogger.message(this, "API", 0, msg);
        this.bis = this.createBlimpStream(cmdArr, false, apiVendor);
        try {
            byte[] arr = new byte[1024];
            int length = -1;
            while ((length = this.bis.read(arr, 0, arr.length)) != -1) {
                os.write(arr, 0, length);
            }
        }
        catch (ApplicationConnectionError err) {
            this.apiLogger.exception(this, "API", 0, (Throwable)err);
            APIConnectionException ace = (APIConnectionException)APIExceptionFactory.createAPIException("APIConnectionException", err.getMessage());
            throw ace;
        }
        catch (UnsupportedApplicationError err) {
            this.apiLogger.exception(this, "API", 0, (Throwable)err);
            UnsupportedApplicationException uae = (UnsupportedApplicationException)APIExceptionFactory.createAPIException("UnsupportedApplicationException", (String)null);
            uae.addField("applicationName", appName);
            throw uae;
        }
        catch (IOException ex) {
            throw new APIError(ex);
        }
        finally {
            try {
                this.bis.close();
                this.bis = null;
                os.flush();
            }
            catch (IOException ex) {}
        }
        try {
            return os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new APIError(ex);
        }
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }
}

