/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.util;

import com.mks.api.response.APIException;
import com.mks.api.util.InternalAPILogListener;
import com.mks.api.util.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;

public class MKSLogger {
    public static final String API_CATEGORY_PREFIX = "IntegrityAPI.logging.";
    public static final String API_LOG_FILENAME = "IntegrityAPI.log.filename";
    private Logger apiLogger;
    public static final String API = "API";
    public static final String ERROR = "ERROR";
    public static final String GENERAL = "GENERAL";
    public static final String WARNING = "WARNING";
    public static final String DEBUG = "DEBUG";
    public static final int HIGH = 0;
    public static final int MEDIUM = 5;
    public static final int LOW = 10;
    public static final int LOWEST = 20;
    public static final int OFF = -1;
    public static final int MESSAGE = 1;
    public static final int EXCEPTION = 2;
    private static final String CREATE_LOGGER_ERROR_MSG = "Cannot create the logger instance.";
    private static final String CONFIG_LOGGER_ERROR_MSG = "Cannot configure the logger instance.";
    private static final String LOG_DEFAULT_MESSAGE_FMT = "{5} -- {2}({3}): {4}\n";
    private static final String LOG_DEFAULT_EXCEPTION_FMT = "{7} -- {2}({3}): {4}: {5}\n{6}";
    private File logFile = null;

    private Writer createWriter() {
        FileWriter writer = null;
        try {
            if (this.logFile != null) {
                if (this.logFile.getParentFile() != null) {
                    this.logFile.getParentFile().mkdirs();
                }
                writer = new FileWriter(this.logFile, true);
            }
        }
        catch (IOException ex) {
            System.err.println(CREATE_LOGGER_ERROR_MSG);
            ex.printStackTrace(System.err);
        }
        return writer;
    }

    public MKSLogger(String logFile) {
        if (logFile != null) {
            File tf;
            this.logFile = tf = new File(logFile);
        }
    }

    public MKSLogger(File logFile) {
        if (logFile != null) {
            this.logFile = logFile;
        }
    }

    public void configure(Properties properties) {
        this.configure(properties, API_CATEGORY_PREFIX);
    }

    public void configure(Properties properties, String categoryPrefix) {
        try {
            if (this.apiLogger == null) {
                this.apiLogger = new Logger(false);
                this.apiLogger.addLogListener(new InternalAPILogListener(this.createWriter()));
            }
            InternalAPILogListener ll = this.getLogListener();
            ll.setDefaultMessageFormat(LOG_DEFAULT_MESSAGE_FMT);
            ll.setDefaultExceptionFormat(LOG_DEFAULT_EXCEPTION_FMT);
            ll.configure(properties, categoryPrefix);
        }
        catch (APIException ex) {
            System.err.println(CONFIG_LOGGER_ERROR_MSG);
            ex.printStackTrace(System.err);
        }
    }

    private InternalAPILogListener getLogListener() {
        InternalAPILogListener ll = this.apiLogger.getLogListeners().size() > 0 ? (InternalAPILogListener)this.apiLogger.getLogListeners().get(0) : null;
        return ll;
    }

    public void configure(String category, int type, int priority) {
        Properties properties = new Properties();
        if ((type & 1) != 0) {
            String msgCategory = "IntegrityAPI.logging.message.includeCategory." + category;
            properties.setProperty(msgCategory, String.valueOf(priority));
        }
        if ((type & 2) != 0) {
            String exCategory = "IntegrityAPI.logging.exception.includeCategory." + category;
            properties.setProperty(exCategory, String.valueOf(priority));
        }
        this.configure(properties);
    }

    public void exception(Class<?> cls, String category, int priority, Throwable ex) {
        if (this.apiLogger != null) {
            this.apiLogger.logException(cls, category, priority, ex);
        }
    }

    public void exception(Object o, String category, int priority, Throwable ex) {
        if (this.apiLogger != null) {
            this.apiLogger.logException(o, category, priority, ex);
        }
    }

    public void exception(String category, int priority, Throwable ex) {
        if (this.apiLogger != null) {
            this.apiLogger.logException(category, priority, ex);
        }
    }

    public void exception(String category, Throwable ex) {
        if (this.apiLogger != null) {
            this.apiLogger.logException(category, ex);
        }
    }

    public void exception(Throwable ex) {
        if (this.apiLogger != null) {
            this.apiLogger.logException(ex);
        }
    }

    public void message(Class<?> cls, String category, int priority, String msg) {
        if (this.apiLogger != null) {
            this.apiLogger.logMessage(cls, category, priority, msg);
        }
    }

    public void message(Object o, String category, int priority, String msg) {
        if (this.apiLogger != null) {
            this.apiLogger.logMessage(o, category, priority, msg);
        }
    }

    public void message(String category, int priority, String msg) {
        if (this.apiLogger != null) {
            this.apiLogger.logMessage(category, priority, msg);
        }
    }

    public void message(String category, String msg) {
        if (this.apiLogger != null) {
            this.apiLogger.logMessage(category, msg);
        }
    }

    public void message(String msg) {
        if (this.apiLogger != null) {
            this.apiLogger.logMessage(msg);
        }
    }

    public boolean messageCheck(String category, int level) {
        if (this.apiLogger == null) {
            return false;
        }
        return this.apiLogger.logMessageCheck(category, level);
    }

    public void stop() {
        if (this.apiLogger != null) {
            this.apiLogger.flush();
            this.apiLogger.stop();
            this.getLogListener().closeWriter();
            this.apiLogger = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.stop();
        }
        finally {
            super.finalize();
        }
    }
}

