/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.response.impl;

import com.mks.api.CmdRunner;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.common.XMLResponseDef;
import com.mks.api.response.APIException;
import com.mks.api.response.APIExceptionFactory;
import com.mks.api.response.APIInternalError;
import com.mks.api.response.Field;
import com.mks.api.response.Item;
import com.mks.api.response.Response;
import com.mks.api.response.Result;
import com.mks.api.response.SubRoutine;
import com.mks.api.response.ValueList;
import com.mks.api.response.WorkItem;
import com.mks.api.response.impl.ApplicationConnectionError;
import com.mks.api.response.impl.ExpiredTokenError;
import com.mks.api.response.impl.InvalidTokenError;
import com.mks.api.response.impl.ItemImpl;
import com.mks.api.response.impl.ModifiableXMLResponse;
import com.mks.api.response.impl.ModifiableXMLSubRoutine;
import com.mks.api.response.impl.ResponseImpl;
import com.mks.api.response.impl.UnsupportedApplicationError;
import com.mks.api.response.impl.UnsupportedVersionError;
import com.mks.api.response.impl.XMLResponseFactory;
import com.mks.api.response.modifiable.ModifiableField;
import com.mks.api.response.modifiable.ModifiableItem;
import com.mks.api.response.modifiable.ModifiableResult;
import com.mks.api.response.modifiable.ModifiableValueList;
import com.mks.api.response.modifiable.ModifiableWorkItem;
import com.mks.api.util.APIVersion;
import com.mks.api.util.Base64;
import com.mks.api.util.MKSLogger;
import com.mks.connect.ExpiredTokenException;
import com.mks.connect.InvalidAppException;
import com.mks.connect.InvalidTokenException;
import com.mks.connect.VersionMismatchException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XMLResponseHandler {
    private static final String READ_START_TAG_MSG = "Read in start tag: <{0}>";
    private static final String CREATING_RESPONSE_MSG = "Creating Response({0}, {1})";
    private static final String CREATING_WORK_ITEM_MSG = "Creating WorkItem({0}, {1}, {2})";
    private static final String CREATING_FIELD_MSG = "Creating Field({0})";
    private static final String SETTING_FIELD_VALUE_MSG = "Setting the Field value to: \"{0}\"";
    private static final String CREATING_ITEM_MSG = "Creating Item({0}, {1}, {2})";
    private static final String PARSING_VALUE_MSG = "Parsing a {0} value: {1}";
    private static final String UNKNOWN_DATA_TYPE_MSG = "Unknown value dataType: {0}";
    private static final String CREATING_LIST_MSG = "Creating a List of type: \"{0}\"";
    private static final String CREATING_RESULT_MSG = "Creating Result()";
    private static final String SETTING_RESULT_DATA_MSG = "Setting Result message value to: \"{0}\"";
    private static final String CREATING_SUB_ROUTINE_MSG = "Creating SubRoutine({0})";
    private static final String CREATING_API_EXCEPTION_MSG = "Creating APIException({0})";
    private static final String SETTING_API_EXCEPTION_DATA_MSG = "Setting APIException message value to: \"{0}\"";
    private static final String PARSING_EXIT_CODE_MSG = "Parsing exit code value: \"{0}\"";
    private static final String DOUBLE_EXCEPTION_MSG = "Trying to parse another Exception tag at the {0} level.";
    private static final String INVALID_DATA_STREAM_ERROR_MSG = "Invalid data stream received from the IntegrationPoint.";
    private ModifiableXMLResponse response;
    private XmlPullParser xpp;
    private InputStream is;
    private XMLResponseFactory responseFactory;
    private int eventType;
    private boolean readResponseConnection;
    private boolean readResponseWorkItemsSelectionType;
    private boolean readWorkItems;
    private boolean readPreSubRoutines;
    private boolean readPostSubRoutines;
    private boolean isInterrupted;
    private MKSLogger apiLogger;

    public XMLResponseHandler(InputStream is, String encoding) {
        this.is = is;
        this.responseFactory = XMLResponseFactory.getInstance();
        this.apiLogger = IntegrationPointFactory.getLogger();
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            this.xpp = factory.newPullParser();
            this.xpp.setInput(this.is, encoding);
        }
        catch (XmlPullParserException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            APIExceptionFactory.createAPIException("APIInternalError", (String)null);
        }
    }

    public Response getResponse(CmdRunner cmdRunner, String cc, boolean readCompletely) {
        while (this.eventType != 2 && this.eventType != 1) {
            try {
                this.eventType = this.xpp.next();
            }
            catch (XmlPullParserException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
            catch (InvalidAppException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                throw new UnsupportedApplicationError();
            }
            catch (VersionMismatchException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                throw new UnsupportedVersionError(ex.getMessage());
            }
            catch (InvalidTokenException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                throw new InvalidTokenError(ex.getMessage());
            }
            catch (ExpiredTokenException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                throw new ExpiredTokenError(ex.getMessage());
            }
            catch (IOException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
                throw ace;
            }
        }
        if (this.eventType == 2) {
            String tagName = this.xpp.getName();
            String msg = MessageFormat.format(READ_START_TAG_MSG, tagName);
            this.apiLogger.message(this, "API", 0, msg);
            if (tagName.equals(XMLResponseDef.XML_ROOT_TAG)) {
                String app = this.xpp.getAttributeValue(null, XMLResponseDef.XML_COMMAND_APP_ATTR);
                String command = this.xpp.getAttributeValue(null, XMLResponseDef.XML_COMMAND_ATTR);
                String version = this.xpp.getAttributeValue(null, XMLResponseDef.XML_APIVERSION_ATTR);
                String invocationID = this.xpp.getAttributeValue(null, XMLResponseDef.XML_INTEGRATIONID_ATTR);
                msg = MessageFormat.format(CREATING_RESPONSE_MSG, app, command);
                this.apiLogger.message(this, "API", 5, msg);
                this.response = this.responseFactory.createXMLResponse(cmdRunner, app, command);
                this.response.setXMLResponseHandler(this);
                this.response.setAPIVersion(new APIVersion(version));
                this.response.setInvocationID(invocationID);
                ((ResponseImpl)((Object)this.response)).setCommandString(cc);
                try {
                    this.xpp.next();
                    this.findStartTag();
                }
                catch (XmlPullParserException ex) {
                    this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                    APIExceptionFactory.createAPIException("APIInternalError", (String)null);
                }
                catch (IOException ex) {
                    this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                    ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
                    throw ace;
                }
            }
        } else {
            String msg = INVALID_DATA_STREAM_ERROR_MSG;
            APIInternalError err = new APIInternalError(msg);
            this.apiLogger.exception(this, "API", 0, (Throwable)err);
            throw err;
        }
        if (readCompletely) {
            try {
                SubRoutine sr = null;
                while ((sr = this.getSubRoutine()) != null) {
                    this.response.add(sr);
                    this.eventType = this.xpp.next();
                }
                this.readResponseConnectionAttributes();
                if (this.readResponseWorkItemsTagAttributes()) {
                    WorkItem wi = null;
                    while ((wi = this.getWorkItem()) != null) {
                        this.response.add(wi);
                        this.eventType = this.xpp.next();
                    }
                }
                this.response.setResult(this.getResult(true));
                this.response.setAPIException(this.getException());
                this.response.setExitCode(this.getExitCode());
            }
            catch (XmlPullParserException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
            catch (IOException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
                throw ace;
            }
        }
        return this.response;
    }

    protected void readResponseConnectionAttributes() {
        if (this.readResponseConnection) {
            return;
        }
        String tag = this.xpp.getName();
        if (tag != null && tag.equals(XMLResponseDef.XML_CONNECTION_TAG)) {
            this.response.setConnectionHostname(this.xpp.getAttributeValue(null, XMLResponseDef.XML_CONNECTION_HOST_ATTR));
            try {
                this.response.setConnectionPort(Integer.parseInt(this.xpp.getAttributeValue(null, XMLResponseDef.XML_CONNECTION_PORT_ATTR)));
            }
            catch (NumberFormatException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
            this.response.setConnectionUsername(this.xpp.getAttributeValue(null, XMLResponseDef.XML_CONNECTION_USER_ATTR));
            try {
                this.eventType = this.xpp.next();
                this.findStartTag();
            }
            catch (XmlPullParserException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
            catch (IOException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
                throw ace;
            }
            this.readResponseConnection = true;
            this.readPreSubRoutines = true;
        }
    }

    protected boolean readResponseWorkItemsTagAttributes() {
        if (this.readResponseWorkItemsSelectionType) {
            return true;
        }
        String tag = this.xpp.getName();
        if (tag != null && tag.equals(XMLResponseDef.XML_SELECTION_TAG)) {
            String selectionType = this.xpp.getAttributeValue(null, XMLResponseDef.XML_SELECTION_TYPE_ATTR);
            this.response.setWorkItemSelectionType(selectionType);
            try {
                this.eventType = this.xpp.next();
                this.findStartTag();
            }
            catch (XmlPullParserException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
            catch (IOException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
                throw ace;
            }
            this.readResponseWorkItemsSelectionType = true;
            this.readResponseConnection = true;
            this.readPreSubRoutines = true;
            return true;
        }
        return false;
    }

    protected WorkItem getWorkItem() {
        int et = this.findStartTag();
        String tag = this.xpp.getName();
        if (et == 1 || tag == null || !tag.equals(XMLResponseDef.XML_WORKITEM_TAG)) {
            return null;
        }
        ModifiableWorkItem workItem = null;
        try {
            String id = this.xpp.getAttributeValue(null, XMLResponseDef.XML_ID_ATTR);
            String context = this.xpp.getAttributeValue(null, XMLResponseDef.XML_CONTEXT_ATTR);
            String modelType = this.xpp.getAttributeValue(null, XMLResponseDef.XML_MODELTYPE_ATTR);
            String msg = MessageFormat.format(CREATING_WORK_ITEM_MSG, id, context, modelType);
            this.apiLogger.message(this, "API", 5, msg);
            workItem = this.responseFactory.createWorkItem(id, context, modelType);
            if (workItem instanceof ItemImpl) {
                this.addItemContextAttributes((ItemImpl)((Object)workItem));
            }
            boolean workItemExceptionRead = false;
            int eventType = Integer.MIN_VALUE;
            while (true) {
                eventType = this.xpp.next();
                String tagName = this.xpp.getName();
                if (eventType != 3 || !tagName.equals(XMLResponseDef.XML_WORKITEM_TAG)) {
                    if (eventType != 2) continue;
                    if (tagName.equals(XMLResponseDef.XML_SUBOPERATION_TAG)) {
                        workItem.add(this.getSubRoutine());
                        continue;
                    }
                    if (tagName.equals(XMLResponseDef.XML_FIELD_TAG)) {
                        workItem.add(this.getField());
                        continue;
                    }
                    if (tagName.equals(XMLResponseDef.XML_RESULT_TAG)) {
                        workItem.setResult(this.getResult(false));
                        continue;
                    }
                    if (!tagName.equals(XMLResponseDef.XML_EXCEPTION_TAG)) continue;
                    if (!workItemExceptionRead) {
                        workItem.setAPIException(this.getException());
                        workItemExceptionRead = true;
                        continue;
                    }
                    String logMsg = MessageFormat.format(DOUBLE_EXCEPTION_MSG, "WorkItem");
                    this.apiLogger.message(this, "API", 0, logMsg);
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            APIExceptionFactory.createAPIException("APIInternalError", (String)null);
        }
        catch (IOException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
            throw ace;
        }
        return workItem;
    }

    protected Field getField() {
        String tag = this.xpp.getName();
        if (tag == null || !tag.equals(XMLResponseDef.XML_FIELD_TAG)) {
            return null;
        }
        ModifiableField field = null;
        try {
            String name = this.xpp.getAttributeValue(null, XMLResponseDef.XML_NAME_ATTR);
            String displayName = this.xpp.getAttributeValue(null, XMLResponseDef.XML_DISP_NAME_ATTR);
            String msg = MessageFormat.format(CREATING_FIELD_MSG, name);
            this.apiLogger.message(this, "API", 5, msg);
            field = displayName != null ? this.responseFactory.createField(name, displayName) : this.responseFactory.createField(name);
            int eventType = Integer.MIN_VALUE;
            while (true) {
                eventType = this.xpp.next();
                String tagName = this.xpp.getName();
                if (eventType != 3 || !tagName.equals(XMLResponseDef.XML_FIELD_TAG)) {
                    if (eventType != 2) continue;
                    if (tagName.equals(XMLResponseDef.XML_VALUE_TAG)) {
                        Object[] values = this.getValue(field);
                        msg = MessageFormat.format(SETTING_FIELD_VALUE_MSG, values[0]);
                        this.apiLogger.message(this, "API", 10, msg);
                        field.setValue(values[0]);
                        if (values.length <= 1) continue;
                        field.setDisplayValue(values[1].toString());
                        continue;
                    }
                    if (tagName.equals(XMLResponseDef.XML_LIST_TAG)) {
                        field.setValue(this.getList(field));
                        continue;
                    }
                    if (!tagName.equals(XMLResponseDef.XML_SUBITEM_TAG)) continue;
                    field.setValue(this.getItem());
                    field.setDataType("com.mks.api.response.Item");
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            APIExceptionFactory.createAPIException("APIInternalError", (String)null);
        }
        catch (IOException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
            throw ace;
        }
        return field;
    }

    protected Item getItem() {
        String tag = this.xpp.getName();
        if (tag == null || !tag.equals(XMLResponseDef.XML_SUBITEM_TAG)) {
            return null;
        }
        String id = this.xpp.getAttributeValue(null, XMLResponseDef.XML_ID_ATTR);
        String context = this.xpp.getAttributeValue(null, XMLResponseDef.XML_CONTEXT_ATTR);
        String modelType = this.xpp.getAttributeValue(null, XMLResponseDef.XML_MODELTYPE_ATTR);
        String msg = MessageFormat.format(CREATING_ITEM_MSG, id, context, modelType);
        this.apiLogger.message(this, "API", 5, msg);
        ModifiableItem item = this.responseFactory.createItem(id, context, modelType);
        if (item instanceof ItemImpl) {
            this.addItemContextAttributes((ItemImpl)item);
        }
        while (true) {
            int eventType = Integer.MIN_VALUE;
            try {
                eventType = this.xpp.next();
            }
            catch (XmlPullParserException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
            catch (IOException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
                throw ace;
            }
            String tagName = this.xpp.getName();
            if (eventType == 3 && tagName.equals(XMLResponseDef.XML_SUBITEM_TAG)) break;
            if (eventType != 2 || !tagName.equals(XMLResponseDef.XML_FIELD_TAG)) continue;
            item.add(this.getField());
        }
        return item;
    }

    protected Object[] getValue(ModifiableField f) {
        Object[] objectArray;
        String tag = this.xpp.getName();
        if (tag == null || !tag.equals(XMLResponseDef.XML_VALUE_TAG)) {
            return new Object[]{null};
        }
        Object tokValObj = null;
        String dispObj = null;
        try {
            String dataType = this.xpp.getAttributeValue(null, XMLResponseDef.XML_DATATYPE_ATTR);
            String modelType = this.xpp.getAttributeValue(null, XMLResponseDef.XML_MODELTYPE_ATTR);
            String contentType = this.xpp.getAttributeValue(null, XMLResponseDef.XML_CONTENT_TYPE_ATTR);
            f.setContentType(contentType);
            int eventType = Integer.MIN_VALUE;
            String prevTag = tag;
            eventType = this.xpp.next();
            String currTag = this.xpp.getName();
            while (true) {
                if (eventType == 4) {
                    String text = this.xpp.getText();
                    eventType = this.xpp.next();
                    currTag = this.xpp.getName();
                    if (eventType == 3) {
                        if ((currTag.equals(XMLResponseDef.XML_VALUE_TAG) || currTag.equals(XMLResponseDef.XML_TOKEN_VALUE_TAG)) && prevTag.equals(currTag)) {
                            tokValObj = this.parseValue(text, dataType, modelType, f);
                        } else if (currTag.equals(XMLResponseDef.XML_DISPLAY_VALUE_TAG) && prevTag.equals(currTag)) {
                            dispObj = text;
                        }
                    }
                }
                if (!currTag.equals(XMLResponseDef.XML_VALUE_TAG)) {
                    prevTag = currTag;
                    eventType = this.xpp.next();
                    currTag = this.xpp.getName();
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            APIExceptionFactory.createAPIException("APIInternalError", (String)null);
        }
        catch (IOException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
            throw ace;
        }
        if (dispObj == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = tokValObj;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = tokValObj;
            objectArray = objectArray3;
            objectArray3[1] = dispObj;
        }
        return objectArray;
    }

    private Object parseValue(String value, String dataType, String modelType, ModifiableField f) {
        Object objValue = null;
        f.setModelType(modelType);
        String msg = MessageFormat.format(PARSING_VALUE_MSG, dataType, value);
        this.apiLogger.message(this, "API", 10, msg);
        if (dataType == null) {
            objValue = null;
        } else if (dataType.equals(XMLResponseDef.XML_DATATYPE_STRING)) {
            objValue = value;
        } else if (dataType.equals(XMLResponseDef.XML_DATATYPE_BOOLEAN)) {
            objValue = new Boolean(value);
        } else if (dataType.equals(XMLResponseDef.XML_DATATYPE_TIMESTAMP)) {
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            sdf.applyPattern("yyyy-MM-dd'T'HH:mm:ss");
            objValue = sdf.parse(value, new ParsePosition(0));
        } else if (dataType.equals(XMLResponseDef.XML_DATATYPE_DOUBLE)) {
            try {
                objValue = new Double(value);
            }
            catch (NumberFormatException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
        } else if (dataType.equals(XMLResponseDef.XML_DATATYPE_FLOAT)) {
            try {
                objValue = new Float(value);
            }
            catch (NumberFormatException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
        } else if (dataType.equals(XMLResponseDef.XML_DATATYPE_INT)) {
            try {
                objValue = new Integer(value);
            }
            catch (NumberFormatException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
        } else if (dataType.equals(XMLResponseDef.XML_DATATYPE_LONG)) {
            try {
                objValue = new Long(value);
            }
            catch (NumberFormatException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
        } else if (dataType.equals(XMLResponseDef.XML_DATATYPE_BINARY)) {
            try {
                objValue = Base64.decodeToBytes(value);
            }
            catch (Exception ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
        } else {
            msg = MessageFormat.format(UNKNOWN_DATA_TYPE_MSG, dataType);
            this.apiLogger.message(this, "API", 0, msg);
            APIExceptionFactory.createAPIException("APIInternalError", msg);
        }
        if (objValue != null) {
            f.setDataType(objValue.getClass().getName());
        } else {
            f.setDataType(null);
        }
        return objValue;
    }

    protected List getList(ModifiableField f) {
        String tag = this.xpp.getName();
        if (tag == null || !tag.equals(XMLResponseDef.XML_LIST_TAG)) {
            return null;
        }
        String type = this.xpp.getAttributeValue(null, XMLResponseDef.XML_ELEMENT_TYPE_ATTR);
        if (type == null) {
            type = "value";
        }
        String msg = MessageFormat.format(CREATING_LIST_MSG, type);
        this.apiLogger.message(this, "API", 5, msg);
        List list = null;
        list = type != null && type.equals(XMLResponseDef.XML_ITEMLIST_ATTR) ? this.responseFactory.createItemList() : this.responseFactory.createValueList();
        while (true) {
            int eventType = Integer.MIN_VALUE;
            try {
                eventType = this.xpp.next();
            }
            catch (XmlPullParserException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            }
            catch (IOException ex) {
                this.apiLogger.exception(this, "API", 0, (Throwable)ex);
                ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
                throw ace;
            }
            String tagName = this.xpp.getName();
            if (eventType == 3 && tagName.equals(XMLResponseDef.XML_LIST_TAG)) break;
            if (eventType != 2) continue;
            if (tagName.equals(XMLResponseDef.XML_VALUE_TAG)) {
                Object[] valueSet = this.getValue(f);
                Object value = valueSet[0];
                if (((ValueList)list).getDataType() == null && value != null) {
                    ((ModifiableValueList)list).setDataType(value.getClass().getName());
                }
                list.add(value);
                if (!(list instanceof ModifiableValueList) || valueSet.length <= 1) continue;
                ((ModifiableValueList)list).setDisplayValueOf(value, (String)valueSet[1]);
                continue;
            }
            if (!tagName.equals(XMLResponseDef.XML_SUBITEM_TAG)) continue;
            list.add(this.getItem());
        }
        if (type != null && type.equals(XMLResponseDef.XML_ITEMLIST_ATTR)) {
            f.setDataType("com.mks.api.response.ItemList");
        } else {
            f.setDataType("com.mks.api.response.ValueList");
        }
        return list;
    }

    protected Result getResult(boolean mainResult) {
        int et = this.findStartTag();
        String tag = this.xpp.getName();
        if (et == 1 || tag == null || !tag.equals(XMLResponseDef.XML_RESULT_TAG)) {
            return null;
        }
        this.apiLogger.message(this, "API", 5, CREATING_RESULT_MSG);
        ModifiableResult result = this.responseFactory.createResult();
        try {
            int eventType = Integer.MIN_VALUE;
            while (true) {
                eventType = this.xpp.next();
                String tagName = this.xpp.getName();
                if (eventType != 3 || !tagName.equals(XMLResponseDef.XML_RESULT_TAG)) {
                    if (eventType != 2) continue;
                    if (tagName.equals(XMLResponseDef.XML_FIELD_TAG)) {
                        result.add(this.getField());
                        continue;
                    }
                    if (!tagName.equals(XMLResponseDef.XML_MESSAGE_TAG)) continue;
                    String msg = this.xpp.nextText();
                    String logMsg = MessageFormat.format(SETTING_RESULT_DATA_MSG, msg);
                    this.apiLogger.message(this, "API", 10, logMsg);
                    result.setMessage(msg);
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            APIExceptionFactory.createAPIException("APIInternalError", (String)null);
        }
        catch (IOException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
            throw ace;
        }
        if (mainResult) {
            this.readPreSubRoutines = true;
            this.readPostSubRoutines = true;
        }
        return result;
    }

    protected SubRoutine getSubRoutine() {
        int et = this.findStartTag();
        String tag = this.xpp.getName();
        if (et == 1 || tag == null || !tag.equals(XMLResponseDef.XML_SUBOPERATION_TAG)) {
            return null;
        }
        ModifiableXMLSubRoutine subRoutine = null;
        try {
            String routine = this.xpp.getAttributeValue(null, XMLResponseDef.XML_SUBOPERATION_ATTR);
            String msg = MessageFormat.format(CREATING_SUB_ROUTINE_MSG, routine);
            this.apiLogger.message(this, "API", 5, msg);
            subRoutine = this.responseFactory.createXMLSubRoutine(routine);
            subRoutine.setXMLResponseHandler(this);
            boolean subRoutineExceptionRead = false;
            while (true) {
                int eventType = Integer.MIN_VALUE;
                eventType = this.xpp.next();
                String tagName = this.xpp.getName();
                if (eventType != 3 || !tagName.equals(XMLResponseDef.XML_SUBOPERATION_TAG)) {
                    if (eventType != 2) continue;
                    if (tagName.equals(XMLResponseDef.XML_SUBOPERATION_TAG)) {
                        subRoutine.add(this.getSubRoutine());
                        continue;
                    }
                    if (tagName.equals(XMLResponseDef.XML_SELECTION_TAG)) {
                        String selectionType = this.xpp.getAttributeValue(null, XMLResponseDef.XML_SELECTION_TYPE_ATTR);
                        subRoutine.setWorkItemSelectionType(selectionType);
                        continue;
                    }
                    if (tagName.equals(XMLResponseDef.XML_WORKITEM_TAG)) {
                        subRoutine.add(this.getWorkItem());
                        continue;
                    }
                    if (tagName.equals(XMLResponseDef.XML_RESULT_TAG)) {
                        subRoutine.setResult(this.getResult(false));
                        continue;
                    }
                    if (!tagName.equals(XMLResponseDef.XML_EXCEPTION_TAG)) continue;
                    if (!subRoutineExceptionRead) {
                        subRoutine.setAPIException(this.getException());
                        subRoutineExceptionRead = true;
                        continue;
                    }
                    String logMsg = MessageFormat.format(DOUBLE_EXCEPTION_MSG, "SubRoutine");
                    this.apiLogger.message(this, "API", 0, logMsg);
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            APIExceptionFactory.createAPIException("APIInternalError", (String)null);
        }
        catch (IOException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
            throw ace;
        }
        return subRoutine;
    }

    protected APIException getException() {
        int et = this.findStartTag();
        String tag = this.xpp.getName();
        if (et == 1 || tag == null || !tag.equals(XMLResponseDef.XML_EXCEPTION_TAG)) {
            return null;
        }
        String exName = this.xpp.getAttributeValue(null, XMLResponseDef.XML_EXCEPTIONCLASS_ATTR);
        String logMsg = MessageFormat.format(CREATING_API_EXCEPTION_MSG, exName);
        this.apiLogger.message(this, "API", 5, logMsg);
        APIException apiException = APIExceptionFactory.createAPIException(exName, this.response);
        try {
            int eventType = Integer.MIN_VALUE;
            while (true) {
                eventType = this.xpp.next();
                String tagName = this.xpp.getName();
                if (eventType != 3 || !tagName.equals(XMLResponseDef.XML_EXCEPTION_TAG)) {
                    if (eventType != 2) continue;
                    if (tagName.equals(XMLResponseDef.XML_FIELD_TAG)) {
                        apiException.add(this.getField());
                        continue;
                    }
                    if (!tagName.equals(XMLResponseDef.XML_MESSAGE_TAG)) continue;
                    String msg = this.xpp.nextText();
                    logMsg = MessageFormat.format(SETTING_API_EXCEPTION_DATA_MSG, msg);
                    this.apiLogger.message(this, "API", 10, logMsg);
                    apiException.setMessage(msg);
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            APIExceptionFactory.createAPIException("APIInternalError", (String)null);
        }
        catch (IOException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
            throw ace;
        }
        return apiException;
    }

    protected int getExitCode() {
        int et = this.findStartTag();
        int exitCode = Integer.MIN_VALUE;
        String tag = this.xpp.getName();
        if (et == 1 || tag == null || !tag.equals(XMLResponseDef.XML_EXITCODE_TAG)) {
            return exitCode;
        }
        try {
            String strExitCode = this.xpp.nextText();
            String msg = MessageFormat.format(PARSING_EXIT_CODE_MSG, strExitCode);
            this.apiLogger.message(this, "API", 10, msg);
            exitCode = Integer.parseInt(strExitCode);
            et = this.xpp.getEventType();
            while (et != 1) {
                et = this.xpp.next();
            }
        }
        catch (NumberFormatException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            APIExceptionFactory.createAPIException("APIInternalError", (String)null);
        }
        catch (XmlPullParserException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            APIExceptionFactory.createAPIException("APIInternalError", (String)null);
        }
        catch (IOException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
            throw ace;
        }
        return exitCode;
    }

    protected void interrupt() {
        if (this.isInterrupted) {
            return;
        }
        try {
            this.is.close();
            this.isInterrupted = true;
            this.readPreSubRoutines = true;
            this.readWorkItems = true;
            this.readPostSubRoutines = true;
        }
        catch (IOException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
        }
    }

    private int findStartTag() {
        if (this.isInterrupted) {
            return 1;
        }
        try {
            int et = this.xpp.getEventType();
            while (et != 2 && et != 1) {
                et = this.xpp.next();
                if (et != 3 || !this.xpp.getName().equals(XMLResponseDef.XML_SELECTION_TAG)) continue;
                this.readWorkItems = true;
            }
            return et;
        }
        catch (XmlPullParserException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            APIExceptionFactory.createAPIException("APIInternalError", (String)null);
            return 1;
        }
        catch (IOException ex) {
            this.apiLogger.exception(this, "API", 0, (Throwable)ex);
            ApplicationConnectionError ace = new ApplicationConnectionError(ex.getMessage());
            throw ace;
        }
    }

    private void addItemContextAttributes(ItemImpl item) {
        int numAttributes = this.xpp.getAttributeCount();
        for (int i = 0; i < numAttributes; ++i) {
            String attributeName = this.xpp.getAttributeName(i);
            String attributeValue = this.xpp.getAttributeValue(i);
            item.addContext(attributeName, attributeValue);
        }
    }

    protected boolean getReadPreSubRoutines() {
        return this.readPreSubRoutines;
    }

    protected boolean getReadWorkItems() {
        return this.readWorkItems;
    }

    protected boolean getReadPostSubRoutines() {
        return this.readPostSubRoutines;
    }

    protected boolean isInterrupted() {
        return this.isInterrupted;
    }
}

