/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.response.impl;

import com.mks.api.IntegrationPointFactory;
import com.mks.api.response.APIError;
import com.mks.api.response.APIException;
import com.mks.api.response.APIExceptionFactory;
import com.mks.api.response.APIInternalError;
import com.mks.api.response.InterruptedException;
import com.mks.api.response.Response;
import com.mks.api.response.Result;
import com.mks.api.response.SubRoutine;
import com.mks.api.response.SubRoutineIterator;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import com.mks.api.response.impl.InterimSubRoutineIterator;
import com.mks.api.response.impl.InterimWorkItemIterator;
import com.mks.api.response.impl.ModifiableXMLResponseContainer;
import com.mks.api.response.impl.ResponseContainer;
import com.mks.api.response.impl.XMLResponseHandler;
import java.text.MessageFormat;

class XMLResponseContainer
extends ResponseContainer
implements ModifiableXMLResponseContainer {
    private boolean haveResult;
    private boolean haveException;
    private boolean haveExitCode;
    private boolean subRoutinesPrimed;
    private boolean workItemsPrimed;
    private String wiSelectionType;
    private XMLResponseHandler xrh;
    private static final String INVALID_STATE_MSG = "Unable to retrieve {0} data at this point.";
    private static final String BAD_EXIT_CODE_ERROR_MSG = "Exit code not properly read from the stream.";

    XMLResponseContainer() {
    }

    @Override
    public void setXMLResponseHandler(XMLResponseHandler xrh) {
        this.xrh = xrh;
    }

    @Override
    public String getWorkItemSelectionType() {
        return this.wiSelectionType;
    }

    @Override
    public boolean containsSubRoutine(String name) {
        if (this.getUseInterim()) {
            if (this.getCacheContents()) {
                this.primeSubRoutineList();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return super.containsSubRoutine(name);
    }

    @Override
    public int getSubRoutineListSize() {
        if (this.getUseInterim()) {
            if (this.getCacheContents()) {
                this.primeSubRoutineList();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return super.getSubRoutineListSize();
    }

    @Override
    public SubRoutine getSubRoutine(String name) {
        if (this.getUseInterim()) {
            if (this.getCacheContents()) {
                this.primeSubRoutineList();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return super.getSubRoutine(name);
    }

    @Override
    public SubRoutineIterator getSubRoutines() {
        if (this.getUseInterim()) {
            if (this.getCacheContents()) {
                return new InterimSubRoutineIterator(this.xrh, this.subRoutineList);
            }
            if (this.xrh.getReadPreSubRoutines() && (!this.xrh.getReadWorkItems() || this.xrh.getReadPostSubRoutines())) {
                String msg = MessageFormat.format(INVALID_STATE_MSG, "SubRoutine");
                APIExceptionFactory.createAPIException("APIError", msg);
            }
            return new InterimSubRoutineIterator(this.xrh, null);
        }
        return super.getSubRoutines();
    }

    @Override
    public String getConnectionHostname() {
        if (this.getUseInterim()) {
            this.primeConnectionAttributes();
        }
        return super.getConnectionHostname();
    }

    @Override
    public int getConnectionPort() {
        if (this.getUseInterim()) {
            this.primeConnectionAttributes();
        }
        return super.getConnectionPort();
    }

    @Override
    public String getConnectionUsername() {
        if (this.getUseInterim()) {
            this.primeConnectionAttributes();
        }
        return super.getConnectionUsername();
    }

    @Override
    public WorkItemIterator getWorkItems() {
        if (this.getUseInterim()) {
            this.primeConnectionAttributes();
            if (this.getCacheContents()) {
                return new InterimWorkItemIterator(this.xrh, this.workItemList);
            }
            if (this.xrh.getReadWorkItems()) {
                String msg = MessageFormat.format(INVALID_STATE_MSG, "WorkItem");
                APIExceptionFactory.createAPIException("APIError", msg);
            }
            return new InterimWorkItemIterator(this.xrh, null);
        }
        return super.getWorkItems();
    }

    @Override
    public int getWorkItemListSize() {
        if (this.getUseInterim()) {
            if (this.getCacheContents()) {
                this.primeWorkItemList();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return super.getWorkItemListSize();
    }

    @Override
    public WorkItem getWorkItem(String id, String context) {
        if (this.getUseInterim()) {
            if (this.getCacheContents()) {
                this.primeWorkItemList();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return super.getWorkItem(id, context);
    }

    @Override
    public WorkItem getWorkItem(String id) {
        if (this.getUseInterim()) {
            if (this.getCacheContents()) {
                this.primeWorkItemList();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        return super.getWorkItem(id);
    }

    @Override
    public boolean containsWorkItem(String id) {
        if (this.getUseInterim()) {
            if (this.getCacheContents()) {
                this.primeWorkItemList();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return super.containsWorkItem(id);
        }
        catch (APIInternalError err) {
            IntegrationPointFactory.getLogger().exception(this, "API", 0, (Throwable)err);
            return false;
        }
    }

    @Override
    public boolean containsWorkItem(String id, String context) {
        if (this.getUseInterim()) {
            if (this.getCacheContents()) {
                this.primeWorkItemList();
            }
            throw new UnsupportedOperationException();
        }
        try {
            return super.containsWorkItem(id, context);
        }
        catch (APIInternalError err) {
            IntegrationPointFactory.getLogger().exception(this, "API", 0, (Throwable)err);
            return false;
        }
    }

    @Override
    public APIException getAPIException() throws InterruptedException {
        if (this.getUseInterim() && !this.haveException) {
            if (this.xrh.isInterrupted()) {
                APIException ex = APIExceptionFactory.createAPIException("InterruptedException", (Response)null);
                throw (InterruptedException)ex;
            }
            this.primeLists();
            this.getResult();
            this.setAPIException(this.xrh.getException());
            this.haveException = true;
        }
        return super.getAPIException();
    }

    @Override
    public Result getResult() throws InterruptedException {
        if (this.getUseInterim() && !this.haveResult) {
            if (this.xrh.isInterrupted()) {
                APIException ex = APIExceptionFactory.createAPIException("InterruptedException", (Response)null);
                throw (InterruptedException)ex;
            }
            this.primeLists();
            this.setResult(this.xrh.getResult(true));
            this.haveResult = true;
        }
        return super.getResult();
    }

    @Override
    public int getExitCode() throws InterruptedException {
        int exitCode;
        if (this.getUseInterim() && !this.haveExitCode) {
            if (this.xrh.isInterrupted()) {
                APIException ex = APIExceptionFactory.createAPIException("InterruptedException", (Response)null);
                throw (InterruptedException)ex;
            }
            this.primeLists();
            this.getResult();
            this.getAPIException();
            this.setExitCode(this.xrh.getExitCode());
            this.haveExitCode = true;
        }
        if ((exitCode = super.getExitCode()) == Integer.MIN_VALUE) {
            String msg = BAD_EXIT_CODE_ERROR_MSG;
            APIExceptionFactory.createAPIException("APIInternalError", msg);
        }
        return exitCode;
    }

    public void interrupt() {
        this.xrh.interrupt();
    }

    private void primeSubRoutineList() {
        if (!this.subRoutinesPrimed) {
            SubRoutineIterator it = this.getSubRoutines();
            while (it.hasNext()) {
                try {
                    it.next();
                }
                catch (APIException ex) {
                    IntegrationPointFactory.getLogger().exception(this, "API", 0, (Throwable)ex);
                }
            }
            this.subRoutinesPrimed = true;
        }
    }

    private void primeConnectionAttributes() {
        if (!this.subRoutinesPrimed && !this.xrh.getReadPreSubRoutines()) {
            this.primeSubRoutineList();
        }
        this.xrh.readResponseConnectionAttributes();
    }

    private void primeWorkItemList() {
        if (!this.workItemsPrimed) {
            WorkItemIterator it = this.getWorkItems();
            while (it.hasNext()) {
                try {
                    it.next();
                }
                catch (APIException ex) {
                    IntegrationPointFactory.getLogger().exception(this, "API", 0, (Throwable)ex);
                }
            }
            this.workItemsPrimed = true;
        }
    }

    private void primeLists() {
        block8: {
            block7: {
                block6: {
                    try {
                        this.primeSubRoutineList();
                    }
                    catch (APIError err) {
                        if (!this.getCacheContents()) break block6;
                        throw err;
                    }
                }
                try {
                    this.primeWorkItemList();
                }
                catch (APIError err) {
                    if (!this.getCacheContents()) break block7;
                    throw err;
                }
            }
            try {
                this.primeSubRoutineList();
            }
            catch (APIError err) {
                if (!this.getCacheContents()) break block8;
                throw err;
            }
        }
    }
}

