/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands.ide;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.Option;
import com.mks.api.OptionList;
import com.mks.api.Session;
import com.mks.api.commands.SICommands;
import com.mks.api.commands.ide.SandboxInfo;
import com.mks.api.commands.ide.WorkingDirectory;
import com.mks.api.commands.ide.WorkingDirectoryFactory;
import com.mks.api.commands.ide.WorkingFile;
import com.mks.api.commands.ide.WorkingFileCache;
import com.mks.api.commands.ide.WorkingFileList;
import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.InvalidCommandSelectionException;
import com.mks.api.response.InvalidItemException;
import com.mks.api.response.Item;
import com.mks.api.response.ItemNotFoundException;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class WorkingFileFactory {
    private static final String VIEWSANDBOX_FIELDS = "context,memberrev,workingrev,lockrecord,newrevdelta,revsyncdelta,wfdelta,workingcpid,locker,deferred,hasMergeConflict";
    private static long ordinal = 0L;

    private WorkingFileFactory() {
    }

    private static WorkingFileCache getWorkingFileCache(SICommands si) {
        boolean retainedCache = !(si.getCmdRunnerCreator() instanceof Session);
        return WorkingFileCache.getInstance(retainedCache);
    }

    public static WorkingFile getWorkingFile(CmdRunnerCreator session, File fileName, boolean register) {
        ArrayList<File> files = new ArrayList<File>(1);
        files.add(fileName);
        return WorkingFileFactory.getWorkingFiles(session, files, register).getList().get(0);
    }

    public static WorkingFileList getWorkingFiles(CmdRunnerCreator session, List<File> files, boolean register) {
        return WorkingFileFactory.getWorkingFiles(session, files, false, register);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkingFileList getWorkingFiles(CmdRunnerCreator session, List<File> files, boolean refresh, boolean register) {
        WorkingFileList wfs;
        WorkingFileCache wfCache = null;
        try {
            SICommands si = new SICommands(session, false);
            wfCache = WorkingFileFactory.getWorkingFileCache(si);
            wfCache.beginCacheGetTopLevelSandbox(session);
            if (refresh) {
                Iterator<File> it = files.iterator();
                while (it.hasNext()) {
                    wfCache.removeWorkingFile(it.next());
                }
            }
            wfs = WorkingFileFactory.getWorkingFiles(si, wfCache, files, register);
        }
        catch (APIException apix) {
            wfs = WorkingFileFactory.invalidate(files, new Date());
        }
        finally {
            if (wfCache != null) {
                wfCache.endCacheGetTopLevelSandbox(session);
            }
        }
        return wfs;
    }

    public static WorkingFileList refreshWorkingFiles(CmdRunnerCreator session, List<File> files, boolean register) {
        return WorkingFileFactory.getWorkingFiles(session, files, true, register);
    }

    public static void flushCache(CmdRunnerCreator session) throws APIException {
        SICommands si = new SICommands(session, false);
        WorkingFileCache wfCache = WorkingFileFactory.getWorkingFileCache(si);
        wfCache.removeSandboxesForSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkingFileList getWorkingFiles(SICommands si, List<File> files, boolean register) {
        WorkingFileCache wfCache = null;
        try {
            wfCache = WorkingFileFactory.getWorkingFileCache(si);
            wfCache.beginCacheGetTopLevelSandbox(si.getCmdRunnerCreator());
            WorkingFileList workingFileList = WorkingFileFactory.getWorkingFiles(si, wfCache, files, register);
            return workingFileList;
        }
        finally {
            if (wfCache != null) {
                wfCache.endCacheGetTopLevelSandbox(si.getCmdRunnerCreator());
            }
        }
    }

    public static List<WorkingFile> getWorkingFilesForSandboxes(SICommands si, List<File> sandboxes) {
        WorkingFileCache wfCache = WorkingFileFactory.getWorkingFileCache(si);
        return wfCache.getWorkingFilesForSandboxes(sandboxes).getList();
    }

    public static synchronized long getNewOrdinal() {
        return ordinal++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkingFileList getWorkingFiles(SICommands si, WorkingFileCache wfCache, List<File> fileList, boolean register) {
        String userId;
        WorkItem wi;
        int i;
        Date timestamp = new Date();
        long ordinal = WorkingFileFactory.getNewOrdinal();
        HashMap<File, WorkingDirectory> dirMap = new HashMap<File, WorkingDirectory>();
        HashMap<File, Collection<File>> sandboxContentMap = new HashMap<File, Collection<File>>();
        HashMap<WorkingRoot, List<File>> sandboxBuckets = new HashMap<WorkingRoot, List<File>>();
        HashMap<File, Integer> indexMap = new HashMap<File, Integer>();
        ArrayList<WorkingFile> deferredMoves = new ArrayList<WorkingFile>();
        ArrayList<File> locations = new ArrayList<File>();
        Object[] fileObjects = fileList.toArray();
        File[] files = new File[fileObjects.length];
        WorkingFile[] wfArray = new WorkingFile[fileObjects.length];
        for (i = 0; i < fileObjects.length; ++i) {
            File currLocation = (File)fileObjects[i];
            if (!currLocation.isDirectory()) {
                currLocation = currLocation.getParentFile();
            }
            boolean found = false;
            for (File location : new ArrayList(locations)) {
                if (location.getAbsolutePath().equals(currLocation.getAbsolutePath()) || currLocation.getAbsolutePath().startsWith(location.getAbsolutePath())) {
                    found = true;
                    break;
                }
                if (!location.getAbsolutePath().startsWith(currLocation.getAbsolutePath())) continue;
                locations.remove(location);
                locations.add(currLocation);
                found = true;
                break;
            }
            if (found) continue;
            locations.add(currLocation);
        }
        for (i = 0; i < fileObjects.length; ++i) {
            WorkingRoot workingRoot;
            files[i] = (File)fileObjects[i];
            indexMap.put(files[i], new Integer(i));
            WorkingFile wf = wfCache.getWorkingFile(files[i]);
            if (wf != null) {
                wfArray[i] = wf;
                if (!wf.isInvalid()) {
                    continue;
                }
            } else {
                wf = new WorkingFile(files[i], null, timestamp, ordinal);
                wf.invalidate();
                wfArray[i] = wf;
                wfCache.addWorkingFile(si.getCmdRunnerCreator(), wf, register);
            }
            try {
                workingRoot = WorkingFileFactory.getWorkingRoot(si, files[i], dirMap, locations, sandboxContentMap, register);
            }
            catch (APIException apix) {
                if ("si.NoSuchSubproject".equals(apix.getExceptionId())) {
                    wfArray[i].markFormer();
                    continue;
                }
                wfArray[i] = new WorkingFile(files[i], apix, timestamp, ordinal);
                continue;
            }
            if (workingRoot == null) {
                wfArray[i] = new WorkingFile(files[i], null, timestamp, ordinal);
                wfCache.addWorkingFile(si.getCmdRunnerCreator(), wfArray[i], register);
                continue;
            }
            WorkingFileFactory.addToSbxBucket(workingRoot, files[i], sandboxBuckets);
        }
        Iterator workingRoots = sandboxBuckets.keySet().iterator();
        while (workingRoots != null && workingRoots.hasNext()) {
            WorkItemIterator wis;
            WorkingRoot workingRoot = (WorkingRoot)workingRoots.next();
            List sbxFiles = (List)sandboxBuckets.get(workingRoot);
            ArrayList<File> diffFiles = new ArrayList<File>();
            boolean potentialDeferredRename = false;
            Response sbxView = null;
            sbxView = WorkingFileFactory.viewSandbox(si, workingRoot.getRoot(), sbxFiles, null);
            if (sbxView != null) {
                try {
                    wis = sbxView.getWorkItems();
                    String userId2 = sbxView.getConnectionUsername();
                    Iterator fileIterator = sbxFiles.iterator();
                    while (fileIterator.hasNext() && wis.hasNext()) {
                        WorkingFile wf;
                        File file = (File)fileIterator.next();
                        SandboxInfo sandboxInfo = null;
                        int index = (Integer)indexMap.get(file);
                        try {
                            sandboxInfo = WorkingFileFactory.getWorkingSandbox(si, file, dirMap, sandboxContentMap, register);
                            WorkItem wi2 = wis.next();
                            wfArray[index] = wf = new WorkingFile(file, sandboxInfo, workingRoot, wi2, timestamp, userId2, ordinal);
                            if (wf.isMovedOrRenamed()) {
                                potentialDeferredRename = true;
                                if (indexMap.containsKey(wf.getFile())) continue;
                                indexMap.put(wf.getFile(), new Integer(index));
                                files[index] = wf.getFile();
                                continue;
                            }
                            if (!wf.hasWorkingDelta() || wf.isModified() || workingRoot.isComputeChecksums()) continue;
                            diffFiles.add(file);
                        }
                        catch (InvalidCommandSelectionException icse) {
                            wf = file.equals(sandboxInfo.getSandboxFile()) ? new WorkingFile(sandboxInfo, workingRoot, timestamp, ordinal) : new WorkingFile(file, icse, timestamp, ordinal);
                            wfArray[index] = wf;
                        }
                        catch (ItemNotFoundException infx) {
                            if (sandboxInfo == null) {
                                wf = new WorkingFile(file, infx, timestamp, ordinal);
                            } else if (file.equals(sandboxInfo.getSandboxFile())) {
                                wf = new WorkingFile(sandboxInfo, workingRoot, timestamp, ordinal);
                            } else {
                                wi = wis.getLast();
                                WorkingRoot nonMemberRoot = null;
                                try {
                                    WorkingDirectory wd = WorkingFileFactory.getWorkingDirectory(si, workingRoot.getRoot(), dirMap, register);
                                    if (wd.isSandboxAware() && !wd.isAmbiguous()) {
                                        nonMemberRoot = workingRoot;
                                    }
                                }
                                catch (APIException ignored) {
                                    // empty catch block
                                }
                                wf = new WorkingFile(file, sandboxInfo, nonMemberRoot, wi, timestamp, userId2, ordinal);
                                if (!wf.isFormerMember()) {
                                    potentialDeferredRename = true;
                                }
                            }
                            wfArray[index] = wf;
                        }
                        catch (APIException apix) {
                            wfArray[index] = new WorkingFile(file, apix, timestamp, ordinal);
                        }
                    }
                }
                finally {
                    try {
                        sbxView.release();
                    }
                    catch (APIException ignored) {}
                }
            }
            if (potentialDeferredRename) {
                OptionList options = new OptionList();
                options.add(new Option("filterSubs"));
                options.add("filter", "deferred:move,deferred:rename");
                options.add(new Option("recurse"));
                sbxView = WorkingFileFactory.viewSandbox(si, workingRoot.getRoot(), null, options);
                if (sbxView != null) {
                    try {
                        userId = sbxView.getConnectionUsername();
                        wis = sbxView.getWorkItems();
                        while (wis.hasNext()) {
                            try {
                                Integer indexMarker;
                                SandboxInfo sandboxInfo;
                                WorkingFile wf;
                                String fileName;
                                WorkItem wi3 = wis.next();
                                if (wi3.getModelType() == null) continue;
                                boolean isDestinedMember = wi3.getModelType().equals("si.DestinedMember");
                                boolean isMember = wi3.getModelType().equals("si.Member");
                                if (!isDestinedMember && !isMember || (fileName = wi3.getField("name").getString()) == null) continue;
                                File file = new File(fileName);
                                WorkingRoot myWorkingRoot = workingRoot;
                                if (isDestinedMember) {
                                    File canonicalSandbox = new File(wi3.getField("canonicalSandbox").getString());
                                    myWorkingRoot = WorkingFileFactory.getWorkingRoot(si, canonicalSandbox, dirMap, locations, sandboxContentMap, register);
                                }
                                if (!(wf = new WorkingFile(file, sandboxInfo = WorkingFileFactory.getWorkingSandbox(si, file, dirMap, sandboxContentMap, register), myWorkingRoot, wi3, timestamp, userId, ordinal)).isMovedOrRenamed() || (indexMarker = (Integer)indexMap.get(file)) == null) continue;
                                int index = indexMarker;
                                if (wfArray[index].isModified()) {
                                    wf.markModified();
                                }
                                if (wf.hasWorkingDelta() && !wf.isModified() && !workingRoot.isComputeChecksums()) {
                                    diffFiles.add(wf.getFile());
                                }
                                wfArray[index] = wf;
                                if (!isDestinedMember || !wf.isMoved()) continue;
                                deferredMoves.add(wf);
                            }
                            catch (APIException apix) {}
                        }
                    }
                    finally {
                        try {
                            sbxView.release();
                        }
                        catch (APIException ignored) {}
                    }
                }
            }
            WorkingFileFactory.setDeltasForDiffFiles(diffFiles, si, workingRoot, indexMap, wfArray);
        }
        WorkingFileList deferredMoveWFList = new WorkingFileList();
        Iterator mv = deferredMoves.iterator();
        while (mv.hasNext()) {
            deferredMoveWFList.add((WorkingFile)mv.next());
        }
        Map<File, WorkingFileList> deferredMoveSandboxBuckets = deferredMoveWFList.getWorkingFileBuckets(register);
        Iterator<File> deferredMoveSandboxes = deferredMoveSandboxBuckets.keySet().iterator();
        while (deferredMoveSandboxes.hasNext()) {
            WorkingRoot workingRoot = new WorkingRoot(deferredMoveSandboxes.next(), false);
            WorkingFileList sbxWorkingFiles = deferredMoveSandboxBuckets.get(workingRoot.getRoot());
            ArrayList<File> diffFiles = new ArrayList<File>();
            Response sbxView = null;
            sbxView = WorkingFileFactory.viewSandbox(si, workingRoot.getRoot(), sbxWorkingFiles.getMemberList(), null);
            if (sbxView == null) continue;
            try {
                userId = sbxView.getConnectionUsername();
                WorkItemIterator wis = sbxView.getWorkItems();
                Iterator<WorkingFile> workingFileIterator = sbxWorkingFiles.iterator();
                while (workingFileIterator.hasNext() && wis.hasNext()) {
                    WorkingFile movedWorkingFile = workingFileIterator.next();
                    int index = (Integer)indexMap.get(movedWorkingFile.getFile());
                    try {
                        wi = wis.next();
                        WorkingFile wf = new WorkingFile(movedWorkingFile.getFile(), movedWorkingFile.getSandboxInfo(), workingRoot, wi, timestamp, userId, ordinal);
                        if (wfArray[index].isModified()) {
                            wf.markModified();
                        }
                        if (wf.hasWorkingDelta() && !wf.isModified() && !workingRoot.isComputeChecksums()) {
                            diffFiles.add(wf.getFile());
                        }
                        wfArray[index] = wf;
                    }
                    catch (APIException apix) {
                        wfArray[index] = new WorkingFile(movedWorkingFile.getFile(), apix, timestamp, ordinal);
                    }
                }
            }
            finally {
                WorkingFileFactory.setDeltasForDiffFiles(diffFiles, si, workingRoot, indexMap, wfArray);
                try {
                    sbxView.release();
                }
                catch (APIException ignored) {}
            }
        }
        for (int i2 = 0; i2 < wfArray.length; ++i2) {
            if (wfArray[i2] == null) {
                wfArray[i2] = new WorkingFile(files[i2], new InvalidItemException(), timestamp, ordinal);
            }
            try {
                if (!wfArray[i2].isInvalid() && register) {
                    wfCache.monitorSandbox(si.getCmdRunnerCreator(), wfArray[i2].getSandboxFile());
                }
            }
            catch (APIException e) {
                // empty catch block
            }
            wfCache.addWorkingFile(si.getCmdRunnerCreator(), wfArray[i2], register);
            WorkingFile cachedWF = wfCache.getWorkingFile(wfArray[i2].getFile());
            if (cachedWF == null || cachedWF.isInvalid()) continue;
            wfArray[i2] = cachedWF;
        }
        WorkingFileList list = new WorkingFileList(wfArray);
        return list;
    }

    private static File getLocation(File filePath) {
        if (!filePath.isAbsolute()) {
            filePath = filePath.getAbsoluteFile();
        }
        if (!filePath.isDirectory()) {
            filePath = filePath.getParentFile();
        }
        return filePath;
    }

    private static WorkingRoot getWorkingRoot(SICommands si, File element, Map<File, WorkingDirectory> dirMap, List<File> locations, Map<File, Collection<File>> sandboxContentMap, boolean register) throws APIException {
        WorkingRoot workingRoot = null;
        WorkingDirectory wd = WorkingFileFactory.getWorkingDirectory(si, element, dirMap, register);
        if (!wd.isSandboxAware()) {
            workingRoot = null;
        } else if (!wd.isAmbiguous()) {
            SandboxInfo sandbox = wd.getSandboxes().iterator().next();
            if (locations.contains(sandbox.getSandboxFile().getParentFile())) {
                return new WorkingRoot(sandbox.getSandboxLocation(), sandbox.isComputeChecksums());
            }
            String parent = sandbox.getParentName();
            if (parent != null && !(workingRoot = WorkingFileFactory.getWorkingRoot(si, new File(parent), dirMap, locations, sandboxContentMap, register)).getRoot().isDirectory()) {
                parent = null;
            }
            if (parent == null) {
                workingRoot = new WorkingRoot(sandbox.getSandboxLocation(), sandbox.isComputeChecksums());
            }
        } else {
            SandboxInfo sandbox = WorkingFileFactory.getWorkingSandbox(si, element, dirMap, sandboxContentMap, register);
            workingRoot = new WorkingRoot(sandbox.getSandboxFile(), sandbox.isComputeChecksums());
        }
        return workingRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SandboxInfo getWorkingSandbox(SICommands si, File element, Map<File, WorkingDirectory> dirMap, Map<File, Collection<File>> sandboxContentMap, boolean register) throws APIException {
        WorkingDirectory wd = WorkingFileFactory.getWorkingDirectory(si, element, dirMap, register);
        SandboxInfo sandbox = null;
        if (!wd.isSandboxAware()) {
            return null;
        }
        if (!wd.isAmbiguous()) {
            sandbox = wd.getSandboxes().iterator().next();
            return sandbox;
        }
        File sandboxFile = null;
        Iterator<SandboxInfo> sbxs = wd.getSandboxes().iterator();
        while (sbxs.hasNext() && !(sandboxFile = (sandbox = sbxs.next()).getSandboxFile()).equals(element)) {
            Collection<File> content = sandboxContentMap.get(sandboxFile);
            if (content == null) {
                Response sbxView = WorkingFileFactory.viewSandbox(si, sandboxFile, null, null);
                content = new HashSet<File>();
                if (sbxView != null) {
                    try {
                        WorkItemIterator i = sbxView.getWorkItems();
                        while (i.hasNext()) {
                            WorkItem wi = null;
                            try {
                                wi = i.next();
                            }
                            catch (APIException ignored) {
                                wi = i.getLast();
                            }
                            File wiFile = new File(wi.getId());
                            if (!wiFile.isAbsolute()) {
                                wiFile = new File(sandboxFile.getParentFile(), wi.getId());
                            }
                            content.add(wiFile);
                        }
                        if (sbxView.getAPIException() != null) {
                            throw sbxView.getAPIException();
                        }
                    }
                    finally {
                        try {
                            sbxView.release();
                        }
                        catch (APIException ignored) {}
                    }
                }
                sandboxContentMap.put(sandboxFile, content);
            }
            if (!content.contains(element)) continue;
            break;
        }
        return sandbox;
    }

    private static WorkingDirectory getWorkingDirectory(SICommands si, File element, Map<File, WorkingDirectory> dirMap, boolean register) throws APIException {
        WorkingDirectory wd = null;
        File path = WorkingFileFactory.getLocation(element);
        if (dirMap.containsKey(path)) {
            wd = dirMap.get(path);
        }
        if (wd == null) {
            wd = WorkingDirectoryFactory.getWorkingDirectory(si.getCmdRunnerCreator(), path, register);
            dirMap.put(path, wd);
        }
        return wd;
    }

    private static void addToSbxBucket(WorkingRoot root, File file, Map<WorkingRoot, List<File>> sandboxBuckets) {
        List<Object> bucket = null;
        if (sandboxBuckets.containsKey(root)) {
            bucket = sandboxBuckets.get(root);
            bucket.add(file);
        } else {
            bucket = new ArrayList();
            bucket.add(file);
            sandboxBuckets.put(root, bucket);
        }
    }

    private static String[] memberNames(Collection<File> members) {
        String[] memberNames;
        if (members == null) {
            memberNames = null;
        } else {
            memberNames = new String[members.size()];
            Iterator<File> i = members.iterator();
            int j = 0;
            while (i.hasNext()) {
                File member = i.next();
                memberNames[j] = member.getAbsolutePath();
                ++j;
            }
        }
        return memberNames;
    }

    private static Response viewSandbox(SICommands si, File sandboxRoot, List<File> members, OptionList options) {
        Response r;
        File sandboxDir = WorkingFileFactory.getLocation(sandboxRoot);
        OptionList viewOptions = new OptionList();
        viewOptions.add(new Option("fields", VIEWSANDBOX_FIELDS));
        viewOptions.add(new Option("norecurse"));
        if (!sandboxRoot.isDirectory()) {
            viewOptions.add(new Option("sandbox", sandboxRoot.getAbsolutePath()));
        }
        if (options != null) {
            Iterator it = options.getOptions();
            while (it.hasNext()) {
                viewOptions.add((Option)it.next());
            }
        }
        try {
            String cwdPath = sandboxDir.getAbsolutePath();
            r = si.getSandboxMemberStatus(cwdPath, WorkingFileFactory.memberNames(members), viewOptions, true);
        }
        catch (APIException apix) {
            r = apix.getResponse();
        }
        return r;
    }

    private static Response diffStatus(SICommands si, File workingRoot, List<File> members) {
        Response r;
        try {
            OptionList options = null;
            String cwdPath = null;
            if (workingRoot != null) {
                cwdPath = WorkingFileFactory.getLocation(workingRoot).getAbsolutePath();
                if (!workingRoot.isDirectory()) {
                    options = new OptionList();
                    options.add(new Option("sandbox", workingRoot.getAbsolutePath()));
                }
            }
            r = si.getSandboxMemberDifferenceStatus(cwdPath, WorkingFileFactory.memberNames(members), options);
        }
        catch (APIException apix) {
            r = apix.getResponse();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDeltasForDiffFiles(List<File> diffFiles, SICommands si, WorkingRoot workingRoot, Map<File, Integer> indexMap, WorkingFile[] wfArray) {
        if (!diffFiles.isEmpty()) {
            Response diff = WorkingFileFactory.diffStatus(si, workingRoot.getRoot(), diffFiles);
            try {
                WorkItemIterator wis = diff != null ? diff.getWorkItems() : null;
                for (File file : diffFiles) {
                    int index = indexMap.get(file);
                    boolean modified = true;
                    if (wis != null) {
                        try {
                            WorkItem wi = wis.next();
                            Item result = wi.getResult().getPrimaryValue();
                            Field status = result.getField("different");
                            modified = status.getBoolean();
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                    }
                    if (!modified) continue;
                    wfArray[index].markModified();
                }
            }
            finally {
                try {
                    if (diff != null) {
                        diff.release();
                    }
                }
                catch (APIException ignored) {}
            }
        }
    }

    private static WorkingFileList invalidate(List<File> files, Date timestamp) {
        WorkingFile[] wfArray = new WorkingFile[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            wfArray[i] = new WorkingFile(files.get(i), new InvalidItemException(), timestamp, WorkingFileFactory.getNewOrdinal());
        }
        return new WorkingFileList(wfArray);
    }

    static boolean isWin32() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    static class WorkingRoot {
        private File root = null;
        private boolean computeChecksums = false;

        WorkingRoot(File root, boolean computeChecksums) {
            if (root == null) {
                throw new IllegalArgumentException();
            }
            this.root = root;
            this.computeChecksums = computeChecksums;
        }

        public File getRoot() {
            return this.root;
        }

        public boolean isComputeChecksums() {
            return this.computeChecksums;
        }

        public int hashCode() {
            return this.root.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof WorkingRoot)) {
                return false;
            }
            return this.root.equals(((WorkingRoot)obj).root);
        }
    }
}

