/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands.ide;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.commands.SICommands;
import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.InvalidCommandOptionException;
import com.mks.api.response.Item;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import com.mks.api.response.impl.SimpleResponseFactory;
import com.mks.api.response.modifiable.ModifiableField;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class SandboxInfo
implements Item {
    public static final String VARIANT_SANDBOX = "variant";
    public static final String BUILD_SANDBOX = "build";
    public static final String NORMAL_SANDBOX = "normal";
    public static final String SANDBOX_FIELD = "sandboxName";
    public static final String PARENT_FIELD = "sandboxParent";
    public static final String HOST_FIELD = "server";
    public static final String PORT_FIELD = "serverPort";
    public static final String PROJECT_FIELD = "projectName";
    public static final String REFERRED_PROJECT_FIELD = "referredProjectName";
    public static final String NORMAL_FIELD = "isNormal";
    public static final String VARIANT_FIELD = "isVariant";
    public static final String BUILD_FIELD = "isBuild";
    public static final String DEV_PATH_FIELD = "developmentPath";
    public static final String BUILD_REVISION_FIELD = "buildRevision";
    public static final String PENDING_FIELD = "isPending";
    public static final String SUB_SANDBOX_FIELD = "isSubsandbox";
    public static final String CONFIG_PATH_FIELD = "fullConfigSyntax";
    public static final String COMPUTE_CHECKSUMS_FIELD = "computeChecksums";
    public static final String IS_SHARED_FIELD = "isReferenced";
    private static final String[] fields = new String[]{"sandboxName", "sandboxParent", "server", "serverPort", "projectName", "isNormal", "isVariant", "isBuild", "developmentPath", "buildRevision", "isPending", "isSubsandbox", "fullConfigSyntax", "referredProjectName", "computeChecksums", "isReferenced"};
    private final String typeInfo;
    private final boolean isVariant;
    private final boolean isBuild;
    private final boolean isNormal;
    private final File sandboxName;
    private final String host;
    private final String port;
    private final String projectName;
    private final String referredProjectName;
    private final String parent;
    private final String configPath;
    private final boolean isPending;
    private final boolean computeChecksums;
    private final boolean isShared;

    private SandboxInfo(File aSandboxName, String host, String port, String aType, String aSIProjectName, String aTypeInfo, String parent, boolean isPending, String configPath, String referredProject, boolean computeChecksums, boolean shared) {
        this.isVariant = VARIANT_SANDBOX.equalsIgnoreCase(aType);
        this.isBuild = BUILD_SANDBOX.equalsIgnoreCase(aType);
        this.isNormal = !this.isVariant && !this.isBuild;
        this.sandboxName = aSandboxName;
        this.parent = parent;
        this.host = host;
        this.port = port;
        this.projectName = aSIProjectName;
        this.referredProjectName = this.projectName != null && this.projectName.equals(referredProject) ? this.projectName : referredProject;
        this.isPending = isPending;
        this.configPath = configPath;
        this.computeChecksums = computeChecksums;
        this.typeInfo = aTypeInfo;
        this.isShared = shared;
    }

    private SandboxInfo(File aSandboxName, String host, String port, boolean isVariant, boolean isBuild, String aSIProjectName, String aTypeInfo, String parent, boolean isPending, String configPath, String referredProject, boolean computeChecksums, boolean shared) {
        this.isVariant = isVariant;
        this.isBuild = isBuild;
        this.isNormal = !isVariant && !isBuild;
        this.sandboxName = aSandboxName;
        this.parent = parent;
        this.host = host;
        this.port = port;
        this.projectName = aSIProjectName;
        this.isPending = isPending;
        this.configPath = configPath;
        this.computeChecksums = computeChecksums;
        this.referredProjectName = this.projectName != null && this.projectName.equals(referredProject) ? this.projectName : referredProject;
        this.typeInfo = aTypeInfo;
        this.isShared = shared;
    }

    public String getSandboxName() {
        return this.getSandboxFile().getAbsolutePath();
    }

    public File getSandboxFile() {
        return this.sandboxName;
    }

    public File getSandboxLocation() {
        return this.getSandboxFile().getParentFile();
    }

    public String getHostname() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isVariant() {
        return this.isVariant;
    }

    public boolean isBuild() {
        return this.isBuild;
    }

    public String getProject() {
        return this.projectName;
    }

    public String getReferredProject() {
        return this.referredProjectName;
    }

    public String getTypeInfo() {
        return this.typeInfo;
    }

    public boolean isSubsandbox() {
        return this.parent != null;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public String getParentName() {
        return this.parent;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public boolean isRelatedTo(CmdRunnerCreator session, File sandboxRoot) throws APIException {
        if (this.getSandboxFile().equals(sandboxRoot)) {
            return true;
        }
        if (this.getParentName() == null) {
            return false;
        }
        return SandboxInfo.getSandboxInfo(session, new File(this.getParentName())).isRelatedTo(session, sandboxRoot);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SandboxInfo)) {
            return false;
        }
        SandboxInfo sbx = (SandboxInfo)obj;
        if (!this.getSandboxName().equals(sbx.getSandboxName())) {
            return false;
        }
        if (!this.getHostname().equals(sbx.getHostname())) {
            return false;
        }
        if (!this.getPort().equals(sbx.getPort())) {
            return false;
        }
        if (!this.getProject().equals(sbx.getProject())) {
            return false;
        }
        if (this.isShared() != sbx.isShared()) {
            return false;
        }
        if (this.typeInfo == null ? sbx.typeInfo != null : !this.typeInfo.equals(sbx.typeInfo)) {
            return false;
        }
        return !(this.getParentName() == null ? sbx.getParentName() != null : !this.getParentName().equals(sbx.getParentName()));
    }

    public int hashCode() {
        return this.getSandboxName().hashCode();
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getDevPath() {
        return this.isVariant() ? this.typeInfo : null;
    }

    public String getBuildRevision() {
        return this.isBuild() ? this.typeInfo : null;
    }

    public boolean isComputeChecksums() {
        return this.computeChecksums;
    }

    @Override
    public String getContext() {
        return this.getParentName();
    }

    @Override
    public String getContext(String key) {
        return null;
    }

    @Override
    public Enumeration getContextKeys() {
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    @Override
    public String getDisplayId() {
        return null;
    }

    @Override
    public String getId() {
        return this.getSandboxName();
    }

    @Override
    public String getModelType() {
        return "si.SandboxInfo";
    }

    @Override
    public boolean contains(String id) {
        for (String fieldId : fields) {
            if (!fieldId.equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Field getField(String id) {
        Object value = null;
        if (SANDBOX_FIELD.equals(id)) {
            value = this.sandboxName;
        } else if (PARENT_FIELD.equals(id)) {
            value = this.parent;
        } else if (HOST_FIELD.equals(id)) {
            value = this.host;
        } else if (PORT_FIELD.equals(id)) {
            value = this.port;
        } else if (PROJECT_FIELD.equals(id)) {
            value = this.projectName;
        } else if (REFERRED_PROJECT_FIELD.equals(id)) {
            value = this.referredProjectName;
        } else if (NORMAL_FIELD.equals(id)) {
            value = this.isNormal ? Boolean.TRUE : Boolean.FALSE;
        } else if (VARIANT_FIELD.equals(id)) {
            value = this.isVariant ? Boolean.TRUE : Boolean.FALSE;
        } else if (BUILD_FIELD.equals(id)) {
            value = this.isBuild ? Boolean.TRUE : Boolean.FALSE;
        } else if (DEV_PATH_FIELD.equals(id)) {
            value = this.getDevPath();
        } else if (BUILD_REVISION_FIELD.equals(id)) {
            value = this.getBuildRevision();
        } else if (SUB_SANDBOX_FIELD.equals(id)) {
            value = this.isSubsandbox() ? Boolean.TRUE : Boolean.FALSE;
        } else if (CONFIG_PATH_FIELD.equals(id)) {
            value = this.configPath;
        } else if (PENDING_FIELD.equals(id)) {
            value = this.isPending ? Boolean.TRUE : Boolean.FALSE;
        } else if (COMPUTE_CHECKSUMS_FIELD.equals(id)) {
            value = this.computeChecksums ? Boolean.TRUE : Boolean.FALSE;
        } else if (IS_SHARED_FIELD.equals(id)) {
            value = this.isShared ? Boolean.TRUE : Boolean.FALSE;
        } else {
            throw new NoSuchElementException();
        }
        SimpleResponseFactory factory = SimpleResponseFactory.getResponseFactory();
        ModifiableField field = factory.createField(id);
        field.setValue(value);
        return field;
    }

    @Override
    public int getFieldListSize() {
        return fields.length;
    }

    @Override
    public Iterator<Field> getFields() {
        ArrayList<Field> itemFields = new ArrayList<Field>(fields.length);
        for (String id : fields) {
            itemFields.add(this.getField(id));
        }
        return itemFields.iterator();
    }

    private static SandboxInfo construct(Response r) throws APIException {
        WorkItem currentWorkItem = r.getWorkItems().next();
        File sandboxName = new File(currentWorkItem.getField(SANDBOX_FIELD).getValueAsString());
        boolean computeChecksums = currentWorkItem.getField(COMPUTE_CHECKSUMS_FIELD).getBoolean();
        String server = currentWorkItem.getField(HOST_FIELD).getValueAsString();
        String serverPort = currentWorkItem.getField(PORT_FIELD).getValueAsString();
        String siProjectName = currentWorkItem.getField(PROJECT_FIELD).getValueAsString();
        String siReferredProjectName = currentWorkItem.getField(REFERRED_PROJECT_FIELD).getValueAsString();
        String parentSandbox = currentWorkItem.getField(PARENT_FIELD).getValueAsString();
        String configPath = currentWorkItem.getField(CONFIG_PATH_FIELD).getValueAsString();
        String pendingStatus = currentWorkItem.getField("pendingType").getValueAsString();
        boolean isPending = false;
        if (pendingStatus != null && pendingStatus.indexOf("pending") >= 0) {
            isPending = true;
        }
        boolean isShared = currentWorkItem.getField(IS_SHARED_FIELD).getBoolean();
        String type = NORMAL_SANDBOX;
        String typeInfo = "";
        String projectType = currentWorkItem.getField("projectType").getValueAsString();
        if (projectType.equals("Variant")) {
            type = VARIANT_SANDBOX;
            typeInfo = currentWorkItem.getField(DEV_PATH_FIELD).getItem().getId();
        } else if (projectType.equals("Build")) {
            type = BUILD_SANDBOX;
            typeInfo = currentWorkItem.getField("revision").getItem().getId();
        }
        return new SandboxInfo(sandboxName, server, serverPort, type, siProjectName, typeInfo, parentSandbox, isPending, configPath, siReferredProjectName, computeChecksums, isShared);
    }

    public static SandboxInfo createFromWFWI(Item sandboxFields) {
        if (sandboxFields == null) {
            return null;
        }
        File sandboxName = new File(sandboxFields.getField(SANDBOX_FIELD).getValueAsString());
        boolean computeChecksums = sandboxFields.getField(COMPUTE_CHECKSUMS_FIELD).getBoolean();
        String server = sandboxFields.getField(HOST_FIELD).getValueAsString();
        String serverPort = sandboxFields.getField(PORT_FIELD).getValueAsString();
        String siProjectName = sandboxFields.getField(PROJECT_FIELD).getValueAsString();
        String siReferredProjectName = sandboxFields.getField(REFERRED_PROJECT_FIELD).getValueAsString();
        String parentSandbox = sandboxFields.getField(PARENT_FIELD).getValueAsString();
        String configPath = sandboxFields.getField(CONFIG_PATH_FIELD).getValueAsString();
        boolean isPending = sandboxFields.getField(PENDING_FIELD).getBoolean();
        boolean isVariant = sandboxFields.getField(VARIANT_FIELD).getBoolean();
        boolean isBuild = sandboxFields.getField(BUILD_FIELD).getBoolean();
        boolean isShared = sandboxFields.getField(IS_SHARED_FIELD).getBoolean();
        String typeInfo = "";
        if (isVariant) {
            typeInfo = sandboxFields.getField(DEV_PATH_FIELD).getValueAsString();
        } else if (isBuild) {
            typeInfo = sandboxFields.getField(BUILD_REVISION_FIELD).getValueAsString();
        }
        return new SandboxInfo(sandboxName, server, serverPort, isVariant, isBuild, siProjectName, typeInfo, parentSandbox, isPending, configPath, siReferredProjectName, computeChecksums, isShared);
    }

    public static SandboxInfo getSandboxInfo(CmdRunnerCreator session, File sandboxPath) throws APIException {
        return SandboxInfo.getSandboxInfo(new SICommands(session, false), sandboxPath);
    }

    static SandboxInfo getSandboxInfo(SICommands si, File sandboxPath) throws APIException {
        try {
            Response sandboxInfo = null;
            sandboxInfo = !sandboxPath.isDirectory() ? si.getSandboxInfoFromSandbox(sandboxPath.getAbsolutePath()) : si.getSandboxInfo(sandboxPath.getAbsolutePath());
            return SandboxInfo.construct(sandboxInfo);
        }
        catch (InvalidCommandOptionException ex) {
            boolean missingSandbox = false;
            try {
                missingSandbox = "sandbox".equals(ex.getField("command-option").getValue());
            }
            catch (NoSuchElementException ignored) {
                // empty catch block
            }
            if (missingSandbox) {
                return null;
            }
            throw ex;
        }
    }
}

