/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands.ide;

import com.mks.api.response.Field;
import com.mks.api.response.Item;
import com.mks.api.response.impl.SimpleResponseFactory;
import com.mks.api.response.modifiable.ModifiableField;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class BatchMarker
implements Item {
    private String hostConnection = null;
    private String batchID = null;
    public static final int START_BATCH = 1;
    public static final int END_BATCH = 2;
    public static final int BATCH_CHUNK = 3;
    public static final int COMMAND_BATCH = 1;
    public static final int CACHE_BATCH = 2;
    public static final String BATCH_START_FIELD = "start";
    public static final String BATCH_END_FIELD = "end";
    public static final String BATCH_CHUNK_FIELD = "chunk";
    public static final String BATCH_CACHE_FIELD = "cache";
    public static final String BATCH_COMMAND_FIELD = "command";
    private Map<String, Boolean> fields = new HashMap<String, Boolean>(24);

    public BatchMarker(String hostConnection, String batchID, int eventType, int batchType) {
        this.fields.put(BATCH_START_FIELD, Boolean.FALSE);
        this.fields.put(BATCH_END_FIELD, Boolean.FALSE);
        this.fields.put(BATCH_CHUNK_FIELD, Boolean.FALSE);
        this.fields.put(BATCH_CACHE_FIELD, Boolean.FALSE);
        this.fields.put(BATCH_COMMAND_FIELD, Boolean.FALSE);
        this.fields.put(BATCH_START_FIELD, new Boolean(eventType == 1));
        this.fields.put(BATCH_END_FIELD, new Boolean(eventType == 2));
        this.fields.put(BATCH_CHUNK_FIELD, new Boolean(eventType == 3));
        this.fields.put(BATCH_CACHE_FIELD, new Boolean(batchType == 2));
        this.fields.put(BATCH_COMMAND_FIELD, new Boolean(batchType == 1));
        this.hostConnection = hostConnection;
        this.batchID = batchID;
    }

    @Override
    public String getContext() {
        return this.hostConnection;
    }

    @Override
    public String getContext(String key) {
        return null;
    }

    @Override
    public Enumeration<Object> getContextKeys() {
        return new Enumeration<Object>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public Object nextElement() {
                return null;
            }
        };
    }

    @Override
    public String getDisplayId() {
        return null;
    }

    @Override
    public String getId() {
        return this.batchID + "";
    }

    @Override
    public String getModelType() {
        return "si.BatchEvent";
    }

    @Override
    public boolean contains(String id) {
        return this.fields.containsKey(id);
    }

    @Override
    public Field getField(String id) {
        if (this.contains(id)) {
            Boolean fieldValue = null;
            fieldValue = this.fields.get(id);
            SimpleResponseFactory factory = SimpleResponseFactory.getResponseFactory();
            ModifiableField field = factory.createField(id);
            field.setValue(fieldValue);
            return field;
        }
        throw new NoSuchElementException(id);
    }

    @Override
    public int getFieldListSize() {
        return this.fields.size();
    }

    @Override
    public Iterator<Field> getFields() {
        ArrayList<Field> itemFields = new ArrayList<Field>(this.getFieldListSize());
        Iterator<String> ids = this.fields.keySet().iterator();
        while (ids.hasNext()) {
            itemFields.add(this.getField(ids.next()));
        }
        return itemFields.iterator();
    }

    @Override
    public String toString() {
        String type = "";
        String cacheCommand = "";
        if (this.fields.get(BATCH_START_FIELD).booleanValue()) {
            type = BATCH_START_FIELD;
        } else if (this.fields.get(BATCH_END_FIELD).booleanValue()) {
            type = BATCH_END_FIELD;
        } else if (this.fields.get(BATCH_CHUNK_FIELD).booleanValue()) {
            type = BATCH_CHUNK_FIELD;
        }
        if (this.fields.get(BATCH_CACHE_FIELD).booleanValue()) {
            cacheCommand = BATCH_CACHE_FIELD;
        }
        if (this.fields.get(BATCH_COMMAND_FIELD).booleanValue()) {
            cacheCommand = BATCH_COMMAND_FIELD;
        }
        return this.getId() + " " + type + " " + cacheCommand;
    }
}

