/*
 * Decompiled with CFR 0.152.
 */
package com.mkobit.gradle.test.assertj.testkit;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.TaskOutcome;

public class BuildTaskAssert
extends AbstractAssert<BuildTaskAssert, BuildTask> {
    public BuildTaskAssert(@Nullable BuildTask actual) {
        super((Object)actual, BuildTaskAssert.class);
    }

    public BuildTaskAssert pathIsEqualTo(String path) {
        this.isNotNull();
        if (!path.equals(((BuildTask)this.actual).getPath())) {
            this.failWithMessage("%nExpecting task path to be be equal to:%n <%s>%nbut was:%n <%s>", new Object[]{path, ((BuildTask)this.actual).getPath()});
        }
        return this;
    }

    public BuildTaskAssert pathStartsWith(CharSequence pathPrefix) {
        this.isNotNull();
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        String pathValue = pathPrefix.toString();
        if (!((BuildTask)this.actual).getPath().startsWith(pathValue)) {
            this.failWithMessage("%nExpecting task path to start with:%n <%s>%nbut was:%n <%s>", new Object[]{pathValue, ((BuildTask)this.actual).getPath()});
        }
        return this;
    }

    public BuildTaskAssert pathEndsWith(CharSequence pathSuffix) {
        this.isNotNull();
        Objects.requireNonNull(pathSuffix, "pathSuffix");
        String pathValue = pathSuffix.toString();
        if (!((BuildTask)this.actual).getPath().endsWith(pathValue)) {
            this.failWithMessage("%nExpecting task path to end with:%n <%s>%nbut was:%n <%s>", new Object[]{pathValue, ((BuildTask)this.actual).getPath()});
        }
        return this;
    }

    public BuildTaskAssert pathContains(CharSequence sequence) {
        this.isNotNull();
        Objects.requireNonNull(sequence, "sequence");
        String pathValue = sequence.toString();
        if (!((BuildTask)this.actual).getPath().contains(pathValue)) {
            this.failWithMessage("%nExpecting task path to contain:%n <%s>%nbut was:%n <%s>", new Object[]{pathValue, ((BuildTask)this.actual).getPath()});
        }
        return this;
    }

    public BuildTaskAssert pathMatches(Pattern pattern) {
        this.isNotNull();
        Objects.requireNonNull(pattern, "pattern");
        if (!pattern.matcher(((BuildTask)this.actual).getPath()).matches()) {
            this.failWithMessage("%nExpecting task path to match:%n <%s>%nbut was:%n <%s>", new Object[]{pattern, ((BuildTask)this.actual).getPath()});
        }
        return this;
    }

    public BuildTaskAssert pathDoesNotMatch(Pattern pattern) {
        this.isNotNull();
        Objects.requireNonNull(pattern, "pattern");
        if (pattern.matcher(((BuildTask)this.actual).getPath()).matches()) {
            this.failWithMessage("%nExpecting task path to match:%n <%s>%nbut was:%n <%s>", new Object[]{pattern, ((BuildTask)this.actual).getPath()});
        }
        return this;
    }

    public BuildTaskAssert pathSatisfies(Consumer<String> requirements) {
        Objects.requireNonNull(requirements, "requirements");
        requirements.accept(((BuildTask)this.actual).getPath());
        return this;
    }

    public BuildTaskAssert isFailed() {
        this.isNotNull();
        this.assertTaskOutcome(TaskOutcome.FAILED);
        return this;
    }

    public BuildTaskAssert isFromCache() {
        this.isNotNull();
        this.assertTaskOutcome(TaskOutcome.FROM_CACHE);
        return this;
    }

    public BuildTaskAssert isNoSource() {
        this.isNotNull();
        this.assertTaskOutcome(TaskOutcome.NO_SOURCE);
        return this;
    }

    public BuildTaskAssert isSkipped() {
        this.isNotNull();
        this.assertTaskOutcome(TaskOutcome.SKIPPED);
        return this;
    }

    public BuildTaskAssert isSuccess() {
        this.isNotNull();
        this.assertTaskOutcome(TaskOutcome.SUCCESS);
        return this;
    }

    public BuildTaskAssert isUpToDate() {
        this.isNotNull();
        this.assertTaskOutcome(TaskOutcome.UP_TO_DATE);
        return this;
    }

    public BuildTaskAssert hasTaskOutcome(TaskOutcome taskOutcome) {
        this.isNotNull();
        this.assertTaskOutcome(taskOutcome);
        return this;
    }

    private void assertTaskOutcome(TaskOutcome expected) {
        Objects.requireNonNull(expected, "expected");
        if (((BuildTask)this.actual).getOutcome() != expected) {
            this.failWithMessage("%nExpecting task at path %s to have outcome:%n <%s>%nbut was:%n <%s>", new Object[]{((BuildTask)this.actual).getPath(), expected, ((BuildTask)this.actual).getOutcome()});
        }
    }
}

