/*
 * Decompiled with CFR 0.152.
 */
package com.mkobit.gradle.test.assertj.testkit;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.TaskOutcome;

public class BuildResultAssert
extends AbstractAssert<BuildResultAssert, BuildResult> {
    public BuildResultAssert(@Nullable BuildResult actual) {
        super((Object)actual, BuildResultAssert.class);
    }

    public BuildResultAssert outputContains(CharSequence sequence) {
        this.isNotNull();
        Objects.requireNonNull(sequence, "sequence");
        if (!((BuildResult)this.actual).getOutput().contains(sequence)) {
            this.failWithMessage("%nExpecting build result output:%n <%s>%nto contain sequence:%n <%s>", new Object[]{((BuildResult)this.actual).getOutput(), sequence});
        }
        return this;
    }

    public BuildResultAssert outputDoesNotContain(CharSequence sequence) {
        this.isNotNull();
        Objects.requireNonNull(sequence, "sequence");
        if (((BuildResult)this.actual).getOutput().contains(sequence)) {
            this.failWithMessage("%nExpecting build result output:%n <%s>%nto not contain sequence:%n <%s>", new Object[]{((BuildResult)this.actual).getOutput(), sequence});
        }
        return this;
    }

    public BuildResultAssert outputMatches(Pattern pattern) {
        this.isNotNull();
        Objects.requireNonNull(pattern, "pattern");
        if (!pattern.matcher(((BuildResult)this.actual).getOutput()).matches()) {
            this.failWithMessage("%nExpecting build output to match:%n <%s>%nbut was:%n <%s>", new Object[]{pattern, ((BuildResult)this.actual).getOutput()});
        }
        return this;
    }

    public BuildResultAssert outputDoesNotMatch(Pattern pattern) {
        this.isNotNull();
        Objects.requireNonNull(pattern, "pattern");
        if (pattern.matcher(((BuildResult)this.actual).getOutput()).matches()) {
            this.failWithMessage("%nExpecting build output not to match:%n <%s>%nbut was:%n <%s>", new Object[]{pattern, ((BuildResult)this.actual).getOutput()});
        }
        return this;
    }

    public BuildResultAssert outputSatisfies(Consumer<String> requirements) {
        this.isNotNull();
        Objects.requireNonNull(requirements, "Consumer<String> of output expressing assertions requirements must not be null");
        requirements.accept(((BuildResult)this.actual).getOutput());
        return this;
    }

    public BuildResultAssert hasTaskAtPath(CharSequence path) {
        this.isNotNull();
        Objects.requireNonNull(path, "path");
        String taskPath = path.toString();
        BuildTask buildTask = ((BuildResult)this.actual).task(taskPath);
        if (buildTask == null) {
            this.failWithMessage("%nExpecting build to have task at path:%n <%s>%nbut did not", new Object[]{taskPath});
        }
        return this;
    }

    public BuildResultAssert doesNotHaveTaskAtPath(CharSequence path) {
        this.isNotNull();
        Objects.requireNonNull(path, "path");
        String taskPath = path.toString();
        BuildTask buildTask = ((BuildResult)this.actual).task(taskPath);
        if (buildTask != null) {
            this.failWithMessage("%nExpecting build to not have task at path:%n <%s>%nbut did", new Object[]{taskPath});
        }
        return this;
    }

    public BuildResultAssert hasTaskAtPathSatisfying(CharSequence path, Consumer<? super BuildTask> requirements) {
        this.isNotNull();
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(requirements, "requirements");
        String taskPath = path.toString();
        BuildTask buildTask = ((BuildResult)this.actual).task(taskPath);
        if (buildTask == null) {
            this.failWithMessage("%nExpecting build to have task at path:%n <%s>%nto check requirements against but did not", new Object[]{taskPath});
        }
        requirements.accept((BuildTask)buildTask);
        return this;
    }

    public BuildResultAssert tasksWithOutcomeSatisfy(TaskOutcome outcome, Consumer<List<BuildTask>> requirements) {
        this.isNotNull();
        Objects.requireNonNull(outcome, "outcome");
        Objects.requireNonNull(requirements, "requirements");
        requirements.accept(((BuildResult)this.actual).tasks(outcome));
        return this;
    }

    public BuildResultAssert taskPathsWithOutcomeSatisfy(TaskOutcome outcome, Consumer<List<String>> requirements) {
        this.isNotNull();
        Objects.requireNonNull(outcome, "outcome must not be null");
        Objects.requireNonNull(requirements, "requirements must not be null");
        requirements.accept(((BuildResult)this.actual).taskPaths(outcome));
        return this;
    }

    public BuildResultAssert tasksSatisfy(Consumer<List<BuildTask>> requirements) {
        this.isNotNull();
        Objects.requireNonNull(requirements, "requirements");
        requirements.accept(((BuildResult)this.actual).getTasks());
        return this;
    }

    public BuildResultAssert hasTaskFailedAtPath(CharSequence path) {
        return this.hasTaskAtPathWithOutcome(path, TaskOutcome.FAILED);
    }

    public BuildResultAssert hasTaskFromCacheAtPath(CharSequence path) {
        return this.hasTaskAtPathWithOutcome(path, TaskOutcome.FROM_CACHE);
    }

    public BuildResultAssert hasTaskNoSourceAtPath(CharSequence path) {
        return this.hasTaskAtPathWithOutcome(path, TaskOutcome.NO_SOURCE);
    }

    public BuildResultAssert hasTaskSkippedAtPath(CharSequence path) {
        return this.hasTaskAtPathWithOutcome(path, TaskOutcome.SKIPPED);
    }

    public BuildResultAssert hasTaskSuccessAtPath(CharSequence path) {
        return this.hasTaskAtPathWithOutcome(path, TaskOutcome.SUCCESS);
    }

    public BuildResultAssert hasTaskUpToDateAtPath(CharSequence path) {
        return this.hasTaskAtPathWithOutcome(path, TaskOutcome.UP_TO_DATE);
    }

    public BuildResultAssert hasTaskAtPathWithOutcome(CharSequence path, TaskOutcome outcome) {
        this.isNotNull();
        Objects.requireNonNull(outcome, "outcome must not be null");
        String taskPath = path.toString();
        BuildTask buildTask = ((BuildResult)this.actual).task(taskPath);
        if (buildTask == null) {
            this.failWithMessage("Build task at path %s was not executed so could not be checked for outcome %s.%nTasks executed by build were:%n %s", new Object[]{taskPath, outcome, this.formatTasksForFailureMessage(((BuildResult)this.actual).getTasks())});
        }
        if (buildTask.getOutcome() != outcome) {
            this.failWithMessage("Build task at path %s expected to have outcome:%n <%s>%nbut was:%n <%s>", new Object[]{taskPath, outcome, buildTask.getOutcome()});
        }
        return this;
    }

    private String formatTasksForFailureMessage(List<BuildTask> tasks) {
        return tasks.stream().sorted(Comparator.comparing(BuildTask::getPath)).map(buildTask -> "(path=" + buildTask.getPath() + ", outcome=" + buildTask.getOutcome()).collect(Collectors.joining(", ", "[", "]"));
    }
}

