/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.featureflags.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VersionUtil {
    private static final Logger logger = Logger.getLogger(VersionUtil.class.getName());
    private static final String VERSION_FILE = "mixpanel-version.properties";
    private static final String VERSION_KEY = "version";
    private static final String UNKNOWN_VERSION = "unknown";
    private static String cachedVersion = null;

    private VersionUtil() {
    }

    public static String getVersion() {
        if (cachedVersion == null) {
            cachedVersion = VersionUtil.loadVersion();
        }
        return cachedVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadVersion() {
        try (InputStream input = VersionUtil.class.getClassLoader().getResourceAsStream(VERSION_FILE);){
            if (input == null) {
                logger.log(Level.WARNING, "Version file not found: mixpanel-version.properties (using fallback version)");
                String string = UNKNOWN_VERSION;
                return string;
            }
            Properties props = new Properties();
            props.load(input);
            String version = props.getProperty(VERSION_KEY);
            if (version == null || version.isEmpty()) {
                logger.log(Level.WARNING, "Version property not found in mixpanel-version.properties");
                String string = UNKNOWN_VERSION;
                return string;
            }
            String string = version;
            return string;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to load version from mixpanel-version.properties", e);
            return UNKNOWN_VERSION;
        }
    }
}

