/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.featureflags.provider;

import com.mixpanel.mixpanelapi.featureflags.EventSender;
import com.mixpanel.mixpanelapi.featureflags.config.BaseFlagsConfig;
import com.mixpanel.mixpanelapi.featureflags.model.SelectedVariant;
import com.mixpanel.mixpanelapi.featureflags.util.TraceparentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public abstract class BaseFlagsProvider<C extends BaseFlagsConfig> {
    protected static final int BUFFER_SIZE = 4096;
    protected final String projectToken;
    protected final C config;
    protected final String sdkVersion;
    protected final EventSender eventSender;

    protected BaseFlagsProvider(String projectToken, C config, String sdkVersion, EventSender eventSender) {
        this.projectToken = projectToken;
        this.config = config;
        this.sdkVersion = sdkVersion;
        this.eventSender = eventSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String httpGet(String urlString) throws IOException {
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(((BaseFlagsConfig)this.config).getRequestTimeoutSeconds() * 1000);
        conn.setReadTimeout(((BaseFlagsConfig)this.config).getRequestTimeoutSeconds() * 1000);
        String auth = this.projectToken + ":";
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        conn.setRequestProperty("Authorization", "Basic " + encodedAuth);
        conn.setRequestProperty("X-Scheme", "https");
        conn.setRequestProperty("X-Forwarded-Proto", "https");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("traceparent", TraceparentUtil.generateTraceparent());
        InputStream responseStream = null;
        try {
            responseStream = conn.getInputStream();
            String string = this.readStream(responseStream);
            return string;
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException e) {
                    this.getLogger().log(Level.WARNING, "Failed to close response stream", e);
                }
            }
        }
    }

    protected String readStream(InputStream in) throws IOException {
        int count;
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        char[] buffer = new char[4096];
        while ((count = reader.read(buffer)) != -1) {
            out.append(buffer, 0, count);
        }
        return out.toString();
    }

    public abstract <T> SelectedVariant<T> getVariant(String var1, SelectedVariant<T> var2, Map<String, Object> var3, boolean var4);

    public <T> SelectedVariant<T> getVariant(String flagKey, SelectedVariant<T> fallback, Map<String, Object> context) {
        return this.getVariant(flagKey, fallback, context, true);
    }

    protected abstract Logger getLogger();

    public <T> T getVariantValue(String flagKey, T fallbackValue, Map<String, Object> context) {
        SelectedVariant<T> fallback = new SelectedVariant<T>(fallbackValue);
        SelectedVariant<T> result = this.getVariant(flagKey, fallback, context, true);
        return result.getVariantValue();
    }

    public boolean isEnabled(String flagKey, Map<String, Object> context) {
        SelectedVariant<Boolean> result = this.getVariant(flagKey, new SelectedVariant<Boolean>(false), context, true);
        Boolean value = result.getVariantValue();
        return value instanceof Boolean && value != false;
    }

    protected void trackExposure(String distinctId, String flagKey, String variantKey, String evaluationMode, Consumer<JSONObject> addTimingProperties, UUID experimentId, Boolean isExperimentActive, Boolean isQaTester) {
        try {
            JSONObject properties = new JSONObject();
            properties.put("Experiment name", (Object)flagKey);
            properties.put("Variant name", (Object)variantKey);
            properties.put("$experiment_type", (Object)"feature_flag");
            properties.put("Flag evaluation mode", (Object)evaluationMode);
            if (experimentId != null) {
                properties.put("$experiment_id", (Object)experimentId.toString());
            }
            if (isExperimentActive != null) {
                properties.put("$is_experiment_active", (Object)isExperimentActive);
            }
            if (isQaTester != null) {
                properties.put("$is_qa_tester", (Object)isQaTester);
            }
            addTimingProperties.accept(properties);
            this.eventSender.sendEvent(distinctId, "$experiment_started", properties);
            this.getLogger().log(Level.FINE, "Tracked exposure event for flag: " + flagKey + ", variant: " + variantKey);
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error tracking exposure event for flag: " + flagKey + ", variant: " + variantKey + " - " + e.getMessage(), e);
        }
    }
}

