/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi;

import com.mixpanel.mixpanelapi.Base64Coder;
import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.DeliveryOptions;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelMessageException;
import com.mixpanel.mixpanelapi.MixpanelServerException;
import com.mixpanel.mixpanelapi.featureflags.EventSender;
import com.mixpanel.mixpanelapi.featureflags.config.BaseFlagsConfig;
import com.mixpanel.mixpanelapi.featureflags.config.LocalFlagsConfig;
import com.mixpanel.mixpanelapi.featureflags.config.RemoteFlagsConfig;
import com.mixpanel.mixpanelapi.featureflags.provider.LocalFlagsProvider;
import com.mixpanel.mixpanelapi.featureflags.provider.RemoteFlagsProvider;
import com.mixpanel.mixpanelapi.featureflags.util.VersionUtil;
import com.mixpanel.mixpanelapi.internal.JsonSerializer;
import com.mixpanel.mixpanelapi.internal.OrgJsonSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelAPI
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(MixpanelAPI.class.getName());
    private static final int BUFFER_SIZE = 256;
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 2000;
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 10000;
    protected final String mEventsEndpoint;
    protected final String mPeopleEndpoint;
    protected final String mGroupsEndpoint;
    protected final String mImportEndpoint;
    protected final boolean mUseGzipCompression;
    protected final Integer mConnectTimeout;
    protected final Integer mReadTimeout;
    protected Integer mImportMaxMessageCount;
    protected final LocalFlagsProvider mLocalFlags;
    protected final RemoteFlagsProvider mRemoteFlags;
    protected final JsonSerializer mJsonSerializer;
    protected final OrgJsonSerializer mDefaultJsonSerializer;

    public MixpanelAPI() {
        this(false);
    }

    public MixpanelAPI(boolean useGzipCompression) {
        this(null, null, null, null, useGzipCompression, null, null, null, null, null, null);
    }

    public MixpanelAPI(LocalFlagsConfig localFlagsConfig) {
        this(localFlagsConfig, null);
    }

    public MixpanelAPI(RemoteFlagsConfig remoteFlagsConfig) {
        this(null, remoteFlagsConfig);
    }

    private MixpanelAPI(LocalFlagsConfig localFlagsConfig, RemoteFlagsConfig remoteFlagsConfig) {
        this(null, null, null, null, false, localFlagsConfig, remoteFlagsConfig, null, null, null, null);
    }

    public MixpanelAPI(String eventsEndpoint, String peopleEndpoint) {
        this(eventsEndpoint, peopleEndpoint, null, null, false, null, null, null, null, null, null);
    }

    public MixpanelAPI(String eventsEndpoint, String peopleEndpoint, String groupsEndpoint) {
        this(eventsEndpoint, peopleEndpoint, groupsEndpoint, null, false, null, null, null, null, null, null);
    }

    public MixpanelAPI(String eventsEndpoint, String peopleEndpoint, String groupsEndpoint, String importEndpoint) {
        this(eventsEndpoint, peopleEndpoint, groupsEndpoint, importEndpoint, false, null, null, null, null, null, null);
    }

    public MixpanelAPI(String eventsEndpoint, String peopleEndpoint, String groupsEndpoint, String importEndpoint, boolean useGzipCompression) {
        this(eventsEndpoint, peopleEndpoint, groupsEndpoint, importEndpoint, useGzipCompression, null, null, null, null, null, null);
    }

    private MixpanelAPI(Builder builder) {
        this(builder.eventsEndpoint, builder.peopleEndpoint, builder.groupsEndpoint, builder.importEndpoint, builder.useGzipCompression, builder.flagsConfig instanceof LocalFlagsConfig ? (LocalFlagsConfig)builder.flagsConfig : null, builder.flagsConfig instanceof RemoteFlagsConfig ? (RemoteFlagsConfig)builder.flagsConfig : null, builder.jsonSerializer, builder.connectTimeout, builder.readTimeout, builder.importMaxMessageCount);
    }

    private MixpanelAPI(String eventsEndpoint, String peopleEndpoint, String groupsEndpoint, String importEndpoint, boolean useGzipCompression, LocalFlagsConfig localFlagsConfig, RemoteFlagsConfig remoteFlagsConfig, JsonSerializer jsonSerializer, Integer connectTimeout, Integer readTimeout, Integer importMaxMessageCount) {
        this.mEventsEndpoint = eventsEndpoint != null ? eventsEndpoint : "https://api.mixpanel.com/track";
        this.mPeopleEndpoint = peopleEndpoint != null ? peopleEndpoint : "https://api.mixpanel.com/engage";
        this.mGroupsEndpoint = groupsEndpoint != null ? groupsEndpoint : "https://api.mixpanel.com/groups";
        this.mImportEndpoint = importEndpoint != null ? importEndpoint : "https://api.mixpanel.com/import";
        this.mUseGzipCompression = useGzipCompression;
        this.mConnectTimeout = connectTimeout != null ? connectTimeout : 2000;
        this.mReadTimeout = readTimeout != null ? readTimeout : 10000;
        this.mImportMaxMessageCount = importMaxMessageCount != null ? Math.min(importMaxMessageCount, 2000) : 2000;
        this.mDefaultJsonSerializer = new OrgJsonSerializer();
        if (jsonSerializer != null) {
            logger.log(Level.INFO, "Custom JsonSerializer provided: " + jsonSerializer.getClass().getName());
            this.mJsonSerializer = jsonSerializer;
        } else {
            this.mJsonSerializer = this.mDefaultJsonSerializer;
        }
        if (localFlagsConfig != null) {
            EventSender eventSender = MixpanelAPI.createEventSender(localFlagsConfig, this);
            this.mLocalFlags = new LocalFlagsProvider(localFlagsConfig, VersionUtil.getVersion(), eventSender);
            this.mRemoteFlags = null;
        } else if (remoteFlagsConfig != null) {
            EventSender eventSender = MixpanelAPI.createEventSender(remoteFlagsConfig, this);
            this.mLocalFlags = null;
            this.mRemoteFlags = new RemoteFlagsProvider(remoteFlagsConfig, VersionUtil.getVersion(), eventSender);
        } else {
            this.mLocalFlags = null;
            this.mRemoteFlags = null;
        }
    }

    public void sendMessage(JSONObject message) throws MixpanelMessageException, IOException {
        ClientDelivery delivery = new ClientDelivery();
        delivery.addMessage(message);
        this.deliver(delivery);
    }

    public void deliver(ClientDelivery toSend) throws IOException {
        this.deliver(toSend, false);
    }

    public void deliver(ClientDelivery toSend, boolean useIpAddress) throws IOException {
        DeliveryOptions options = new DeliveryOptions.Builder().useIpAddress(useIpAddress).build();
        this.deliver(toSend, options);
    }

    public void deliver(ClientDelivery toSend, DeliveryOptions options) throws IOException {
        String ipParameter = options.useIpAddress() ? "ip=1" : "ip=0";
        String eventsUrl = this.mEventsEndpoint + "?" + ipParameter;
        List<JSONObject> events = toSend.getEventsMessages();
        this.sendMessages(events, eventsUrl);
        String peopleUrl = this.mPeopleEndpoint + "?" + ipParameter;
        List<JSONObject> people = toSend.getPeopleMessages();
        this.sendMessages(people, peopleUrl);
        String groupsUrl = this.mGroupsEndpoint + "?" + ipParameter;
        List<JSONObject> groupMessages = toSend.getGroupMessages();
        this.sendMessages(groupMessages, groupsUrl);
        List<JSONObject> importMessages = toSend.getImportMessages();
        if (importMessages.size() > 0) {
            String strictParam = options.isImportStrictMode() ? "1" : "0";
            String importUrl = this.mImportEndpoint + "?strict=" + strictParam;
            this.sendImportMessages(importMessages, importUrl);
        }
    }

    protected String encodeDataString(String dataString) {
        try {
            byte[] utf8data = dataString.getBytes("utf-8");
            String base64data = new String(Base64Coder.encode(utf8data));
            return URLEncoder.encode(base64data, "utf8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Mixpanel library requires utf-8 support", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendData(String dataString, String endpointUrl) throws IOException {
        byte[] dataToSend;
        String encodedQuery2;
        String encodedData;
        URL endpoint = new URL(endpointUrl);
        URLConnection conn = endpoint.openConnection();
        conn.setReadTimeout(this.mReadTimeout);
        conn.setConnectTimeout(this.mConnectTimeout);
        conn.setDoOutput(true);
        if (this.mUseGzipCompression) {
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf8");
            conn.setRequestProperty("Content-Encoding", "gzip");
            encodedData = this.encodeDataString(dataString);
            encodedQuery2 = "data=" + encodedData;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipStream = null;
            try {
                gzipStream = new GZIPOutputStream(byteStream);
                gzipStream.write(encodedQuery2.getBytes("utf-8"));
                gzipStream.finish();
                dataToSend = byteStream.toByteArray();
            }
            finally {
                if (gzipStream != null) {
                    try {
                        gzipStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf8");
        encodedData = this.encodeDataString(dataString);
        encodedQuery2 = "data=" + encodedData;
        dataToSend = encodedQuery2.getBytes("utf-8");
        OutputStream postStream = null;
        try {
            postStream = conn.getOutputStream();
            postStream.write(dataToSend);
        }
        finally {
            if (postStream != null) {
                try {
                    postStream.close();
                }
                catch (IOException encodedQuery2) {}
            }
        }
        InputStream responseStream = null;
        String response = null;
        try {
            responseStream = conn.getInputStream();
            response = this.slurp(responseStream);
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return response != null && response.equals("1");
    }

    private void sendMessages(List<JSONObject> messages, String endpointUrl) throws IOException {
        for (int i = 0; i < messages.size(); i += 50) {
            String messagesString;
            boolean accepted;
            int endIndex = i + 50;
            List<JSONObject> batch = messages.subList(i, endIndex = Math.min(endIndex, messages.size()));
            if (batch.size() <= 0 || (accepted = this.sendData(messagesString = this.dataString(batch), endpointUrl))) continue;
            throw new MixpanelServerException("Server refused to accept messages, they may be malformed.", batch);
        }
    }

    private void sendImportMessages(List<JSONObject> messages, String endpointUrl) throws IOException {
        String token = "";
        if (messages.size() > 0) {
            try {
                JSONObject properties;
                JSONObject firstMessage = messages.get(0);
                if (firstMessage.has("properties") && (properties = firstMessage.getJSONObject("properties")).has("token")) {
                    token = properties.getString("token");
                }
            }
            catch (JSONException firstMessage) {
                // empty catch block
            }
        }
        for (int i = 0; i < messages.size(); i += this.mImportMaxMessageCount.intValue()) {
            String messagesString;
            boolean accepted;
            int endIndex = i + this.mImportMaxMessageCount;
            List<JSONObject> batch = messages.subList(i, endIndex = Math.min(endIndex, messages.size()));
            if (batch.size() <= 0 || (accepted = this.sendImportData(messagesString = this.dataString(batch), endpointUrl, token))) continue;
            throw new MixpanelServerException("Server refused to accept import messages, they may be malformed.", batch);
        }
    }

    private String dataString(List<JSONObject> messages) {
        try {
            return this.mJsonSerializer.serializeArray(messages);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "JSON serialization failed unexpectedly; falling back to org.json implementation", e);
            return this.mDefaultJsonSerializer.serializeArray(messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean sendImportData(String dataString, String endpointUrl, String token) throws IOException {
        byte[] dataToSend;
        URL endpoint = new URL(endpointUrl);
        HttpURLConnection conn = (HttpURLConnection)endpoint.openConnection();
        conn.setReadTimeout(this.mReadTimeout);
        conn.setConnectTimeout(this.mConnectTimeout);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        try {
            String authString = token + ":";
            byte[] authBytes = authString.getBytes("utf-8");
            String base64Auth = new String(Base64Coder.encode(authBytes));
            conn.setRequestProperty("Authorization", "Basic " + base64Auth);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Mixpanel library requires utf-8 support", e);
        }
        if (this.mUseGzipCompression) {
            conn.setRequestProperty("Content-Encoding", "gzip");
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipStream = null;
            try {
                gzipStream = new GZIPOutputStream(byteStream);
                gzipStream.write(dataString.getBytes("utf-8"));
                gzipStream.finish();
                dataToSend = byteStream.toByteArray();
            }
            finally {
                if (gzipStream != null) {
                    try {
                        gzipStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        dataToSend = dataString.getBytes("utf-8");
        OutputStream postStream = null;
        try {
            postStream = conn.getOutputStream();
            postStream.write(dataToSend);
        }
        finally {
            if (postStream != null) {
                try {
                    postStream.close();
                }
                catch (IOException gzipStream) {}
            }
        }
        InputStream responseStream = null;
        String response = null;
        try {
            responseStream = conn.getInputStream();
            response = this.slurp(responseStream);
        }
        catch (IOException e) {
            InputStream errorStream = conn.getErrorStream();
            if (errorStream == null) throw e;
            try {
                this.slurp(errorStream);
                errorStream.close();
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                throw e;
            }
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (response == null) {
            return false;
        }
        String trimmedResponse = response.trim();
        if ("1".equals(trimmedResponse)) {
            return true;
        }
        if ("0".equals(trimmedResponse)) {
            return false;
        }
        try {
            JSONObject jsonResponse = new JSONObject(response);
            boolean statusOk = jsonResponse.has("status") && "OK".equals(jsonResponse.getString("status"));
            boolean codeOk = jsonResponse.has("code") && jsonResponse.getInt("code") == 200;
            if (!statusOk) return false;
            if (!codeOk) return false;
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private String slurp(InputStream in) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, "utf8");
        char[] readBuffer = new char[256];
        int readCount = 0;
        do {
            if ((readCount = reader.read(readBuffer)) <= 0) continue;
            out.append(readBuffer, 0, readCount);
        } while (readCount != -1);
        return out.toString();
    }

    public LocalFlagsProvider getLocalFlags() {
        return this.mLocalFlags;
    }

    public RemoteFlagsProvider getRemoteFlags() {
        return this.mRemoteFlags;
    }

    private static EventSender createEventSender(BaseFlagsConfig config, MixpanelAPI api) {
        MessageBuilder builder = new MessageBuilder(config.getProjectToken());
        return (distinctId, eventName, properties) -> {
            try {
                JSONObject event = builder.event(distinctId, eventName, properties);
                api.sendMessage(event);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
    }

    @Override
    public void close() {
        if (this.mLocalFlags != null) {
            this.mLocalFlags.close();
        }
    }

    public static class Builder {
        private String eventsEndpoint;
        private String peopleEndpoint;
        private String groupsEndpoint;
        private String importEndpoint;
        private boolean useGzipCompression;
        private BaseFlagsConfig flagsConfig;
        private JsonSerializer jsonSerializer;
        private Integer connectTimeout;
        private Integer readTimeout;
        private Integer importMaxMessageCount;

        public Builder eventsEndpoint(String eventsEndpoint) {
            this.eventsEndpoint = eventsEndpoint;
            return this;
        }

        public Builder peopleEndpoint(String peopleEndpoint) {
            this.peopleEndpoint = peopleEndpoint;
            return this;
        }

        public Builder groupsEndpoint(String groupsEndpoint) {
            this.groupsEndpoint = groupsEndpoint;
            return this;
        }

        public Builder importEndpoint(String importEndpoint) {
            this.importEndpoint = importEndpoint;
            return this;
        }

        public Builder useGzipCompression(boolean useGzipCompression) {
            this.useGzipCompression = useGzipCompression;
            return this;
        }

        public Builder flagsConfig(BaseFlagsConfig flagsConfig) {
            this.flagsConfig = flagsConfig;
            return this;
        }

        public Builder jsonSerializer(JsonSerializer jsonSerializer) {
            this.jsonSerializer = jsonSerializer;
            return this;
        }

        public Builder connectTimeout(int connectTimeoutInMillis) {
            if (connectTimeoutInMillis >= 0) {
                this.connectTimeout = connectTimeoutInMillis;
            }
            return this;
        }

        public Builder readTimeout(int readTimeoutInMillis) {
            if (readTimeoutInMillis >= 0) {
                this.readTimeout = readTimeoutInMillis;
            }
            return this;
        }

        public Builder importMaxMessageCount(int importMaxMessageCount) {
            if (importMaxMessageCount > 0 && importMaxMessageCount <= 2000) {
                this.importMaxMessageCount = importMaxMessageCount;
            }
            return this;
        }

        public MixpanelAPI build() {
            return new MixpanelAPI(this);
        }
    }
}

