/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.os.Build;
import com.mixpanel.android.mpmetrics.DecideMessages;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.SystemInformation;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.RemoteService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DecideChecker {
    private static final String LOGTAG = "MixpanelAPI.DChecker";
    private final MPConfig mConfig;
    private final Context mContext;
    private final Map<String, DecideMessages> mChecks;
    private final SystemInformation mSystemInformation;
    private static final JSONArray EMPTY_JSON_ARRAY = new JSONArray();
    private static final String AUTOMATIC_EVENTS = "automatic_events";

    public DecideChecker(Context context, MPConfig config) {
        this.mContext = context;
        this.mConfig = config;
        this.mChecks = new HashMap<String, DecideMessages>();
        this.mSystemInformation = SystemInformation.getInstance(context);
    }

    public void addDecideCheck(DecideMessages check) {
        this.mChecks.put(check.getToken(), check);
    }

    public void runDecideCheck(String token, RemoteService poster) throws RemoteService.ServiceUnavailableException {
        DecideMessages updates = this.mChecks.get(token);
        if (updates != null) {
            String distinctId = updates.getDistinctId();
            try {
                Result result = this.runDecideCheck(updates.getToken(), distinctId, poster);
                if (result != null) {
                    updates.reportResults(result.automaticEvents);
                }
            }
            catch (UnintelligibleMessageException e) {
                MPLog.e(LOGTAG, e.getMessage(), e);
            }
        }
    }

    private Result runDecideCheck(String token, String distinctId, RemoteService poster) throws RemoteService.ServiceUnavailableException, UnintelligibleMessageException {
        String responseString = this.getDecideResponseFromServer(token, distinctId, poster);
        MPLog.v(LOGTAG, "Mixpanel decide server response was:\n" + responseString);
        Result parsedResult = null;
        if (responseString != null) {
            parsedResult = DecideChecker.parseDecideResponse(responseString);
        }
        return parsedResult;
    }

    static Result parseDecideResponse(String responseString) throws UnintelligibleMessageException {
        JSONObject response;
        Result ret = new Result();
        try {
            response = new JSONObject(responseString);
        }
        catch (JSONException e) {
            String message = "Mixpanel endpoint returned unparsable result:\n" + responseString;
            throw new UnintelligibleMessageException(message, e);
        }
        if (response.has(AUTOMATIC_EVENTS)) {
            try {
                ret.automaticEvents = response.getBoolean(AUTOMATIC_EVENTS);
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Mixpanel endpoint returned a non boolean value for automatic events: " + response);
            }
        }
        return ret;
    }

    private String getDecideResponseFromServer(String unescapedToken, String unescapedDistinctId, RemoteService poster) throws RemoteService.ServiceUnavailableException {
        String escapedId;
        String escapedToken;
        try {
            escapedToken = URLEncoder.encode(unescapedToken, "utf-8");
            escapedId = null != unescapedDistinctId ? URLEncoder.encode(unescapedDistinctId, "utf-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Mixpanel library requires utf-8 string encoding to be available", e);
        }
        StringBuilder queryBuilder = new StringBuilder().append("?version=1&lib=android&token=").append(escapedToken);
        if (null != escapedId) {
            queryBuilder.append("&distinct_id=").append(escapedId);
        }
        queryBuilder.append("&properties=");
        JSONObject properties = new JSONObject();
        try {
            properties.putOpt("$android_lib_version", (Object)"6.2.2");
            properties.putOpt("$android_app_version", (Object)this.mSystemInformation.getAppVersionName());
            properties.putOpt("$android_version", (Object)Build.VERSION.RELEASE);
            properties.putOpt("$android_app_release", (Object)this.mSystemInformation.getAppVersionCode());
            properties.putOpt("$android_device_model", (Object)Build.MODEL);
            queryBuilder.append(URLEncoder.encode(properties.toString(), "utf-8"));
        }
        catch (Exception e) {
            MPLog.e(LOGTAG, "Exception constructing properties JSON", e.getCause());
        }
        String checkQuery = queryBuilder.toString();
        String url = this.mConfig.getDecideEndpoint() + checkQuery;
        MPLog.v(LOGTAG, "Querying decide server, url: " + url);
        byte[] response = DecideChecker.checkDecide(poster, this.mContext, url);
        if (null == response) {
            return null;
        }
        try {
            return new String(response, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF not supported on this platform?", e);
        }
    }

    private static byte[] checkDecide(RemoteService poster, Context context, String url) throws RemoteService.ServiceUnavailableException {
        MPConfig config = MPConfig.getInstance(context);
        if (!poster.isOnline(context, config.getOfflineMode())) {
            return null;
        }
        byte[] response = null;
        try {
            SSLSocketFactory socketFactory = config.getSSLSocketFactory();
            response = poster.performRequest(url, null, socketFactory);
        }
        catch (MalformedURLException e) {
            MPLog.e(LOGTAG, "Cannot interpret " + url + " as a URL.", e);
        }
        catch (FileNotFoundException e) {
            MPLog.v(LOGTAG, "Cannot get " + url + ", file not found.", e);
        }
        catch (IOException e) {
            MPLog.v(LOGTAG, "Cannot get " + url + ".", e);
        }
        catch (OutOfMemoryError e) {
            MPLog.e(LOGTAG, "Out of memory when getting to " + url + ".", e);
        }
        return response;
    }

    public DecideMessages getDecideMessages(String token) {
        return this.mChecks.get(token);
    }

    static class UnintelligibleMessageException
    extends Exception {
        private static final long serialVersionUID = -6501269367559104957L;

        public UnintelligibleMessageException(String message, JSONException cause) {
            super(message, cause);
        }
    }

    static class Result {
        public boolean automaticEvents = false;
    }
}

