/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import com.mixpanel.android.mpmetrics.ConnectIntegrations;
import com.mixpanel.android.mpmetrics.MPDbAdapter;
import com.mixpanel.android.util.MPLog;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

class DecideMessages {
    private String mDistinctId;
    private final String mToken;
    private Boolean mAutomaticEventsEnabled;
    private final Context mContext;
    private Set<String> mIntegrations;
    private final ConnectIntegrations mConnectIntegrations;
    private static final String LOGTAG = "MixpanelAPI.DecideUpdts";

    public DecideMessages(Context context, String token, ConnectIntegrations connectIntegrations) {
        this.mContext = context;
        this.mToken = token;
        this.mIntegrations = new HashSet<String>();
        this.mConnectIntegrations = connectIntegrations;
    }

    public String getToken() {
        return this.mToken;
    }

    public synchronized void setDistinctId(String distinctId) {
        this.mDistinctId = distinctId;
    }

    public synchronized String getDistinctId() {
        return this.mDistinctId;
    }

    public synchronized void reportResults(boolean automaticEvents, JSONArray integrations) {
        if (this.mAutomaticEventsEnabled == null && !automaticEvents) {
            MPDbAdapter.getInstance(this.mContext).cleanupAutomaticEvents(this.mToken);
        }
        this.mAutomaticEventsEnabled = automaticEvents;
        if (integrations != null) {
            try {
                HashSet<String> integrationsSet = new HashSet<String>();
                for (int i = 0; i < integrations.length(); ++i) {
                    integrationsSet.add(integrations.getString(i));
                }
                if (!this.mIntegrations.equals(integrationsSet)) {
                    this.mIntegrations = integrationsSet;
                    this.mConnectIntegrations.setupIntegrations(this.mIntegrations);
                }
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Got an integration id from " + integrations.toString() + " that wasn't an int", e);
            }
        }
    }

    public Boolean isAutomaticEventsEnabled() {
        return this.mAutomaticEventsEnabled;
    }

    public boolean shouldTrackAutomaticEvent() {
        return this.isAutomaticEventsEnabled() == null ? true : this.isAutomaticEventsEnabled();
    }
}

